/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorCloseable;

public class IteratorWithBuffer<T>
implements IteratorCloseable<T> {
    private List<T> lookahead;
    private Iterator<T> iter;
    private int capacity;
    private boolean innerHasEnded = false;

    public IteratorWithBuffer(Iterator<T> iter, int N) {
        if (N < 0) {
            throw new IllegalArgumentException("Buffering size < 0");
        }
        this.iter = iter;
        this.lookahead = new ArrayList<T>(N);
        this.capacity = N;
        for (int i = 0; i < N; ++i) {
            if (!iter.hasNext()) {
                this.atEndInner();
                break;
            }
            T nextItem = iter.next();
            this.lookahead.add(nextItem);
        }
    }

    @Override
    public boolean hasNext() {
        return this.lookahead.size() > 0;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException(this.getClass().getName());
        }
        if (!this.iter.hasNext()) {
            this.atEndInner();
        }
        T item = this.lookahead.remove(0);
        if (this.iter.hasNext()) {
            T nextItem = this.iter.next();
            this.lookahead.add(nextItem);
        }
        return item;
    }

    public T peek(int idx) {
        if (idx < 0 || idx >= this.capacity) {
            throw new IndexOutOfBoundsException("Index: " + idx);
        }
        if (idx >= this.lookahead.size()) {
            return null;
        }
        return this.lookahead.get(idx);
    }

    public int currentSize() {
        return this.lookahead.size();
    }

    public void set(int idx, T item) {
        this.lookahead.set(idx, item);
    }

    private void atEndInner() {
        if (!this.innerHasEnded) {
            this.innerHasEnded = true;
            this.endReachedInner();
        }
    }

    protected void endReachedInner() {
    }

    @Override
    public void close() {
        Iter.close(this.iter);
    }
}

