/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.flink.options;

import java.io.Serializable;
import java.util.List;
import org.apache.iotdb.flink.options.IoTDBOptions;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;

public class IoTDBSinkOptions
extends IoTDBOptions {
    private List<TimeseriesOption> timeseriesOptionList;

    public IoTDBSinkOptions() {
    }

    public IoTDBSinkOptions(String host, int port, String user, String password, List<TimeseriesOption> timeseriesOptionList) {
        super(host, port, user, password);
        this.timeseriesOptionList = timeseriesOptionList;
    }

    public List<TimeseriesOption> getTimeseriesOptionList() {
        return this.timeseriesOptionList;
    }

    public void setTimeseriesOptionList(List<TimeseriesOption> timeseriesOptionList) {
        this.timeseriesOptionList = timeseriesOptionList;
    }

    public static class TimeseriesOption
    implements Serializable {
        private String path;
        private TSDataType dataType = TSDataType.TEXT;
        private TSEncoding encoding = TSEncoding.PLAIN;
        private CompressionType compressor = CompressionType.SNAPPY;

        public TimeseriesOption() {
        }

        public TimeseriesOption(String path) {
            this.path = path;
        }

        public TimeseriesOption(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor) {
            this.path = path;
            this.dataType = dataType;
            this.encoding = encoding;
            this.compressor = compressor;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public TSDataType getDataType() {
            return this.dataType;
        }

        public void setDataType(TSDataType dataType) {
            this.dataType = dataType;
        }

        public TSEncoding getEncoding() {
            return this.encoding;
        }

        public void setEncoding(TSEncoding encoding) {
            this.encoding = encoding;
        }

        public CompressionType getCompressor() {
            return this.compressor;
        }

        public void setCompressor(CompressionType compressor) {
            this.compressor = compressor;
        }
    }
}

