/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.flink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.flink.Event;
import org.apache.iotdb.flink.IoTSerializationSchema;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class DefaultIoTSerializationSchema
implements IoTSerializationSchema<Map<String, String>> {
    private String fieldDevice = "device";
    private String fieldTimestamp = "timestamp";
    private String fieldMeasurements = "measurements";
    private String fieldValues = "values";
    private String fieldTypes = "types";
    private String separator = ",";

    @Override
    public Event serialize(Map<String, String> tuple) {
        if (tuple == null) {
            return null;
        }
        String device = tuple.get(this.fieldDevice);
        String ts = tuple.get(this.fieldTimestamp);
        Long timestamp = ts == null ? System.currentTimeMillis() : Long.parseLong(ts);
        List<String> measurements = null;
        if (tuple.get(this.fieldMeasurements) != null) {
            measurements = Arrays.asList(tuple.get(this.fieldMeasurements).split(this.separator));
        }
        ArrayList<TSDataType> types = new ArrayList<TSDataType>();
        for (String type : tuple.get(this.fieldTypes).split(this.separator)) {
            types.add(TSDataType.valueOf((String)type));
        }
        ArrayList<Object> values = new ArrayList<Object>();
        String[] valuesStr = tuple.get(this.fieldValues).split(this.separator);
        block9: for (int i = 0; i < valuesStr.length; ++i) {
            switch ((TSDataType)types.get(i)) {
                case INT64: {
                    values.add(Long.parseLong(valuesStr[i]));
                    continue block9;
                }
                case DOUBLE: {
                    values.add(Double.parseDouble(valuesStr[i]));
                    continue block9;
                }
                case INT32: {
                    values.add(Integer.parseInt(valuesStr[i]));
                    continue block9;
                }
                case TEXT: {
                    values.add(valuesStr[i]);
                    continue block9;
                }
                case FLOAT: {
                    values.add(Float.valueOf(Float.parseFloat(valuesStr[i])));
                    continue block9;
                }
                case BOOLEAN: {
                    values.add(Boolean.parseBoolean(valuesStr[i]));
                }
            }
        }
        return new Event(device, timestamp, measurements, types, values);
    }

    public String getFieldDevice() {
        return this.fieldDevice;
    }

    public void setFieldDevice(String fieldDevice) {
        this.fieldDevice = fieldDevice;
    }

    public String getFieldTimestamp() {
        return this.fieldTimestamp;
    }

    public void setFieldTimestamp(String fieldTimestamp) {
        this.fieldTimestamp = fieldTimestamp;
    }

    public String getFieldMeasurements() {
        return this.fieldMeasurements;
    }

    public void setFieldMeasurements(String fieldMeasurements) {
        this.fieldMeasurements = fieldMeasurements;
    }

    public String getFieldValues() {
        return this.fieldValues;
    }

    public void setFieldValues(String fieldValues) {
        this.fieldValues = fieldValues;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }
}

