/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.dell.ecs;

import com.emc.object.s3.S3Client;
import org.apache.iceberg.dell.DellProperties;
import org.apache.iceberg.dell.ecs.BaseEcsFile;
import org.apache.iceberg.dell.ecs.EcsAppendOutputStream;
import org.apache.iceberg.dell.ecs.EcsInputFile;
import org.apache.iceberg.dell.ecs.EcsURI;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.metrics.MetricsContext;

class EcsOutputFile
extends BaseEcsFile
implements OutputFile {
    public static EcsOutputFile fromLocation(String location, S3Client client) {
        return new EcsOutputFile(client, new EcsURI(location), new DellProperties(), MetricsContext.nullMetrics());
    }

    public static EcsOutputFile fromLocation(String location, S3Client client, DellProperties dellProperties) {
        return new EcsOutputFile(client, new EcsURI(location), dellProperties, MetricsContext.nullMetrics());
    }

    static EcsOutputFile fromLocation(String location, S3Client client, DellProperties dellProperties, MetricsContext metrics) {
        return new EcsOutputFile(client, new EcsURI(location), dellProperties, metrics);
    }

    EcsOutputFile(S3Client client, EcsURI uri, DellProperties dellProperties, MetricsContext metrics) {
        super(client, uri, dellProperties, metrics);
    }

    public PositionOutputStream create() {
        if (!this.exists()) {
            return this.createOrOverwrite();
        }
        throw new AlreadyExistsException("ECS object already exists: %s", new Object[]{this.uri()});
    }

    public PositionOutputStream createOrOverwrite() {
        return EcsAppendOutputStream.create(this.client(), this.uri(), this.metrics());
    }

    public InputFile toInputFile() {
        return new EcsInputFile(this.client(), this.uri(), this.dellProperties(), this.metrics());
    }
}

