/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.dell.ecs;

import com.emc.object.s3.S3Client;
import org.apache.iceberg.dell.DellProperties;
import org.apache.iceberg.dell.ecs.BaseEcsFile;
import org.apache.iceberg.dell.ecs.EcsSeekableInputStream;
import org.apache.iceberg.dell.ecs.EcsURI;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.metrics.MetricsContext;

class EcsInputFile
extends BaseEcsFile
implements InputFile {
    public static EcsInputFile fromLocation(String location, S3Client client) {
        return new EcsInputFile(client, new EcsURI(location), new DellProperties(), MetricsContext.nullMetrics());
    }

    public static EcsInputFile fromLocation(String location, S3Client client, DellProperties dellProperties) {
        return new EcsInputFile(client, new EcsURI(location), dellProperties, MetricsContext.nullMetrics());
    }

    static EcsInputFile fromLocation(String location, S3Client client, DellProperties dellProperties, MetricsContext metrics) {
        return new EcsInputFile(client, new EcsURI(location), dellProperties, metrics);
    }

    EcsInputFile(S3Client client, EcsURI uri, DellProperties dellProperties, MetricsContext metrics) {
        super(client, uri, dellProperties, metrics);
    }

    public long getLength() {
        return this.getObjectMetadata().getContentLength();
    }

    public SeekableInputStream newStream() {
        return new EcsSeekableInputStream(this.client(), this.uri(), this.metrics());
    }
}

