/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.storage.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hadoop.fs.inline.HadoopInLineFSUtils;
import org.apache.hudi.storage.StorageConfiguration;

public class HadoopStorageConfiguration
extends StorageConfiguration<Configuration> {
    private static final long serialVersionUID = 1L;
    private transient Configuration configuration;

    public HadoopStorageConfiguration(Boolean loadDefaults) {
        this(new Configuration(loadDefaults.booleanValue()));
    }

    public HadoopStorageConfiguration(Configuration configuration) {
        this(configuration, false);
    }

    public HadoopStorageConfiguration(Configuration configuration, boolean copy) {
        this.configuration = copy ? new Configuration(configuration) : configuration;
    }

    public HadoopStorageConfiguration(HadoopStorageConfiguration configuration) {
        this.configuration = configuration.unwrapCopy();
    }

    public StorageConfiguration<Configuration> newInstance() {
        return new HadoopStorageConfiguration(this);
    }

    public Configuration unwrap() {
        return this.configuration;
    }

    public Configuration unwrapCopy() {
        return new Configuration(this.configuration);
    }

    public void set(String key, String value) {
        this.configuration.set(key, value);
    }

    public Option<String> getString(String key) {
        return Option.ofNullable((Object)this.configuration.get(key));
    }

    public StorageConfiguration<Configuration> getInline() {
        return HadoopInLineFSUtils.buildInlineConf(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.configuration.iterator().forEachRemaining(e -> stringBuilder.append(String.format("%s => %s \n", e.getKey(), e.getValue())));
        return stringBuilder.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.configuration.write((DataOutput)out);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.configuration = new Configuration(false);
        this.configuration.readFields((DataInput)in);
    }
}

