/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TablePathUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TablePathUtils.class);

    private static boolean hasTableMetadataFolder(HoodieStorage storage, StoragePath path) {
        if (path == null) {
            return false;
        }
        try {
            return storage.exists(new StoragePath(path, ".hoodie"));
        }
        catch (IOException ioe) {
            throw new HoodieException("Error checking Hoodie metadata folder for " + path, (Throwable)ioe);
        }
    }

    public static boolean isHoodieTablePath(HoodieStorage storage, StoragePath path) {
        return TablePathUtils.hasTableMetadataFolder(storage, path);
    }

    public static Option<StoragePath> getTablePath(HoodieStorage storage, StoragePath path) throws HoodieException, IOException {
        StoragePath directory;
        LOG.info("Getting table path from path : " + path);
        StoragePathInfo pathInfo = storage.getPathInfo(path);
        StoragePath storagePath = directory = pathInfo.isFile() ? pathInfo.getPath().getParent() : pathInfo.getPath();
        if (TablePathUtils.hasTableMetadataFolder(storage, directory)) {
            return Option.of((Object)directory);
        }
        Option<StoragePath> tablePath = TablePathUtils.getTablePathFromMetaFolderPath(directory);
        if (tablePath.isPresent()) {
            return tablePath;
        }
        return TablePathUtils.getTablePathFromPartitionPath(storage, directory);
    }

    private static boolean isInsideTableMetaFolder(String path) {
        return path != null && path.contains("/.hoodie");
    }

    private static boolean isInsideMetadataTableInMetaFolder(String path) {
        return path != null && path.contains("/.hoodie/metadata");
    }

    private static Option<StoragePath> getTablePathFromMetaFolderPath(StoragePath path) {
        String pathStr = path.toString();
        if (TablePathUtils.isInsideTableMetaFolder(pathStr) && !TablePathUtils.isInsideMetadataTableInMetaFolder(pathStr)) {
            int index = pathStr.indexOf("/.hoodie");
            return Option.of((Object)new StoragePath(pathStr.substring(0, index)));
        }
        return Option.empty();
    }

    private static Option<StoragePath> getTablePathFromPartitionPath(HoodieStorage storage, StoragePath partitionPath) {
        try {
            if (HoodiePartitionMetadata.hasPartitionMetadata(storage, partitionPath)) {
                HoodiePartitionMetadata metadata = new HoodiePartitionMetadata(storage, partitionPath);
                metadata.readFromFS();
                return Option.of((Object)TablePathUtils.getNthParent(partitionPath, metadata.getPartitionDepth()));
            }
            for (StoragePath current = partitionPath; current != null; current = current.getParent()) {
                if (!TablePathUtils.hasTableMetadataFolder(storage, current)) continue;
                return Option.of((Object)current);
            }
            return Option.empty();
        }
        catch (IOException ioe) {
            throw new HoodieException("Error reading partition metadata for " + partitionPath, (Throwable)ioe);
        }
    }

    private static StoragePath getNthParent(StoragePath path, int n) {
        StoragePath parent = path;
        for (int i = 0; i < n; ++i) {
            parent = parent.getParent();
        }
        return parent;
    }
}

