/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.jobcontrol;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.jobcontrol.JobControlTestUtils;
import org.apache.hadoop.mapred.jobcontrol.TestJobControl;

/*
 * Exception performing whole class analysis ignored.
 */
public class JobControlTestUtils {
    private static Random rand = new Random();
    private static NumberFormat idFormat = NumberFormat.getInstance();

    static void cleanData(FileSystem fs, Path dirPath) throws IOException {
        fs.delete(dirPath, true);
    }

    private static String generateRandomWord() {
        return idFormat.format(rand.nextLong());
    }

    private static String generateRandomLine() {
        long r = rand.nextLong() % 7L;
        long n = r + 20L;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while ((long)i < n) {
            sb.append(JobControlTestUtils.generateRandomWord()).append(" ");
            ++i;
        }
        sb.append("\n");
        return sb.toString();
    }

    static void generateData(FileSystem fs, Path dirPath) throws IOException {
        FSDataOutputStream out = fs.create(new Path(dirPath, "data.txt"));
        for (int i = 0; i < 10000; ++i) {
            String line = JobControlTestUtils.generateRandomLine();
            out.write(line.getBytes("UTF-8"));
        }
        out.close();
    }

    static JobConf createCopyJob(List<Path> indirs, Path outdir) throws Exception {
        Configuration defaults = new Configuration();
        JobConf theJob = new JobConf(defaults, TestJobControl.class);
        theJob.setJobName("DataMoveJob");
        FileInputFormat.setInputPaths((JobConf)theJob, (Path[])indirs.toArray(new Path[0]));
        theJob.setMapperClass(DataCopy.class);
        FileOutputFormat.setOutputPath((JobConf)theJob, (Path)outdir);
        theJob.setOutputKeyClass(Text.class);
        theJob.setOutputValueClass(Text.class);
        theJob.setReducerClass(DataCopy.class);
        theJob.setNumMapTasks(12);
        theJob.setNumReduceTasks(4);
        return theJob;
    }

    static {
        idFormat.setMinimumIntegerDigits(4);
        idFormat.setGroupingUsed(false);
    }
}

