/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.datastream;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.functions.NullByteKeySelector;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.plan.nodes.CommonSort;
import org.apache.flink.table.plan.nodes.FlinkRelNode;
import org.apache.flink.table.plan.nodes.datastream.DataStreamRel;
import org.apache.flink.table.plan.schema.RowSchema;
import org.apache.flink.table.planner.StreamPlanner;
import org.apache.flink.table.runtime.aggregate.IdentityCRowMap;
import org.apache.flink.table.runtime.aggregate.SortUtil$;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.runtime.types.CRowTypeInfo$;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0001\u0003\u0001E\u0011a\u0002R1uCN#(/Z1n'>\u0014HO\u0003\u0002\u0004\t\u0005QA-\u0019;bgR\u0014X-Y7\u000b\u0005\u00151\u0011!\u00028pI\u0016\u001c(BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011!\u0002;bE2,'BA\u0006\r\u0003\u00151G.\u001b8l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0005\u000f!!\t\u0019\"$D\u0001\u0015\u0015\t)b#\u0001\u0003d_J,'BA\f\u0019\u0003\r\u0011X\r\u001c\u0006\u000331\tqaY1mG&$X-\u0003\u0002\u001c)\t!1k\u001c:u!\tib$D\u0001\u0005\u0013\tyBA\u0001\u0006D_6lwN\\*peR\u0004\"!\t\u0012\u000e\u0003\tI!a\t\u0002\u0003\u001b\u0011\u000bG/Y*ue\u0016\fWNU3m\u0011!)\u0003A!A!\u0002\u00131\u0013aB2mkN$XM\u001d\t\u0003O%j\u0011\u0001\u000b\u0006\u0003\u000faI!A\u000b\u0015\u0003\u001bI+Gn\u00149u\u00072,8\u000f^3s\u0011!a\u0003A!A!\u0002\u0013i\u0013\u0001\u0003;sC&$8+\u001a;\u0011\u0005\u001dr\u0013BA\u0018)\u0005-\u0011V\r\u001c+sC&$8+\u001a;\t\u0011E\u0002!\u0011!Q\u0001\nI\n\u0011\"\u001b8qkRtu\u000eZ3\u0011\u0005M\"T\"\u0001\f\n\u0005U2\"a\u0002*fY:{G-\u001a\u0005\to\u0001\u0011\t\u0011)A\u0005q\u0005Y\u0011N\u001c9viN\u001b\u0007.Z7b!\tID(D\u0001;\u0015\tYd!\u0001\u0004tG\",W.Y\u0005\u0003{i\u0012\u0011BU8x'\u000eDW-\\1\t\u0011m\u0002!\u0011!Q\u0001\naB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!Q\u0001\u000eg>\u0014HoQ8mY\u0006$\u0018n\u001c8\u0011\u0005M\u0012\u0015BA\"\u0017\u00051\u0011V\r\\\"pY2\fG/[8o\u0011!)\u0005A!A!\u0002\u00131\u0015AC:peR|eMZ:fiB\u0011qIS\u0007\u0002\u0011*\u0011\u0011\nG\u0001\u0004e\u0016D\u0018BA&I\u0005\u001d\u0011V\r\u001f(pI\u0016D\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IAR\u0001\ng>\u0014HOR3uG\"D\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001U\u0001\fI\u0016\u001c8M]5qi&|g\u000e\u0005\u0002R5:\u0011!\u000b\u0017\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+B\ta\u0001\u0010:p_Rt$\"A,\u0002\u000bM\u001c\u0017\r\\1\n\u0005e3\u0016A\u0002)sK\u0012,g-\u0003\u0002\\9\n11\u000b\u001e:j]\u001eT!!\u0017,\t\u000by\u0003A\u0011A0\u0002\rqJg.\u001b;?))\u0001\u0017MY2eK\u001a<\u0007.\u001b\t\u0003C\u0001AQ!J/A\u0002\u0019BQ\u0001L/A\u00025BQ!M/A\u0002IBQaN/A\u0002aBQaO/A\u0002aBQ\u0001Q/A\u0002\u0005CQ!R/A\u0002\u0019CQ!T/A\u0002\u0019CQaT/A\u0002ACQa\u001b\u0001\u0005B1\fQ\u0002Z3sSZ,'k\\<UsB,G#A7\u0011\u00059\fX\"A8\u000b\u0005A4\u0012\u0001\u0002;za\u0016L!A]8\u0003\u0017I+G\u000eR1uCRK\b/\u001a\u0005\u0006i\u0002!\t%^\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0013m^L80 \u0005\u0006YM\u0004\r!\f\u0005\u0006qN\u0004\rAM\u0001\u0006S:\u0004X\u000f\u001e\u0005\u0006uN\u0004\r!Q\u0001\r]\u0016<8i\u001c7mCRLwN\u001c\u0005\u0006yN\u0004\rAR\u0001\u0007_\u001a47/\u001a;\t\u000by\u001c\b\u0019\u0001$\u0002\u000b\u0019,Go\u00195\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004\u0005AAo\\*ue&tw\rF\u0001Q\u0011\u001d\t9\u0001\u0001C!\u0003\u0013\tA\"\u001a=qY\u0006Lg\u000eV3s[N$B!a\u0003\u0002\u0012A\u00191'!\u0004\n\u0007\u0005=aCA\u0005SK2<&/\u001b;fe\"A\u00111CA\u0003\u0001\u0004\tY!\u0001\u0002qo\"9\u0011q\u0003\u0001\u0005B\u0005e\u0011a\u0004;sC:\u001cH.\u0019;f)>\u0004F.\u00198\u0015\t\u0005m\u0011Q\b\t\u0007\u0003;\tI#!\f\u000e\u0005\u0005}!bA\u0002\u0002\")!\u00111EA\u0013\u0003\r\t\u0007/\u001b\u0006\u0004\u0003OQ\u0011!C:ue\u0016\fW.\u001b8h\u0013\u0011\tY#a\b\u0003\u0015\u0011\u000bG/Y*ue\u0016\fW\u000e\u0005\u0003\u00020\u0005eRBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\u000bQL\b/Z:\u000b\u0007\u0005]\u0002\"A\u0004sk:$\u0018.\\3\n\t\u0005m\u0012\u0011\u0007\u0002\u0005\u0007J{w\u000f\u0003\u0005\u0002@\u0005U\u0001\u0019AA!\u0003\u001d\u0001H.\u00198oKJ\u0004B!a\u0011\u0002H5\u0011\u0011Q\t\u0006\u0004\u0003\u007fA\u0011\u0002BA%\u0003\u000b\u0012Qb\u0015;sK\u0006l\u0007\u000b\\1o]\u0016\u0014\bbBA'\u0001\u0011\u0005\u0011qJ\u0001\u0013GJ,\u0017\r^3T_J$\bK]8d)&lW\r\u0006\u0004\u0002\u001c\u0005E\u0013Q\u000b\u0005\t\u0003'\nY\u00051\u0001\u0002\u001c\u00059\u0011N\u001c9vi\u0012\u001b\u0006\u0002CA,\u0003\u0017\u0002\r!!\u0017\u0002\u000f\u0015DXmY\"gOB!\u00111LA2\u001b\t\tiF\u0003\u0003\u0002`\u0005\u0005\u0014AB2p[6|gNC\u0002\u0002$)IA!!\u001a\u0002^\tyQ\t_3dkRLwN\\\"p]\u001aLw\rC\u0004\u0002j\u0001!\t!a\u001b\u0002#\r\u0014X-\u0019;f'>\u0014HOU8x)&lW\r\u0006\u0004\u0002\u001c\u00055\u0014q\u000e\u0005\t\u0003'\n9\u00071\u0001\u0002\u001c!A\u0011qKA4\u0001\u0004\tI\u0006")
public class DataStreamSort
extends Sort
implements CommonSort,
DataStreamRel {
    private final RelOptCluster cluster;
    private final RowSchema inputSchema;
    private final RowSchema schema;
    private final RelCollation sortCollation;
    private final RexNode sortOffset;
    private final RexNode sortFetch;
    private final String description;

    @Override
    public boolean needsUpdatesAsRetraction() {
        return DataStreamRel.needsUpdatesAsRetraction$(this);
    }

    @Override
    public boolean producesUpdates() {
        return DataStreamRel.producesUpdates$(this);
    }

    @Override
    public boolean consumesRetractions() {
        return DataStreamRel.consumesRetractions$(this);
    }

    @Override
    public boolean producesRetractions() {
        return DataStreamRel.producesRetractions$(this);
    }

    @Override
    public String getExpressionString(RexNode expr, Seq<String> inFields, Option<Seq<RexNode>> localExprsTable) {
        return FlinkRelNode.getExpressionString$(this, expr, inFields, localExprsTable);
    }

    @Override
    public double estimateRowSize(RelDataType rowType) {
        return FlinkRelNode.estimateRowSize$(this, rowType);
    }

    @Override
    public double estimateDataTypeSize(RelDataType t) {
        return FlinkRelNode.estimateDataTypeSize$(this, t);
    }

    @Override
    public long getFetchLimitEnd(RexNode fetch, RexNode offset) {
        return CommonSort.getFetchLimitEnd$(this, fetch, offset);
    }

    @Override
    public long getFetchLimitStart(RexNode offset) {
        return CommonSort.getFetchLimitStart$(this, offset);
    }

    @Override
    public String sortToString(RelDataType rowRelDataType, RelCollation sortCollation, RexNode sortOffset, RexNode sortFetch) {
        return CommonSort.sortToString$(this, rowRelDataType, sortCollation, sortOffset, sortFetch);
    }

    @Override
    public RelWriter sortExplainTerms(RelWriter pw, RelDataType rowRelDataType, RelCollation sortCollation, RexNode sortOffset, RexNode sortFetch) {
        return CommonSort.sortExplainTerms$(this, pw, rowRelDataType, sortCollation, sortOffset, sortFetch);
    }

    @Override
    public RelDataType deriveRowType() {
        return this.schema.relDataType();
    }

    @Override
    public Sort copy(RelTraitSet traitSet, RelNode input, RelCollation newCollation, RexNode offset, RexNode fetch) {
        return new DataStreamSort(this.cluster, traitSet, input, this.inputSchema, this.schema, newCollation, offset, fetch, this.description);
    }

    @Override
    public String toString() {
        return this.sortToString(this.schema.relDataType(), this.sortCollation, this.sortOffset, this.sortFetch);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return this.sortExplainTerms(pw.input("input", this.getInput()), this.schema.relDataType(), this.sortCollation, this.sortOffset, this.sortFetch);
    }

    @Override
    public DataStream<CRow> translateToPlan(StreamPlanner planner) {
        DataStream<CRow> dataStream;
        DataStream<CRow> inputDS = ((DataStreamRel)this.input).translateToPlan(planner);
        RelDataType timeType = SortUtil$.MODULE$.getFirstSortField(this.sortCollation, this.schema.relDataType()).getType();
        RelFieldCollation.Direction direction = SortUtil$.MODULE$.getFirstSortDirection(this.sortCollation);
        RelFieldCollation.Direction direction2 = RelFieldCollation.Direction.ASCENDING;
        if (direction == null ? direction2 != null : !((Object)((Object)direction)).equals((Object)direction2)) {
            throw new TableException("Primary sort order of a streaming table must be ascending on time.");
        }
        ExecutionConfig execCfg = planner.getExecutionEnvironment().getConfig();
        RelDataType relDataType = timeType;
        if (FlinkTypeFactory$.MODULE$.isProctimeIndicatorType(timeType)) {
            DataStream<CRow> dataStream2;
            Tuple2 tuple2 = new Tuple2((Object)this.sortOffset, (Object)this.sortFetch);
            if (tuple2 != null && tuple2._1() != null && tuple2._2() != null) {
                throw new TableException("Streaming tables do not support sort with offset and fetch.");
            }
            if (tuple2 != null && tuple2._2() != null) {
                throw new TableException("Streaming tables do not support sort with fetch.");
            }
            if (tuple2 != null && tuple2._1() != null) {
                throw new TableException("Streaming tables do not support sort with offset.");
            }
            dataStream = dataStream2 = this.createSortProcTime(inputDS, execCfg);
        } else if (FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType(timeType)) {
            Tuple2 tuple2 = new Tuple2((Object)this.sortOffset, (Object)this.sortFetch);
            if (tuple2 != null && tuple2._1() != null && tuple2._2() != null) {
                throw new TableException("Streaming tables do not support sort with offset and fetch");
            }
            if (tuple2 != null && tuple2._2() != null) {
                throw new TableException("Streaming tables do not support sort with fetch");
            }
            if (tuple2 != null && tuple2._1() != null) {
                throw new TableException("Streaming tables do not support sort with offset");
            }
            DataStream<CRow> dataStream3 = this.createSortRowTime(inputDS, execCfg);
            dataStream = dataStream3;
        } else {
            throw new TableException("Primary sort order of a streaming table must be ascending on time.");
        }
        return dataStream;
    }

    public DataStream<CRow> createSortProcTime(DataStream<CRow> inputDS, ExecutionConfig execCfg) {
        SingleOutputStreamOperator singleOutputStreamOperator;
        CRowTypeInfo returnTypeInfo = CRowTypeInfo$.MODULE$.apply(this.schema.typeInfo());
        if (this.sortCollation.getFieldCollations().size() > 1) {
            KeyedProcessFunction<Byte, CRow, CRow> KeyedProcessFunction2 = SortUtil$.MODULE$.createProcTimeSortFunction(this.sortCollation, this.inputSchema.relDataType(), this.inputSchema.typeInfo(), execCfg);
            singleOutputStreamOperator = inputDS.keyBy((KeySelector)new NullByteKeySelector()).process(KeyedProcessFunction2).setParallelism(1).setMaxParallelism(1).returns((TypeInformation)returnTypeInfo);
        } else {
            singleOutputStreamOperator = inputDS.map((MapFunction)new IdentityCRowMap()).setParallelism(1).setMaxParallelism(1).returns((TypeInformation)returnTypeInfo);
        }
        return singleOutputStreamOperator;
    }

    public DataStream<CRow> createSortRowTime(DataStream<CRow> inputDS, ExecutionConfig execCfg) {
        CRowTypeInfo returnTypeInfo = CRowTypeInfo$.MODULE$.apply(this.schema.typeInfo());
        KeyedProcessFunction<Byte, CRow, CRow> keyedProcessFunction = SortUtil$.MODULE$.createRowTimeSortFunction(this.sortCollation, this.inputSchema.relDataType(), this.inputSchema.typeInfo(), execCfg);
        return inputDS.keyBy((KeySelector)new NullByteKeySelector()).process(keyedProcessFunction).setParallelism(1).setMaxParallelism(1).returns((TypeInformation)returnTypeInfo);
    }

    public DataStreamSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode inputNode, RowSchema inputSchema, RowSchema schema, RelCollation sortCollation, RexNode sortOffset, RexNode sortFetch, String description) {
        this.cluster = cluster;
        this.inputSchema = inputSchema;
        this.schema = schema;
        this.sortCollation = sortCollation;
        this.sortOffset = sortOffset;
        this.sortFetch = sortFetch;
        this.description = description;
        super(cluster, traitSet, inputNode, sortCollation, sortOffset, sortFetch);
        CommonSort.$init$(this);
        FlinkRelNode.$init$(this);
        DataStreamRel.$init$(this);
    }
}

