/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSink;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.utils.PlanGenerator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.execution.DetachedJobExecutionResult;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.core.execution.PipelineExecutorFactory;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.BatchTableEnvImpl$;
import org.apache.flink.table.api.internal.Registration;
import org.apache.flink.table.api.internal.TableEnvImpl;
import org.apache.flink.table.calcite.CalciteConfig;
import org.apache.flink.table.calcite.CalciteConfig$;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.codegen.GeneratedFunction;
import org.apache.flink.table.descriptors.BatchTableDescriptor;
import org.apache.flink.table.descriptors.ConnectorDescriptor;
import org.apache.flink.table.explain.PlanJsonParser;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.utils.ApiExpressionDefaultVisitor;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.DataSetQueryOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.PlannerQueryOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.plan.BatchOptimizer;
import org.apache.flink.table.plan.nodes.LogicalSink;
import org.apache.flink.table.plan.nodes.LogicalSink$;
import org.apache.flink.table.plan.nodes.dataset.DataSetRel;
import org.apache.flink.table.planner.Conversions$;
import org.apache.flink.table.runtime.MapRunner;
import org.apache.flink.table.sinks.BatchTableSink;
import org.apache.flink.table.sinks.OutputFormatTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.BatchTableSource;
import org.apache.flink.table.sources.InputFormatTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.TableSourceValidation;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.typeutils.FieldInfoUtils;
import org.apache.flink.table.util.DummyNoOpOperator;
import org.apache.flink.table.utils.TableConnectorUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\r]f!B\u0001\u0003\u0003\u0003y!!\u0005\"bi\u000eDG+\u00192mK\u0016sg/S7qY*\u00111\u0001B\u0001\tS:$XM\u001d8bY*\u0011QAB\u0001\u0004CBL'BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003\u0019Q\u000b'\r\\3F]ZLU\u000e\u001d7\t\u0013U\u0001!Q1A\u0005\u0002!1\u0012aB3yK\u000e,eN^\u000b\u0002/A\u0011\u0001\u0004H\u0007\u00023)\u0011!dG\u0001\u0005U\u00064\u0018M\u0003\u0002\u0006\u0011%\u0011Q$\u0007\u0002\u0015\u000bb,7-\u001e;j_:,eN^5s_:lWM\u001c;\t\u0011}\u0001!\u0011!Q\u0001\n]\t\u0001\"\u001a=fG\u0016sg\u000f\t\u0005\nC\u0001\u0011\t\u0011)A\u0005E\u0019\naaY8oM&<\u0007CA\u0012%\u001b\u0005!\u0011BA\u0013\u0005\u0005-!\u0016M\u00197f\u0007>tg-[4\n\u0005\u0005\u0012\u0002\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\u0002\u001d\r\fG/\u00197pO6\u000bg.Y4feB\u0011!&L\u0007\u0002W)\u0011AFB\u0001\bG\u0006$\u0018\r\\8h\u0013\tq3F\u0001\bDCR\fGn\\4NC:\fw-\u001a:\t\u0011A\u0002!\u0011!Q\u0001\nE\nQ\"\\8ek2,W*\u00198bO\u0016\u0014\bC\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u0007\u0003\u0019iw\u000eZ;mK&\u0011ag\r\u0002\u000e\u001b>$W\u000f\\3NC:\fw-\u001a:\t\u000ba\u0002A\u0011A\u001d\u0002\rqJg.\u001b;?)\u0015Q4\bP\u001f?!\t\t\u0002\u0001C\u0003\u0016o\u0001\u0007q\u0003C\u0003\"o\u0001\u0007!\u0005C\u0003)o\u0001\u0007\u0011\u0006C\u00031o\u0001\u0007\u0011\u0007C\u0004A\u0001\t\u0007I\u0011B!\u00021\t,hMZ3sK\u0012lu\u000eZ5gs>\u0003XM]1uS>t7/F\u0001C!\r\u0019u)S\u0007\u0002\t*\u0011QIR\u0001\u0005kRLGNC\u0001\u001b\u0013\tAEIA\u0005BeJ\f\u0017\u0010T5tiB\u0011!*T\u0007\u0002\u0017*\u0011AJB\u0001\u000b_B,'/\u0019;j_:\u001c\u0018B\u0001(L\u0005=iu\u000eZ5gs>\u0003XM]1uS>t\u0007B\u0002)\u0001A\u0003%!)A\rck\u001a4WM]3e\u001b>$\u0017NZ=Pa\u0016\u0014\u0018\r^5p]N\u0004\u0003\u0002\u0003*\u0001\u0005\u0004%\t\u0001C*\u0002\u0013=\u0004H/[7ju\u0016\u0014X#\u0001+\u0011\u0005UCV\"\u0001,\u000b\u0005]3\u0011\u0001\u00029mC:L!!\u0017,\u0003\u001d\t\u000bGo\u00195PaRLW.\u001b>fe\"11\f\u0001Q\u0001\nQ\u000b!b\u001c9uS6L'0\u001a:!\u0011\u001di\u0006A1A\u0005\ny\u000bAB]3hSN$(/\u0019;j_:,\u0012a\u0018\n\u0004A\u0012Tg\u0001B1c\u0001}\u0013A\u0002\u0010:fM&tW-\\3oizBaa\u0019\u0001!\u0002\u0013y\u0016!\u0004:fO&\u001cHO]1uS>t\u0007\u0005\u0005\u0002fQ6\taM\u0003\u0002h\r\u0006!A.\u00198h\u0013\tIgM\u0001\u0004PE*,7\r\u001e\t\u0003#-L!\u0001\u001c\u0002\u0003\u0019I+w-[:ue\u0006$\u0018n\u001c8\t\u000b9\u0004A\u0011K8\u0002'Y\fG.\u001b3bi\u0016$\u0016M\u00197f'>,(oY3\u0015\u0005A4\bCA9u\u001b\u0005\u0011(\"A:\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0014(\u0001B+oSRDQa^7A\u0002a\f1\u0002^1cY\u0016\u001cv.\u001e:dKB\u001a\u00110a\u0001\u0011\u0007ilx0D\u0001|\u0015\tah!A\u0004t_V\u00148-Z:\n\u0005y\\(a\u0003+bE2,7k\\;sG\u0016\u0004B!!\u0001\u0002\u00041\u0001AaCA\u0003m\u0006\u0005\t\u0011!B\u0001\u0003\u000f\u00111a\u0018\u00132#\u0011\tI!a\u0004\u0011\u0007E\fY!C\u0002\u0002\u000eI\u0014qAT8uQ&tw\rE\u0002r\u0003#I1!a\u0005s\u0005\r\te.\u001f\u0005\b\u0003/\u0001A\u0011KA\r\u0003E1\u0018\r\\5eCR,G+\u00192mKNKgn\u001b\u000b\u0004a\u0006m\u0001\u0002CA\u000f\u0003+\u0001\r!a\b\u0002\u001d\r|gNZ5hkJ,GmU5oWB\"\u0011\u0011EA\u0018!\u0019\t\u0019#!\u000b\u0002.5\u0011\u0011Q\u0005\u0006\u0004\u0003O1\u0011!B:j].\u001c\u0018\u0002BA\u0016\u0003K\u0011\u0011\u0002V1cY\u0016\u001c\u0016N\\6\u0011\t\u0005\u0005\u0011q\u0006\u0003\r\u0003c\tY\"!A\u0001\u0002\u000b\u0005\u0011q\u0001\u0002\u0004?\u0012\"\u0004bBA\u001b\u0001\u0011\u0005\u0011qG\u0001\bG>tg.Z2u)\u0011\tI$!\u0012\u0011\t\u0005m\u0012\u0011I\u0007\u0003\u0003{Q1!a\u0010\u0007\u0003-!Wm]2sSB$xN]:\n\t\u0005\r\u0013Q\b\u0002\u0015\u0005\u0006$8\r\u001b+bE2,G)Z:de&\u0004Ho\u001c:\t\u0011\u0005\u001d\u00131\u0007a\u0001\u0003\u0013\n1cY8o]\u0016\u001cGo\u001c:EKN\u001c'/\u001b9u_J\u0004B!a\u000f\u0002L%!\u0011QJA\u001f\u0005M\u0019uN\u001c8fGR|'\u000fR3tGJL\u0007\u000f^8s\u0011\u001d\t\t\u0006\u0001C)\u0003'\nqc\u001e:ji\u0016$vnU5oW\u0006sG\r\u0016:b]Nd\u0017\r^3\u0016\t\u0005U\u0013Q\u0010\u000b\u0007\u0003/\nY'!\u001e1\t\u0005e\u0013q\r\t\u0007\u00037\n\t'!\u001a\u000e\u0005\u0005u#bAA03\u0005Iq\u000e]3sCR|'o]\u0005\u0005\u0003G\niF\u0001\u0005ECR\f7+\u001b8l!\u0011\t\t!a\u001a\u0005\u0019\u0005%\u0014qJA\u0001\u0002\u0003\u0015\t!a\u0002\u0003\u0007}#s\u0007\u0003\u0005\u0002n\u0005=\u0003\u0019AA8\u00039\tX/\u001a:z\u001fB,'/\u0019;j_:\u00042ASA9\u0013\r\t\u0019h\u0013\u0002\u000f#V,'/_(qKJ\fG/[8o\u0011!\t9(a\u0014A\u0002\u0005e\u0014!\u0003;bE2,7+\u001b8l!\u0019\t\u0019#!\u000b\u0002|A!\u0011\u0011AA?\t!\ty(a\u0014C\u0002\u0005\u001d!!\u0001+\t\u000f\u0005\r\u0005\u0001\"\u0015\u0002\u0006\u0006Y\u0011\r\u001a3U_\n+hMZ3s+\u0011\t9)!$\u0015\u0007A\fI\tC\u0004\u0002\f\u0006\u0005\u0005\u0019A%\u0002\u001f5|G-\u001b4z\u001fB,'/\u0019;j_:$\u0001\"a \u0002\u0002\n\u0007\u0011q\u0001\u0005\b\u0003#\u0003A\u0011BAJ\u0003M9W\r^\"p]Z,'o]5p]6\u000b\u0007\u000f]3s+\u0019\t)*a,\u00026RQ\u0011qSA]\u0003\u0013\f\u0019.!7\u0011\u000bE\fI*!(\n\u0007\u0005m%O\u0001\u0004PaRLwN\u001c\t\t\u0003?\u000bI+!,\u000246\u0011\u0011\u0011\u0015\u0006\u0005\u0003G\u000b)+A\u0005gk:\u001cG/[8og*\u0019\u0011qU\u000e\u0002\r\r|W.\\8o\u0013\u0011\tY+!)\u0003\u00175\u000b\u0007OR;oGRLwN\u001c\t\u0005\u0003\u0003\ty\u000b\u0002\u0005\u00022\u0006=%\u0019AA\u0004\u0005\tIe\n\u0005\u0003\u0002\u0002\u0005UF\u0001CA\\\u0003\u001f\u0013\r!a\u0002\u0003\u0007=+F\u000b\u0003\u0005\u0002<\u0006=\u0005\u0019AA_\u0003A\u0001\b._:jG\u0006dG+\u001f9f\u0013:4w\u000e\u0005\u0004\u0002@\u0006\u0015\u0017QV\u0007\u0003\u0003\u0003TA!a1\u0002&\u0006AA/\u001f9fS:4w.\u0003\u0003\u0002H\u0006\u0005'a\u0004+za\u0016LeNZ8s[\u0006$\u0018n\u001c8\t\u0011\u0005-\u0017q\u0012a\u0001\u0003\u001b\faa]2iK6\f\u0007cA\u0012\u0002P&\u0019\u0011\u0011\u001b\u0003\u0003\u0017Q\u000b'\r\\3TG\",W.\u0019\u0005\t\u0003+\fy\t1\u0001\u0002X\u0006\t\"/Z9vKN$X\r\u001a+za\u0016LeNZ8\u0011\r\u0005}\u0016QYAZ\u0011!\tY.a$A\u0002\u0005u\u0017\u0001\u00044v]\u000e$\u0018n\u001c8OC6,\u0007\u0003BAp\u0003[tA!!9\u0002jB\u0019\u00111\u001d:\u000e\u0005\u0005\u0015(bAAt\u001d\u00051AH]8pizJ1!a;s\u0003\u0019\u0001&/\u001a3fM&!\u0011q^Ay\u0005\u0019\u0019FO]5oO*\u0019\u00111\u001e:\t\u0011\u0005U\b\u0001\"\u0001\t\u0003o\fq!\u001a=qY\u0006Lg\u000e\u0006\u0004\u0002^\u0006e(\u0011\u0001\u0005\b\u000f\u0005M\b\u0019AA~!\r\u0019\u0013Q`\u0005\u0004\u0003\u007f$!!\u0002+bE2,\u0007\u0002\u0003B\u0002\u0003g\u0004\rA!\u0002\u0002\u0011\u0015DH/\u001a8eK\u0012\u00042!\u001dB\u0004\u0013\r\u0011IA\u001d\u0002\b\u0005>|G.Z1o\u0011\u001d\t)\u0010\u0001C!\u0005\u001b!B!!8\u0003\u0010!9qAa\u0003A\u0002\u0005m\bbBA{\u0001\u0011\u0005#1\u0003\u000b\u0005\u0003;\u0014)\u0002\u0003\u0005\u0003\u0004\tE\u0001\u0019\u0001B\u0003\u0011\u001d\u0011I\u0002\u0001C)\u00057\tq\"\u001a=qY\u0006Lg.\u00138uKJt\u0017\r\u001c\u000b\u0007\u0003;\u0014iBa\u000b\t\u000f1\u00139\u00021\u0001\u0003 A)1I!\t\u0003&%\u0019!1\u0005#\u0003\t1K7\u000f\u001e\t\u0004\u0015\n\u001d\u0012b\u0001B\u0015\u0017\nIq\n]3sCRLwN\u001c\u0005\t\u0005[\u00119\u00021\u0001\u00030\u0005aQ\r\u001f;sC\u0012+G/Y5mgB)\u0011O!\r\u00036%\u0019!1\u0007:\u0003\u0015q\u0012X\r]3bi\u0016$g\bE\u0002$\u0005oI1A!\u000f\u0005\u00055)\u0005\u0010\u001d7bS:$U\r^1jY\"9!Q\b\u0001\u0005B\t}\u0012aB3yK\u000e,H/\u001a\u000b\u0005\u0005\u0003\u0012I\u0005\u0005\u0003\u0003D\t\u0015SBAAS\u0013\u0011\u00119%!*\u0003%){'-\u0012=fGV$\u0018n\u001c8SKN,H\u000e\u001e\u0005\t\u0005\u0017\u0012Y\u00041\u0001\u0002^\u00069!n\u001c2OC6,\u0007b\u0002B\u001f\u0001\u0011E!q\n\u000b\u0007\u0005#\u0012\tG!\u001d\u0011\t\tM#QL\u0007\u0003\u0005+RAAa\u0016\u0003Z\u0005IQ\r_3dkRLwN\u001c\u0006\u0004\u00057B\u0011\u0001B2pe\u0016LAAa\u0018\u0003V\tI!j\u001c2DY&,g\u000e\u001e\u0005\t\u0005G\u0012i\u00051\u0001\u0003f\u0005IA-\u0019;b'&t7n\u001d\t\u0006\u0007\n\u0005\"q\r\u0019\u0005\u0005S\u0012i\u0007\u0005\u0004\u0002\\\u0005\u0005$1\u000e\t\u0005\u0003\u0003\u0011i\u0007\u0002\u0007\u0003p\t\u0005\u0014\u0011!A\u0001\u0006\u0003\t9AA\u0002`IaB\u0001Ba\u0013\u0003N\u0001\u0007\u0011Q\u001c\u0005\b\u0005k\u0002A\u0011\u0002B<\u0003=)\u00070Z2vi\u0016\u0004\u0016\u000e]3mS:,G\u0003\u0002B)\u0005sBqa\u0016B:\u0001\u0004\u0011Y\b\u0005\u0003\u0003~\t\rUB\u0001B@\u0015\r\u0011\tiG\u0001\u0004I\u0006<\u0017\u0002\u0002BC\u0005\u007f\u0012\u0001\u0002U5qK2Lg.\u001a\u0005\b\u0005\u0013\u0003A\u0011\u0001BF\u0003-9W\r\u001e)ja\u0016d\u0017N\\3\u0015\t\tm$Q\u0012\u0005\t\u0005\u0017\u00129\t1\u0001\u0002^\"9!\u0011\u0013\u0001\u0005\n\tM\u0015\u0001H2sK\u0006$X\rU5qK2Lg.Z!oI\u000ecW-\u0019:Ck\u001a4WM\u001d\u000b\u0005\u0005w\u0012)\n\u0003\u0005\u0003L\t=\u0005\u0019AAo\u0011\u001d\u0011I\n\u0001C\u0005\u00057\u000bab\u0019:fCR,\u0007+\u001b9fY&tW\r\u0006\u0004\u0003|\tu%1\u0016\u0005\t\u0003O\u00119\n1\u0001\u0003 B)1I!\t\u0003\"B\"!1\u0015BT!\u0019\tY&!\u0019\u0003&B!\u0011\u0011\u0001BT\t1\u0011IK!(\u0002\u0002\u0003\u0005)\u0011AA\u0004\u0005\ryF%\u000f\u0005\t\u0005\u0017\u00129\n1\u0001\u0002^\"9!q\u0016\u0001\u0005\u0012\tE\u0016\u0001E1t#V,'/_(qKJ\fG/[8o+\u0011\u0011\u0019L!0\u0015\r\tU&q\u0018Be!\u0015Q%q\u0017B^\u0013\r\u0011Il\u0013\u0002\u0016\t\u0006$\u0018mU3u#V,'/_(qKJ\fG/[8o!\u0011\t\tA!0\u0005\u0011\u0005}$Q\u0016b\u0001\u0003\u000fA\u0001B!1\u0003.\u0002\u0007!1Y\u0001\bI\u0006$\u0018mU3u!\u0015A\"Q\u0019B^\u0013\r\u00119-\u0007\u0002\b\t\u0006$\u0018mU3u\u0011!\u0011YM!,A\u0002\t5\u0017A\u00024jK2$7\u000fE\u0003r\u00033\u0013y\rE\u0003r\u0005#\u0014).C\u0002\u0003TJ\u0014Q!\u0011:sCf\u0004BAa6\u0003^6\u0011!\u0011\u001c\u0006\u0004\u000574\u0011aC3yaJ,7o]5p]NLAAa8\u0003Z\nQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u000f\t\r\b\u0001\"\u0003\u0003f\u0006)2\r[3dW:{G+[7f\u0003R$(/\u001b2vi\u0016\u001cX\u0003\u0002Bt\u0005[$2\u0001\u001dBu\u0011!\u0011YO!9A\u0002\t=\u0017!\u00014\u0005\u0011\u0005}$\u0011\u001db\u0001\u0003\u000fAqA!=\u0001\t\u0013\u0011\u00190\u0001\bue\u0006t7\u000f\\1uKR{'+\u001a7\u0015\r\tU8QAB\u0004!\u0011\u00119p!\u0001\u000e\u0005\te(\u0002\u0002B~\u0005{\f1A]3m\u0015\r\u0011yPC\u0001\bG\u0006d7-\u001b;f\u0013\u0011\u0019\u0019A!?\u0003\u000fI+GNT8eK\"9\u00111\u0012Bx\u0001\u0004I\u0005\u0002CB\u0005\u0005_\u0004\rA!\u0002\u0002\u001d\u0005$G\rT8hS\u000e\fGnU5oW\"91Q\u0002\u0001\u0005\n\r=\u0011!\u0003;sC:\u001cH.\u0019;f+\u0011\u0019\tb!\n\u0015\t\rM1q\u0004\t\u0006\u0007\n\u00052Q\u0003\u0019\u0005\u0007/\u0019Y\u0002\u0005\u0004\u0002\\\u0005\u00054\u0011\u0004\t\u0005\u0003\u0003\u0019Y\u0002\u0002\u0007\u0004\u001e\r-\u0011\u0011!A\u0001\u0006\u0003\t9A\u0001\u0003`IE\u0002\u0004\u0002CB\u0011\u0007\u0017\u0001\raa\t\u0002!5|G-\u001b4z\u001fB,'/\u0019;j_:\u001c\b\u0003B\"\u0003\"%#\u0001\"a \u0004\f\t\u0007\u0011q\u0001\u0005\b\u0007\u001b\u0001A\u0011BB\u0015+\u0011\u0019Yc!\u0012\u0015\u0015\r52qGB\u001e\u0007\u007f\u00199\u0005\r\u0003\u00040\rM\u0002CBA.\u0003C\u001a\t\u0004\u0005\u0003\u0002\u0002\rMB\u0001DB\u001b\u0007O\t\t\u0011!A\u0003\u0002\u0005\u001d!\u0001B0%cEBqa!\u000f\u0004(\u0001\u0007!(A\u0007cCR\u001c\u0007\u000eV1cY\u0016,eN\u001e\u0005\t\u0007{\u00199\u00031\u0001\u0003v\u0006iq\u000e\u001d;j[&TX\r\u001a(pI\u0016D\u0001\"a\u001e\u0004(\u0001\u00071\u0011\t\t\u0007\u0003G\tIca\u0011\u0011\t\u0005\u00051Q\t\u0003\t\u0003\u007f\u001a9C1\u0001\u0002\b!A1\u0011JB\u0014\u0001\u0004\ti-A\u0006uC\ndWmU2iK6\f\u0007bBB\u0007\u0001\u0011E1QJ\u000b\u0005\u0007\u001f\u001a9\u0006\u0006\u0003\u0004R\r\u0005D\u0003BB*\u00077\u0002R\u0001\u0007Bc\u0007+\u0002B!!\u0001\u0004X\u0011A1\u0011LB&\u0005\u0004\t9AA\u0001B\u0011!\u0019ifa\u0013A\u0004\r}\u0013a\u0001;qKB1\u0011qXAc\u0007+BqaBB&\u0001\u0004\tY\u0010C\u0004\u0004\u000e\u0001!\tb!\u001a\u0016\t\r\u001d4q\u000e\u000b\u0005\u0007S\u001a)\b\u0006\u0003\u0004l\rE\u0004#\u0002\r\u0003F\u000e5\u0004\u0003BA\u0001\u0007_\"\u0001b!\u0017\u0004d\t\u0007\u0011q\u0001\u0005\t\u0007;\u001a\u0019\u0007q\u0001\u0004tA1\u0011qXAc\u0007[B\u0001\"!\u001c\u0004d\u0001\u0007\u0011q\u000e\u0005\b\u0007\u001b\u0001A\u0011CB=+\u0011\u0019Yha!\u0015\r\ru4\u0011RBG)\u0011\u0019yh!\"\u0011\u000ba\u0011)m!!\u0011\t\u0005\u000511\u0011\u0003\t\u00073\u001a9H1\u0001\u0002\b!A1QLB<\u0001\b\u00199\t\u0005\u0004\u0002@\u0006\u00157\u0011\u0011\u0005\t\u0007\u0017\u001b9\b1\u0001\u0003v\u0006YAn\\4jG\u0006d\u0007\u000b\\1o\u0011!\u0019yia\u001eA\u0002\u00055\u0017a\u00037pO&\u001c\u0017\r\u001c+za\u0016Dqaa%\u0001\t\u0013\u0019)*\u0001\bhKR$\u0016M\u00197f'\u000eDW-\\1\u0015\r\u000557qSBO\u0011!\u0019Ij!%A\u0002\rm\u0015!D8sS\u001eLg.\u00197OC6,7\u000fE\u0003r\u0005#\fi\u000e\u0003\u0005\u0004 \u000eE\u0005\u0019\u0001B{\u00035y\u0007\u000f^5nSj,G\r\u00157b]\"911\u0015\u0001\u0005\n\r\u0015\u0016!E4fi\u0016C\b\u000f\\1j]\u0012+G/Y5mgR!1qUBU!\u0015\t(\u0011\u001bB\u001b\u0011!\u0011\u0019a!)A\u0002\t\u0015\u0001bBBW\u0001\u0019E1qV\u0001\u0019GJ,\u0017\r^3Ek6l\u0017PQ1uG\"$\u0016M\u00197f\u000b:4H#\u0001\u001e\t\u001b\rM\u0006\u0001%A\u0002\u0002\u0003%Ia!.'\u00031\u0019X\u000f]3sI\r|gNZ5h+\u0005\u0011\u0003")
public abstract class BatchTableEnvImpl
extends TableEnvImpl {
    private final ExecutionEnvironment execEnv;
    public final CatalogManager org$apache$flink$table$api$internal$BatchTableEnvImpl$$catalogManager;
    private final ArrayList<ModifyOperation> bufferedModifyOperations;
    private final BatchOptimizer optimizer;
    private final Registration registration;

    private /* synthetic */ TableConfig super$config() {
        return super.config();
    }

    public ExecutionEnvironment execEnv() {
        return this.execEnv;
    }

    private ArrayList<ModifyOperation> bufferedModifyOperations() {
        return this.bufferedModifyOperations;
    }

    public BatchOptimizer optimizer() {
        return this.optimizer;
    }

    private Registration registration() {
        return this.registration;
    }

    @Override
    public void validateTableSource(TableSource<?> tableSource) {
        TableSourceValidation.validateTableSource(tableSource, (TableSchema)tableSource.getTableSchema());
        if (!(tableSource instanceof BatchTableSource) && !(tableSource instanceof InputFormatTableSource)) {
            throw new TableException("Only BatchTableSource and InputFormatTableSource can be registered in BatchTableEnvironment.");
        }
    }

    @Override
    public void validateTableSink(TableSink<?> configuredSink) {
        if (!(configuredSink instanceof BatchTableSink) && !(configuredSink instanceof OutputFormatTableSink)) {
            throw new TableException("Only BatchTableSink and OutputFormatTableSink can be registered in BatchTableEnvironment.");
        }
    }

    public BatchTableDescriptor connect(ConnectorDescriptor connectorDescriptor) {
        return new BatchTableDescriptor(this.registration(), connectorDescriptor);
    }

    @Override
    public <T> DataSink<?> writeToSinkAndTranslate(QueryOperation queryOperation, TableSink<T> tableSink) {
        DataSink dataSink;
        BatchTableEnvImpl batchTableEnv = this.createDummyBatchTableEnv();
        TableSink<T> tableSink2 = tableSink;
        if (tableSink2 instanceof BatchTableSink) {
            BatchTableSink batchTableSink = (BatchTableSink)tableSink2;
            TypeInformation outputType = TypeConversions.fromDataTypeToLegacyInfo((DataType)tableSink.getConsumedDataType());
            DataSet result = this.translate(queryOperation, outputType);
            DummyNoOpOperator dummyOp = new DummyNoOpOperator(batchTableEnv.execEnv(), result, result.getType());
            dataSink = batchTableSink.consumeDataSet(dummyOp);
        } else if (tableSink2 instanceof OutputFormatTableSink) {
            OutputFormatTableSink outputFormatTableSink = (OutputFormatTableSink)tableSink2;
            TypeInformation outputType = TypeConversions.fromDataTypeToLegacyInfo((DataType)tableSink.getConsumedDataType());
            DataSet result = this.translate(queryOperation, outputType);
            DummyNoOpOperator dummyOp = new DummyNoOpOperator(batchTableEnv.execEnv(), result, result.getType());
            DataSink dataSink2 = dummyOp.output(outputFormatTableSink.getOutputFormat());
            dataSink = dataSink2.name(TableConnectorUtils.generateRuntimeName((Class)outputFormatTableSink.getClass(), (String[])outputFormatTableSink.getTableSchema().getFieldNames()));
        } else {
            throw new TableException("BatchTableSink or OutputFormatTableSink required to emit batch Table.");
        }
        return dataSink;
    }

    @Override
    public <T> void addToBuffer(ModifyOperation modifyOperation) {
        this.bufferedModifyOperations().add(modifyOperation);
    }

    private <IN, OUT> Option<MapFunction<IN, OUT>> getConversionMapper(TypeInformation<IN> physicalTypeInfo, TableSchema schema, TypeInformation<OUT> requestedTypeInfo, String functionName) {
        Option<GeneratedFunction<MapFunction<Row, OUT>, OUT>> converterFunction = Conversions$.MODULE$.generateRowConverterFunction(physicalTypeInfo, schema, requestedTypeInfo, functionName, super.config());
        return converterFunction.map((Function1 & Serializable & scala.Serializable)func -> new MapRunner(func.name(), func.code(), func.returnType()));
    }

    public String explain(Table table, boolean extended) {
        return this.explainInternal(Collections.singletonList(table.getQueryOperation()), (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.getExplainDetails(extended)));
    }

    public String explain(Table table) {
        return this.explain(table, false);
    }

    public String explain(boolean extended) {
        return this.explainInternal((List<Operation>)((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.bufferedModifyOperations()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1, Buffer$.MODULE$.canBuildFrom())).asJava()), (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.getExplainDetails(extended)));
    }

    @Override
    public String explainInternal(List<Operation> operations, Seq<ExplainDetail> extraDetails) {
        Predef$.MODULE$.require(((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(operations).asScala()).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "operations should not be empty");
        Buffer astList = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(operations).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            RelNode relNode;
            Operation operation = x0$1;
            if (operation instanceof QueryOperation) {
                RelNode relNode2;
                QueryOperation queryOperation = (QueryOperation)operation;
                RelNode relNode3 = this.getRelBuilder().tableOperation(queryOperation).build();
                RelNode relNode4 = relNode3;
                if (relNode4 instanceof LogicalTableModify) {
                    LogicalTableModify logicalTableModify = (LogicalTableModify)relNode4;
                    List<String> qualifiedName = logicalTableModify.getTable().getQualifiedName();
                    Predef$.MODULE$.require(qualifiedName.size() == 3, (Function0 & Serializable & scala.Serializable)() -> "the length of qualified name should be 3.");
                    CatalogSinkModifyOperation modifyOperation = new CatalogSinkModifyOperation(ObjectIdentifier.of((String)qualifiedName.get(0), (String)qualifiedName.get(1), (String)qualifiedName.get(2)), (QueryOperation)new PlannerQueryOperation(logicalTableModify.getInput()));
                    relNode2 = this.translateToRel((ModifyOperation)modifyOperation, true);
                } else {
                    relNode2 = relNode3;
                }
                relNode = relNode2;
            } else if (operation instanceof ModifyOperation) {
                ModifyOperation modifyOperation = (ModifyOperation)operation;
                relNode = this.translateToRel(modifyOperation, true);
            } else {
                throw new TableException(new StringBuilder(23).append("Unsupported operation: ").append(operation.asSummaryString()).toString());
            }
            return relNode;
        }, Buffer$.MODULE$.canBuildFrom());
        Buffer optimizedNodes = (Buffer)astList.map((Function1 & Serializable & scala.Serializable)relNode -> this.optimizer().optimize((RelNode)relNode), Buffer$.MODULE$.canBuildFrom());
        BatchTableEnvImpl batchTableEnv = this.createDummyBatchTableEnv();
        Buffer dataSinks = (Buffer)((TraversableLike)optimizedNodes.zip((GenIterable)JavaConverters$.MODULE$.asScalaBufferConverter(operations).asScala(), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            DataSink dataSink;
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            RelNode optimizedNode = (RelNode)tuple2._1();
            Operation operation = (Operation)tuple2._2();
            Operation operation2 = operation;
            if (operation2 instanceof QueryOperation) {
                PlannerQueryOperation plannerQueryOperation;
                QueryOperation queryOperation = (QueryOperation)operation2;
                QueryOperation queryOperation2 = queryOperation;
                String[] stringArray = queryOperation2 instanceof PlannerQueryOperation && (plannerQueryOperation = (PlannerQueryOperation)queryOperation2).getCalciteTree() instanceof LogicalTableModify ? (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(plannerQueryOperation.getCalciteTree().getInput(0).getRowType().getFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)) : queryOperation.getTableSchema().getFieldNames();
                String[] fieldNames = stringArray;
                DataSet dataSet = this.translate(optimizedNode, this.getTableSchema(fieldNames, optimizedNode), (TypeInformation)new GenericTypeInfo(Row.class));
                dataSink = dataSet.output((OutputFormat)new DiscardingOutputFormat());
                return dataSink;
            } else {
                if (!(operation2 instanceof ModifyOperation)) throw new TableException(new StringBuilder(23).append("Unsupported Operation: ").append(operation2.asSummaryString()).toString());
                ModifyOperation modifyOperation = (ModifyOperation)operation2;
                TableSink<?> tableSink = this.getTableSink(modifyOperation);
                dataSink = this.translate(batchTableEnv, optimizedNode, tableSink, this.getTableSchema(modifyOperation.getChild().getTableSchema().getFieldNames(), optimizedNode));
            }
            return dataSink;
        }, Buffer$.MODULE$.canBuildFrom());
        String astPlan = ((TraversableOnce)astList.map((Function1 & Serializable & scala.Serializable)x$1 -> RelOptUtil.toString(x$1), Buffer$.MODULE$.canBuildFrom())).mkString(System.lineSeparator());
        String optimizedPlan = ((TraversableOnce)optimizedNodes.map((Function1 & Serializable & scala.Serializable)x$1 -> RelOptUtil.toString(x$1), Buffer$.MODULE$.canBuildFrom())).mkString(System.lineSeparator());
        ExecutionEnvironment env = ((DataSink)dataSinks.head()).getDataSet().getExecutionEnvironment();
        String jasonSqlPlan = env.getExecutionPlan();
        boolean extended = extraDetails.contains((Object)ExplainDetail.ESTIMATED_COST);
        String sqlPlan = PlanJsonParser.getSqlExecutionPlan(jasonSqlPlan, Predef$.MODULE$.boolean2Boolean(extended));
        return new StringBuilder(83).append("== Abstract Syntax Tree ==").append(System.lineSeparator()).append(String.valueOf(astPlan)).append(System.lineSeparator()).append("== Optimized Logical Plan ==").append(System.lineSeparator()).append(String.valueOf(optimizedPlan)).append(System.lineSeparator()).append("== Physical Execution Plan ==").append(System.lineSeparator()).append(String.valueOf(sqlPlan)).toString();
    }

    public JobExecutionResult execute(String jobName) {
        DetachedJobExecutionResult detachedJobExecutionResult;
        block3: {
            Pipeline plan = this.createPipelineAndClearBuffer(jobName);
            try {
                JobClient jobClient = this.executePipeline(plan);
                if (this.execEnv().getConfiguration().getBoolean(DeploymentOptions.ATTACHED)) {
                    detachedJobExecutionResult = (JobExecutionResult)jobClient.getJobExecutionResult(this.execEnv().getUserCodeClassLoader()).get();
                    break block3;
                }
                detachedJobExecutionResult = new DetachedJobExecutionResult(jobClient.getJobID());
            }
            catch (Throwable t) {
                ExceptionUtils.rethrow((Throwable)t);
                detachedJobExecutionResult = null;
            }
        }
        return detachedJobExecutionResult;
    }

    @Override
    public JobClient execute(List<DataSink<?>> dataSinks, String jobName) {
        Pipeline plan = this.createPipeline(dataSinks, jobName);
        return this.executePipeline(plan);
    }

    private JobClient executePipeline(Pipeline plan) {
        JobClient jobClient;
        Configuration configuration = this.execEnv().getConfiguration();
        Preconditions.checkNotNull((Object)configuration.get(DeploymentOptions.TARGET), (String)"No execution.target specified in your configuration file.");
        PipelineExecutorFactory executorFactory = this.execEnv().getExecutorServiceLoader().getExecutorFactory(configuration);
        Preconditions.checkNotNull((Object)executorFactory, (String)"Cannot find compatible factory for specified execution.target (=%s)", (Object[])new Object[]{configuration.get(DeploymentOptions.TARGET)});
        CompletableFuture jobClientFuture = executorFactory.getExecutor(configuration).execute(plan, configuration);
        try {
            jobClient = (JobClient)jobClientFuture.get();
        }
        catch (Throwable t) {
            ExceptionUtils.rethrow((Throwable)t);
            jobClient = null;
        }
        return jobClient;
    }

    public Pipeline getPipeline(String jobName) {
        return this.createPipelineAndClearBuffer(jobName);
    }

    private Pipeline createPipelineAndClearBuffer(String jobName) {
        Pipeline pipeline;
        List<DataSink<?>> dataSinks = this.translate(this.bufferedModifyOperations());
        try {
            pipeline = this.createPipeline(dataSinks, jobName);
        }
        finally {
            this.bufferedModifyOperations().clear();
        }
        return pipeline;
    }

    private Pipeline createPipeline(List<DataSink<?>> sinks, String jobName) {
        Field cacheFileField = ExecutionEnvironment.class.getDeclaredField("cacheFile");
        cacheFileField.setAccessible(true);
        PlanGenerator generator = new PlanGenerator(sinks, this.execEnv().getConfig(), this.execEnv().getParallelism(), (List)cacheFileField.get(this.execEnv()), jobName);
        return generator.generate();
    }

    public <T> DataSetQueryOperation<T> asQueryOperation(DataSet<T> dataSet, Option<Expression[]> fields) {
        FieldInfoUtils.TypeInfoSchema typeInfoSchema;
        TypeInformation inputType = dataSet.getType();
        Option<Expression[]> option = fields;
        if (option instanceof Some) {
            Some some = (Some)option;
            Expression[] f = (Expression[])some.value();
            this.checkNoTimeAttributes(f);
            typeInfoSchema = FieldInfoUtils.getFieldsInfo((TypeInformation)inputType, (Expression[])f);
        } else if (None$.MODULE$.equals(option)) {
            typeInfoSchema = FieldInfoUtils.getFieldsInfo((TypeInformation)inputType);
        } else {
            throw new MatchError(option);
        }
        FieldInfoUtils.TypeInfoSchema fieldsInfo = typeInfoSchema;
        DataSetQueryOperation tableOperation = new DataSetQueryOperation(dataSet, fieldsInfo.getIndices(), fieldsInfo.toTableSchema());
        return tableOperation;
    }

    private <T> void checkNoTimeAttributes(Expression[] f2) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f2)).exists((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)BatchTableEnvImpl.$anonfun$checkNoTimeAttributes$1(f)))) {
            throw new ValidationException(".rowtime and .proctime time indicators are not allowed in a batch environment.");
        }
    }

    private RelNode translateToRel(ModifyOperation modifyOperation, boolean addLogicalSink) {
        RelNode relNode;
        RelNode input = this.getRelBuilder().tableOperation(modifyOperation.getChild()).build();
        if (addLogicalSink) {
            TableSink<?> tableSink = this.getTableSink(modifyOperation);
            ModifyOperation modifyOperation2 = modifyOperation;
            if (!(modifyOperation2 instanceof CatalogSinkModifyOperation)) {
                throw new TableException(new StringBuilder(23).append("Unsupported Operation: ").append(modifyOperation2.asSummaryString()).toString());
            }
            CatalogSinkModifyOperation catalogSinkModifyOperation = (CatalogSinkModifyOperation)modifyOperation2;
            LogicalSink logicalSink = LogicalSink$.MODULE$.create(input, tableSink, catalogSinkModifyOperation.getTableIdentifier().toString());
            relNode = logicalSink;
        } else {
            relNode = input;
        }
        return relNode;
    }

    private <T> List<DataSink<?>> translate(List<ModifyOperation> modifyOperations) {
        Buffer relNodes = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(modifyOperations).asScala()).map((Function1 & Serializable & scala.Serializable)o -> this.translateToRel((ModifyOperation)o, false), Buffer$.MODULE$.canBuildFrom());
        Buffer optimizedNodes = (Buffer)relNodes.map((Function1 & Serializable & scala.Serializable)relNode -> this.optimizer().optimize((RelNode)relNode), Buffer$.MODULE$.canBuildFrom());
        BatchTableEnvImpl batchTableEnv = this.createDummyBatchTableEnv();
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(modifyOperations).asScala()).zip((GenIterable)optimizedNodes, Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ModifyOperation modifyOperation = (ModifyOperation)tuple2._1();
            RelNode optimizedNode = (RelNode)tuple2._2();
            TableSink<?> tableSink = this.getTableSink(modifyOperation);
            DataSink<?> dataSink = this.translate(batchTableEnv, optimizedNode, tableSink, this.getTableSchema(modifyOperation.getChild().getTableSchema().getFieldNames(), optimizedNode));
            return dataSink;
        }, Buffer$.MODULE$.canBuildFrom())).asJava();
    }

    private <T> DataSink<?> translate(BatchTableEnvImpl batchTableEnv, RelNode optimizedNode, TableSink<T> tableSink, TableSchema tableSchema) {
        DataSink dataSink;
        TableSink<T> tableSink2 = tableSink;
        if (tableSink2 instanceof BatchTableSink) {
            BatchTableSink batchTableSink = (BatchTableSink)tableSink2;
            TypeInformation outputType = TypeConversions.fromDataTypeToLegacyInfo((DataType)tableSink.getConsumedDataType());
            DataSet result = this.translate(optimizedNode, tableSchema, outputType);
            DummyNoOpOperator dummyOp = new DummyNoOpOperator(batchTableEnv.execEnv(), result, result.getType());
            dataSink = batchTableSink.consumeDataSet(dummyOp);
        } else if (tableSink2 instanceof OutputFormatTableSink) {
            OutputFormatTableSink outputFormatTableSink = (OutputFormatTableSink)tableSink2;
            TypeInformation outputType = TypeConversions.fromDataTypeToLegacyInfo((DataType)tableSink.getConsumedDataType());
            DataSet result = this.translate(optimizedNode, tableSchema, outputType);
            DummyNoOpOperator dummyOp = new DummyNoOpOperator(batchTableEnv.execEnv(), result, result.getType());
            DataSink dataSink2 = dummyOp.output(outputFormatTableSink.getOutputFormat());
            dataSink = dataSink2.name(TableConnectorUtils.generateRuntimeName((Class)outputFormatTableSink.getClass(), (String[])outputFormatTableSink.getTableSchema().getFieldNames()));
        } else {
            throw new TableException("BatchTableSink or OutputFormatTableSink required to emit batch Table.");
        }
        return dataSink;
    }

    public <A> DataSet<A> translate(Table table, TypeInformation<A> tpe) {
        return this.translate(table.getQueryOperation(), tpe);
    }

    public <A> DataSet<A> translate(QueryOperation queryOperation, TypeInformation<A> tpe) {
        RelNode relNode = this.getRelBuilder().tableOperation(queryOperation).build();
        RelNode dataSetPlan = this.optimizer().optimize(relNode);
        return this.translate(dataSetPlan, this.getTableSchema(queryOperation.getTableSchema().getFieldNames(), dataSetPlan), tpe);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <A> DataSet<A> translate(RelNode logicalPlan, TableSchema logicalType, TypeInformation<A> tpe) {
        Operator operator;
        Option conversion;
        FieldInfoUtils.validateInputTypeInfo(tpe);
        RelNode relNode = logicalPlan;
        if (!(relNode instanceof DataSetRel)) throw new TableException("Cannot generate DataSet due to an invalid logical plan. This is a bug and should not happen. Please file an issue.");
        DataSetRel dataSetRel = (DataSetRel)relNode;
        this.execEnv().configure((ReadableConfig)super.config().getConfiguration(), Thread.currentThread().getContextClassLoader());
        Operator plan = dataSetRel.translateToPlan(this);
        Option option = conversion = this.getConversionMapper(plan.getType(), logicalType, tpe, "DataSetSinkConversion");
        if (None$.MODULE$.equals(option)) {
            operator = plan;
            return operator;
        } else {
            if (!(option instanceof Some)) throw new MatchError(option);
            Some some = (Some)option;
            MapFunction mapFunction = (MapFunction)some.value();
            if (mapFunction == null) throw new MatchError(option);
            MapFunction mapFunction2 = mapFunction;
            operator = plan.map(mapFunction2).returns(tpe).name(new StringBuilder(4).append("to: ").append(tpe.getTypeClass().getSimpleName()).toString());
        }
        return operator;
    }

    private TableSchema getTableSchema(String[] originalNames, RelNode optimizedPlan) {
        DataType[] fieldTypes = (DataType[])((TraversableOnce)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(optimizedPlan.getRowType().getFieldList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getType(), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)relDataType -> FlinkTypeFactory$.MODULE$.toTypeInfo((RelDataType)relDataType), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> TypeConversions.fromLegacyInfoToDataType((TypeInformation)x$1), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(DataType.class));
        return TableSchema.builder().fields(originalNames, fieldTypes).build();
    }

    private ExplainDetail[] getExplainDetails(boolean extended) {
        return extended ? (ExplainDetail[])((Object[])new ExplainDetail[]{ExplainDetail.ESTIMATED_COST}) : (ExplainDetail[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ExplainDetail.class));
    }

    public abstract BatchTableEnvImpl createDummyBatchTableEnv();

    public String explainInternal(List<Operation> operations, ExplainDetail[] extraDetails) {
        return this.explainInternal(operations, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    @Override
    public Table fromValues(AbstractDataType<?> rowType, Expression[] values) {
        return this.fromValues(rowType, (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])values));
    }

    @Override
    public Table fromValues(Expression[] values) {
        return this.fromValues((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])values));
    }

    @Override
    public String explainSql(String statement, ExplainDetail[] extraDetails) {
        return this.explainSql(statement, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    @Override
    public void insertInto(Table table, String sinkPath, String[] sinkPathContinued) {
        this.insertInto(table, sinkPath, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])sinkPathContinued));
    }

    @Override
    public Table scan(String[] tablePath) {
        return this.scan((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])tablePath));
    }

    public static final /* synthetic */ boolean $anonfun$checkNoTimeAttributes$1(Expression f) {
        return BoxesRunTime.unboxToBoolean((Object)f.accept((ExpressionVisitor)new ApiExpressionDefaultVisitor<Object>(null){

            public boolean visit(UnresolvedCallExpression call) {
                return BuiltInFunctionDefinitions.TIME_ATTRIBUTES.contains(call.getFunctionDefinition()) || ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(call.getChildren()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$visit$1(this, x$2)));
            }

            public boolean defaultMethod(Expression expression) {
                return false;
            }

            public static final /* synthetic */ boolean $anonfun$visit$1($anon$1 $this, Expression x$2) {
                return BoxesRunTime.unboxToBoolean((Object)x$2.accept((ExpressionVisitor)$this));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$visit$1$adapted(org.apache.flink.table.api.internal.BatchTableEnvImpl$$anon$1 org.apache.flink.table.expressions.Expression )}, serializedLambda);
            }
        }));
    }

    public BatchTableEnvImpl(ExecutionEnvironment execEnv, TableConfig config, CatalogManager catalogManager, ModuleManager moduleManager) {
        this.execEnv = execEnv;
        this.org$apache$flink$table$api$internal$BatchTableEnvImpl$$catalogManager = catalogManager;
        super(config, catalogManager, moduleManager);
        this.bufferedModifyOperations = new ArrayList();
        this.optimizer = new BatchOptimizer((Function0<CalciteConfig>)(Function0 & Serializable & scala.Serializable)() -> this.super$config().getPlannerConfig().unwrap(CalciteConfig.class).orElse(CalciteConfig$.MODULE$.DEFAULT()), this.planningConfigurationBuilder());
        this.registration = new Registration(this){
            private final /* synthetic */ BatchTableEnvImpl $outer;

            public void createTemporaryTable(String path, CatalogBaseTable table) {
                UnresolvedIdentifier unresolvedIdentifier = this.$outer.parseIdentifier(path);
                ObjectIdentifier objectIdentifier = this.$outer.org$apache$flink$table$api$internal$BatchTableEnvImpl$$catalogManager.qualifyIdentifier(unresolvedIdentifier);
                this.$outer.org$apache$flink$table$api$internal$BatchTableEnvImpl$$catalogManager.createTemporaryTable(table, objectIdentifier, false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

