/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import org.apache.calcite.util.Source;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.flink.calcite.shaded.com.google.common.io.CharSource;

public abstract class Sources {
    private Sources() {
    }

    public static Source of(File file) {
        return new FileSource(file);
    }

    public static Source of(URL url) {
        return new FileSource(url);
    }

    public static Source file(File baseDirectory, String fileName) {
        File file = new File(fileName);
        if (baseDirectory != null && !file.isAbsolute()) {
            return Sources.of(new File(baseDirectory, fileName));
        }
        return Sources.of(file);
    }

    public static Source fromCharSource(CharSource source) {
        return new GuavaCharSource(source);
    }

    public static Source url(String url) {
        try {
            return Sources.of(new URL(url));
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new RuntimeException("Malformed URL: '" + url + "'", e);
        }
    }

    private static String trimOrNull(String s, String suffix) {
        return s.endsWith(suffix) ? s.substring(0, s.length() - suffix.length()) : null;
    }

    private static boolean isFile(Source source) {
        return source.protocol().equals("file");
    }

    private static class FileSource
    implements Source {
        private final File file;
        private final URL url;

        private FileSource(URL url) {
            this.url = Objects.requireNonNull(url);
            this.file = FileSource.urlToFile(url);
        }

        private FileSource(File file) {
            this.file = Objects.requireNonNull(file);
            this.url = null;
        }

        private static File urlToFile(URL url) {
            URI uri;
            if (!"file".equals(url.getProtocol())) {
                return null;
            }
            try {
                uri = url.toURI();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to convert URL " + url + " to URI", e);
            }
            if (uri.isOpaque()) {
                return new File(uri.getSchemeSpecificPart());
            }
            return Paths.get(uri).toFile();
        }

        public String toString() {
            return (this.url != null ? this.url : this.file).toString();
        }

        @Override
        public URL url() {
            if (this.url == null) {
                throw new UnsupportedOperationException();
            }
            return this.url;
        }

        @Override
        public File file() {
            if (this.file == null) {
                throw new UnsupportedOperationException();
            }
            return this.file;
        }

        @Override
        public String protocol() {
            return this.file != null ? "file" : this.url.getProtocol();
        }

        @Override
        public String path() {
            if (this.file != null) {
                return this.file.getPath();
            }
            try {
                return this.url.toURI().getSchemeSpecificPart();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to convert URL " + this.url + " to URI", e);
            }
        }

        @Override
        public Reader reader() throws IOException {
            InputStream is;
            if (this.path().endsWith(".gz")) {
                InputStream fis = this.openStream();
                is = new GZIPInputStream(fis);
            } else {
                is = this.openStream();
            }
            return new InputStreamReader(is, StandardCharsets.UTF_8);
        }

        @Override
        public InputStream openStream() throws IOException {
            if (this.file != null) {
                return new FileInputStream(this.file);
            }
            return this.url.openStream();
        }

        @Override
        public Source trim(String suffix) {
            Source x = this.trimOrNull(suffix);
            return x == null ? this : x;
        }

        @Override
        public Source trimOrNull(String suffix) {
            if (this.url != null) {
                String s = Sources.trimOrNull(this.url.toExternalForm(), suffix);
                return s == null ? null : Sources.url(s);
            }
            String s = Sources.trimOrNull(this.file.getPath(), suffix);
            return s == null ? null : Sources.of(new File(s));
        }

        @Override
        public Source append(Source child) {
            if (Sources.isFile(child)) {
                if (child.file().isAbsolute()) {
                    return child;
                }
            } else {
                try {
                    URI uri = child.url().toURI();
                    if (!uri.isOpaque()) {
                        return child;
                    }
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Unable to convert URL " + child.url() + " to URI", e);
                }
            }
            String path = child.path();
            if (this.url != null) {
                String encodedPath = new File(".").toURI().relativize(new File(path).toURI()).getRawSchemeSpecificPart();
                return Sources.url(this.url + "/" + encodedPath);
            }
            return Sources.file(this.file, path);
        }

        @Override
        public Source relative(Source parent) {
            String rest;
            if (Sources.isFile(parent)) {
                String rest2;
                if (Sources.isFile(this) && this.file.getPath().startsWith(parent.file().getPath()) && (rest2 = this.file.getPath().substring(parent.file().getPath().length())).startsWith(File.separator)) {
                    return Sources.file(null, rest2.substring(File.separator.length()));
                }
                return this;
            }
            if (!Sources.isFile(this) && (rest = Sources.trimOrNull(this.url.toExternalForm(), parent.url().toExternalForm())) != null && rest.startsWith("/")) {
                return Sources.file(null, rest.substring(1));
            }
            return this;
        }
    }

    private static class GuavaCharSource
    implements Source {
        private final CharSource charSource;

        private GuavaCharSource(CharSource charSource) {
            this.charSource = Objects.requireNonNull(charSource, "charSource");
        }

        private UnsupportedOperationException unsupported() {
            return new UnsupportedOperationException(String.format(Locale.ROOT, "Invalid operation for '%s' protocol", this.protocol()));
        }

        @Override
        public URL url() {
            throw this.unsupported();
        }

        @Override
        public File file() {
            throw this.unsupported();
        }

        @Override
        public String path() {
            throw this.unsupported();
        }

        @Override
        public Reader reader() throws IOException {
            return this.charSource.openStream();
        }

        @Override
        public InputStream openStream() throws IOException {
            return new ReaderInputStream(this.reader(), StandardCharsets.UTF_8.name());
        }

        @Override
        public String protocol() {
            return "memory";
        }

        @Override
        public Source trim(String suffix) {
            throw this.unsupported();
        }

        @Override
        public Source trimOrNull(String suffix) {
            throw this.unsupported();
        }

        @Override
        public Source append(Source child) {
            throw this.unsupported();
        }

        @Override
        public Source relative(Source source) {
            throw this.unsupported();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{" + this.protocol() + "}";
        }
    }
}

