/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.ArrayList;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;

public class SqlSelectOperator
extends SqlOperator {
    public static final SqlSelectOperator INSTANCE = new SqlSelectOperator();

    private SqlSelectOperator() {
        super("SELECT", SqlKind.SELECT, 2, true, ReturnTypes.SCOPE, null, null);
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.SPECIAL;
    }

    @Override
    public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
        assert (functionQualifier == null);
        return new SqlSelect(pos, (SqlNodeList)operands[0], (SqlNodeList)operands[1], operands[2], operands[3], (SqlNodeList)operands[4], operands[5], (SqlNodeList)operands[6], (SqlNodeList)operands[7], operands[8], operands[9], (SqlNodeList)operands[10]);
    }

    public SqlSelect createCall(SqlNodeList keywordList, SqlNodeList selectList, SqlNode fromClause, SqlNode whereClause, SqlNodeList groupBy, SqlNode having, SqlNodeList windowDecls, SqlNodeList orderBy, SqlNode offset, SqlNode fetch, SqlNodeList hints, SqlParserPos pos) {
        return new SqlSelect(pos, keywordList, selectList, fromClause, whereClause, groupBy, having, windowDecls, orderBy, offset, fetch, hints);
    }

    @Override
    public <R> void acceptCall(SqlVisitor<R> visitor, SqlCall call, boolean onlyExpressions, SqlBasicVisitor.ArgHandler<R> argHandler) {
        if (!onlyExpressions) {
            super.acceptCall(visitor, call, onlyExpressions, argHandler);
        }
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlSelect select = (SqlSelect)call;
        SqlWriter.Frame selectFrame = writer.startList(SqlWriter.FrameTypeEnum.SELECT);
        writer.sep("SELECT");
        if (select.hasHints()) {
            writer.sep("/*+");
            select.hints.unparse(writer, leftPrec, rightPrec);
            writer.print("*/");
            writer.newlineAndIndent();
        }
        for (int i = 0; i < select.keywordList.size(); ++i) {
            SqlNode keyword = select.keywordList.get(i);
            keyword.unparse(writer, 0, 0);
        }
        writer.topN(select.fetch, select.offset);
        SqlNodeList selectClause = select.selectList != null ? select.selectList : SqlNodeList.of(SqlIdentifier.star(SqlParserPos.ZERO));
        writer.list(SqlWriter.FrameTypeEnum.SELECT_LIST, SqlWriter.COMMA, selectClause);
        if (select.from != null) {
            writer.sep("FROM");
            SqlWriter.Frame fromFrame = writer.startList(SqlWriter.FrameTypeEnum.FROM_LIST);
            select.from.unparse(writer, SqlJoin.OPERATOR.getLeftPrec() - 1, SqlJoin.OPERATOR.getRightPrec() - 1);
            writer.endList(fromFrame);
        }
        if (select.where != null) {
            writer.sep("WHERE");
            if (!writer.isAlwaysUseParentheses()) {
                SqlNode node = select.where;
                SqlBinaryOperator whereSep = SqlStdOperatorTable.AND;
                if (node instanceof SqlCall && node.getKind() == SqlKind.OR) {
                    whereSep = SqlStdOperatorTable.OR;
                }
                ArrayList<Object> list = new ArrayList<Object>(0);
                while (node.getKind() == whereSep.kind) {
                    assert (node instanceof SqlCall);
                    SqlCall call1 = (SqlCall)node;
                    list.add(0, call1.operand(1));
                    node = call1.operand(0);
                }
                list.add(0, node);
                writer.list(SqlWriter.FrameTypeEnum.WHERE_LIST, whereSep, new SqlNodeList(list, select.where.getParserPosition()));
            } else {
                select.where.unparse(writer, 0, 0);
            }
        }
        if (select.groupBy != null) {
            writer.sep("GROUP BY");
            SqlNodeList groupBy = select.groupBy.size() == 0 ? SqlNodeList.SINGLETON_EMPTY : select.groupBy;
            writer.list(SqlWriter.FrameTypeEnum.GROUP_BY_LIST, SqlWriter.COMMA, groupBy);
        }
        if (select.having != null) {
            writer.sep("HAVING");
            select.having.unparse(writer, 0, 0);
        }
        if (select.windowDecls.size() > 0) {
            writer.sep("WINDOW");
            writer.list(SqlWriter.FrameTypeEnum.WINDOW_DECL_LIST, SqlWriter.COMMA, select.windowDecls);
        }
        if (select.orderBy != null && select.orderBy.size() > 0) {
            writer.sep("ORDER BY");
            writer.list(SqlWriter.FrameTypeEnum.ORDER_BY_LIST, SqlWriter.COMMA, select.orderBy);
        }
        writer.fetchOffset(select.fetch, select.offset);
        writer.endList(selectFrame);
    }

    @Override
    public boolean argumentMustBeScalar(int ordinal) {
        return ordinal == 3;
    }
}

