/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.calcite.linq4j.function.Functions;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlUnresolvedFunction;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.implicit.TypeCoercion;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public class SqlFunction
extends SqlOperator {
    private final SqlFunctionCategory category;
    private final SqlIdentifier sqlIdentifier;
    private final List<RelDataType> paramTypes;

    public SqlFunction(String name, SqlKind kind, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory category) {
        this(name, null, kind, returnTypeInference, operandTypeInference, operandTypeChecker, null, category);
        assert (category != SqlFunctionCategory.USER_DEFINED_CONSTRUCTOR || returnTypeInference != null);
    }

    public SqlFunction(SqlIdentifier sqlIdentifier, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, List<RelDataType> paramTypes, SqlFunctionCategory funcType) {
        this(Util.last(sqlIdentifier.names), sqlIdentifier, SqlKind.OTHER_FUNCTION, returnTypeInference, operandTypeInference, operandTypeChecker, paramTypes, funcType);
    }

    protected SqlFunction(String name, SqlIdentifier sqlIdentifier, SqlKind kind, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, List<RelDataType> paramTypes, SqlFunctionCategory category) {
        super(name, kind, 100, 100, returnTypeInference, operandTypeInference, operandTypeChecker);
        this.sqlIdentifier = sqlIdentifier;
        this.category = Objects.requireNonNull(category);
        this.paramTypes = paramTypes == null ? null : ImmutableList.copyOf(paramTypes);
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.FUNCTION;
    }

    public SqlIdentifier getSqlIdentifier() {
        return this.sqlIdentifier;
    }

    @Override
    public SqlIdentifier getNameAsId() {
        if (this.sqlIdentifier != null) {
            return this.sqlIdentifier;
        }
        return super.getNameAsId();
    }

    public List<RelDataType> getParamTypes() {
        return this.paramTypes;
    }

    public List<String> getParamNames() {
        return Functions.generate(this.paramTypes.size(), i -> "arg" + i);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        this.getSyntax().unparse(writer, this, call, leftPrec, rightPrec);
    }

    @Nonnull
    public SqlFunctionCategory getFunctionType() {
        return this.category;
    }

    public boolean isQuantifierAllowed() {
        return false;
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        super.validateCall(call, validator, scope, operandScope);
        this.validateQuantifier(validator, call);
    }

    protected void validateQuantifier(SqlValidator validator, SqlCall call) {
        if (null != call.getFunctionQuantifier() && !this.isQuantifierAllowed()) {
            throw validator.newValidationError(call.getFunctionQuantifier(), Static.RESOURCE.functionQuantifierNotAllowed(call.getOperator().getName()));
        }
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        return this.deriveType(validator, scope, call, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call, boolean convertRowArgToColumnList) {
        SqlValidatorScope operandScope = scope.getOperandScope(call);
        validator.pushFunctionCall();
        List<String> argNames = this.constructArgNameList(call);
        List<SqlNode> args = this.constructOperandList(validator, call, argNames);
        List<RelDataType> argTypes = this.constructArgTypeList(validator, scope, call, args, convertRowArgToColumnList);
        SqlFunction function = (SqlFunction)SqlUtil.lookupRoutine(validator.getOperatorTable(), this.getNameAsId(), argTypes, argNames, this.getFunctionType(), SqlSyntax.FUNCTION, this.getKind(), validator.getCatalogReader().nameMatcher(), false);
        try {
            TypeCoercion typeCoercion;
            if (convertRowArgToColumnList && this.containsRowArg(args)) {
                if (function == null && SqlUtil.matchRoutinesByParameterCount(validator.getOperatorTable(), this.getNameAsId(), argTypes, this.getFunctionType(), validator.getCatalogReader().nameMatcher())) {
                    for (SqlNode operand : args) {
                        if (operand.getKind() != SqlKind.ROW) continue;
                        validator.removeValidatedNodeType(operand);
                    }
                    RelDataType relDataType = this.deriveType(validator, scope, call, false);
                    return relDataType;
                }
                if (function != null) {
                    validator.validateColumnListParams(function, argTypes, args);
                }
            }
            if (this.getFunctionType() == SqlFunctionCategory.USER_DEFINED_CONSTRUCTOR) {
                RelDataType relDataType = validator.deriveConstructorType(scope, call, this, function, argTypes);
                return relDataType;
            }
            if (!(function != null || validator.isTypeCoercionEnabled() && (function = (SqlFunction)SqlUtil.lookupRoutine(validator.getOperatorTable(), this.getNameAsId(), argTypes, argNames, this.getFunctionType(), SqlSyntax.FUNCTION, this.getKind(), validator.getCatalogReader().nameMatcher(), true)) != null && (typeCoercion = validator.getTypeCoercion()).userDefinedFunctionCoercion(scope, call, function))) {
                if (function == null && validator.isLenientOperatorLookup()) {
                    SqlFunction x = (SqlFunction)call.getOperator();
                    SqlIdentifier identifier = Util.first(x.getSqlIdentifier(), new SqlIdentifier(x.getName(), SqlParserPos.ZERO));
                    function = new SqlUnresolvedFunction(identifier, null, null, OperandTypes.VARIADIC, null, x.getFunctionType());
                } else {
                    throw validator.handleUnresolvedFunction(call, this, argTypes, argNames);
                }
            }
            ((SqlBasicCall)call).setOperator(function);
            RelDataType relDataType = function.validateOperands(validator, operandScope, call);
            return relDataType;
        }
        finally {
            validator.popFunctionCall();
        }
    }

    private boolean containsRowArg(List<SqlNode> args) {
        for (SqlNode operand : args) {
            if (operand.getKind() != SqlKind.ROW) continue;
            return true;
        }
        return false;
    }
}

