/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Sarg;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil;
import org.apache.flink.table.planner.plan.utils.InputRefVisitor;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class FlinkRexUtil$ {
    public static FlinkRexUtil$ MODULE$;
    @Experimental
    private final ConfigOption<Integer> TABLE_OPTIMIZER_CNF_NODES_LIMIT;
    private final Set<SqlKind> BINARY_COMPARISON;

    static {
        new FlinkRexUtil$();
    }

    public ConfigOption<Integer> TABLE_OPTIMIZER_CNF_NODES_LIMIT() {
        return this.TABLE_OPTIMIZER_CNF_NODES_LIMIT;
    }

    public RexNode toCnf(RexBuilder rexBuilder, int maxCnfNodeCount, RexNode rex) {
        int maxCnfNodeCnt = maxCnfNodeCount < 0 ? this.org$apache$flink$table$planner$plan$utils$FlinkRexUtil$$getNumberOfRexCall(rex) * 2 : maxCnfNodeCount;
        return new FlinkRexUtil.CnfHelper(rexBuilder, maxCnfNodeCnt).toCnf(rex);
    }

    public boolean containsExpectedInputRef(RexNode rex, ImmutableBitSet expectedInputRefs) {
        InputRefVisitor visitor = new InputRefVisitor();
        rex.accept(visitor);
        ImmutableBitSet inputRefs = ImmutableBitSet.of(visitor.getFields());
        return !inputRefs.intersect(expectedInputRefs).isEmpty();
    }

    public int org$apache$flink$table$planner$plan$utils$FlinkRexUtil$$getNumberOfRexCall(RexNode rex) {
        IntRef numberOfNodes = IntRef.create((int)0);
        rex.accept(new RexVisitorImpl<BoxedUnit>(numberOfNodes){
            private final IntRef numberOfNodes$1;

            public void visitCall(RexCall call) {
                ++this.numberOfNodes$1.elem;
                super.visitCall(call);
            }
            {
                this.numberOfNodes$1 = numberOfNodes$1;
                super(true);
            }
        });
        return numberOfNodes.elem;
    }

    public RexNode simplify(RexBuilder rexBuilder, RexNode expr, RexExecutor executor) {
        if (expr.isAlwaysTrue() || expr.isAlwaysFalse()) {
            return expr;
        }
        FlinkRexUtil.EquivalentExprShuttle exprShuttle = new FlinkRexUtil.EquivalentExprShuttle(rexBuilder);
        RexNode equiExpr = expr.accept(exprShuttle);
        FlinkRexUtil.SameExprMerger exprMerger = new FlinkRexUtil.SameExprMerger(rexBuilder);
        RexNode sameExprMerged = exprMerger.mergeSameExpr(equiExpr);
        RexNode binaryComparisonExprReduced = sameExprMerged.accept(new FlinkRexUtil.BinaryComparisonExprReducer(rexBuilder));
        RexSimplify rexSimplify = new RexSimplify(rexBuilder, RelOptPredicateList.EMPTY, true, executor);
        return rexSimplify.simplify(binaryComparisonExprReduced);
    }

    public Set<SqlKind> BINARY_COMPARISON() {
        return this.BINARY_COMPARISON;
    }

    /*
     * WARNING - void declaration
     */
    public HashSet<RexInputRef> findAllInputRefs(RexNode node) {
        void var2_2;
        HashSet set = new HashSet();
        node.accept(new RexVisitorImpl<Void>(set){
            private final HashSet set$1;

            public Void visitInputRef(RexInputRef inputRef) {
                this.set$1.add(inputRef);
                return null;
            }
            {
                this.set$1 = set$1;
                super(true);
            }
        });
        return var2_2;
    }

    public RexNode adjustInputRef(RexNode expr, scala.collection.immutable.Map<Object, Object> fieldsOldToNewIndexMapping, RelDataType rowType) {
        return expr.accept(new RexShuttle(fieldsOldToNewIndexMapping, rowType){
            private final scala.collection.immutable.Map fieldsOldToNewIndexMapping$2;
            private final RelDataType rowType$1;

            /*
             * WARNING - void declaration
             */
            public RexNode visitInputRef(RexInputRef inputRef) {
                void var3_3;
                Predef$.MODULE$.require(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)this.fieldsOldToNewIndexMapping$2).containsKey(BoxesRunTime.boxToInteger((int)inputRef.getIndex())));
                int newIndex = BoxesRunTime.unboxToInt((Object)this.fieldsOldToNewIndexMapping$2.apply((Object)BoxesRunTime.boxToInteger((int)inputRef.getIndex())));
                RexInputRef ref = RexInputRef.of(newIndex, this.rowType$1);
                return ref.getIndex() == inputRef.getIndex() && ref.getType() == inputRef.getType() ? inputRef : var3_3;
            }
            {
                this.fieldsOldToNewIndexMapping$2 = fieldsOldToNewIndexMapping$2;
                this.rowType$1 = rowType$1;
            }
        });
    }

    public Tuple2<Seq<RexNode>, Option<RexNode>> expandRexProgram(RexProgram program) {
        Buffer projection = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(program.getProjectList()).map((Function1 & Serializable & scala.Serializable)x$1 -> program.expandLocalRef((RexLocalRef)x$1), Buffer$.MODULE$.canBuildFrom());
        None$ filter = program.getCondition() != null ? new Some((Object)program.expandLocalRef(program.getCondition())) : None$.MODULE$;
        return new Tuple2((Object)projection, (Object)filter);
    }

    public RexNode expandSearch(RexBuilder rexBuilder, RexNode rex) {
        return this.expandSearch(rexBuilder, rex, (Function1<RexCall, Object>)(Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FlinkRexUtil$.$anonfun$expandSearch$1(x$1)));
    }

    public RexNode expandSearch(RexBuilder rexBuilder, RexNode rex, Function1<RexCall, Object> tester) {
        RexShuttle shuttle = new RexShuttle(rexBuilder, tester){
            private final RexBuilder rexBuilder$2;
            private final Function1 tester$1;

            public RexNode visitCall(RexCall call) {
                SqlKind sqlKind = call.getKind();
                SqlKind sqlKind2 = SqlKind.SEARCH;
                return !(sqlKind != null ? !((Object)((Object)sqlKind)).equals((Object)((Object)sqlKind2)) : sqlKind2 != null) && BoxesRunTime.unboxToBoolean((Object)this.tester$1.apply((Object)call)) ? RexUtil.expandSearch(this.rexBuilder$2, null, call) : super.visitCall(call);
            }
            {
                this.rexBuilder$2 = rexBuilder$2;
                this.tester$1 = tester$1;
            }
        };
        return rex.accept(shuttle);
    }

    public java.util.List<RexNode> expandSearchOperands(RexBuilder rexBuilder, RexCall call) {
        SqlKind sqlKind = call.getKind();
        SqlKind sqlKind2 = SqlKind.SEARCH;
        Predef$.MODULE$.require(!(sqlKind != null ? !((Object)((Object)sqlKind)).equals((Object)sqlKind2) : sqlKind2 != null));
        RexLiteral sargLiteral = (RexLiteral)call.getOperands().get(1);
        Sarg sarg = sargLiteral.getValueAs(Sarg.class);
        Predef$.MODULE$.require(sarg.isPoints());
        scala.collection.mutable.Set sargOperands = (scala.collection.mutable.Set)JavaConversions$.MODULE$.deprecated$u0020asScalaSet(sarg.rangeSet.asRanges()).map((Function1 & Serializable & scala.Serializable)range -> rexBuilder.makeLiteral(range.lowerEndpoint(), sargLiteral.getType(), false), Set$.MODULE$.canBuildFrom());
        return JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)((RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(call.getOperands()).head()), (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)sargOperands, List$.MODULE$.canBuildFrom()));
    }

    public RexNode adjustInputRef(RexNode expr, scala.collection.immutable.Map<Object, Object> fieldsOldToNewIndexMapping) {
        return expr.accept(new RexShuttle(fieldsOldToNewIndexMapping){
            private final scala.collection.immutable.Map fieldsOldToNewIndexMapping$1;

            public RexNode visitInputRef(RexInputRef inputRef) {
                Predef$.MODULE$.require(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)this.fieldsOldToNewIndexMapping$1).containsKey(BoxesRunTime.boxToInteger((int)inputRef.getIndex())));
                int newIndex = BoxesRunTime.unboxToInt((Object)this.fieldsOldToNewIndexMapping$1.apply((Object)BoxesRunTime.boxToInteger((int)inputRef.getIndex())));
                return new RexInputRef(newIndex, inputRef.getType());
            }
            {
                this.fieldsOldToNewIndexMapping$1 = fieldsOldToNewIndexMapping$1;
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$expandSearch$1(RexCall x$1) {
        return true;
    }

    private FlinkRexUtil$() {
        MODULE$ = this;
        this.TABLE_OPTIMIZER_CNF_NODES_LIMIT = ConfigOptions.key((String)"table.optimizer.cnf-nodes-limit").defaultValue((Object)-1).withDescription("When converting to conjunctive normal form (CNF, like '(a AND b) OR c' will be converted to '(a OR c) AND (b OR c)'), fail if the expression  exceeds this threshold; (e.g. predicate in TPC-DS q41.sql will be converted to hundreds of thousands of CNF nodes.) the threshold is expressed in terms of number of nodes (only count RexCall node, including leaves and interior nodes). Negative number to use the default threshold: double of number of nodes.");
        this.BINARY_COMPARISON = EnumSet.of(SqlKind.EQUALS, (Enum[])new SqlKind[]{SqlKind.NOT_EQUALS, SqlKind.GREATER_THAN, SqlKind.GREATER_THAN_OR_EQUAL, SqlKind.LESS_THAN, SqlKind.LESS_THAN_OR_EQUAL});
    }
}

