/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.typeutils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.dataview.DataView;
import org.apache.flink.table.api.dataview.ListView;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.dataview.NullSerializer;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.inference.TypeTransformation;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.DataTypeUtils;

@Internal
public final class DataViewUtils {
    public static List<DataViewSpec> extractDataViews(int aggIndex, DataType accumulatorDataType) {
        LogicalType accumulatorType = accumulatorDataType.getLogicalType();
        if (!LogicalTypeChecks.hasRoot((LogicalType)accumulatorType, (LogicalTypeRoot)LogicalTypeRoot.ROW) && !LogicalTypeChecks.hasRoot((LogicalType)accumulatorType, (LogicalTypeRoot)LogicalTypeRoot.STRUCTURED_TYPE)) {
            return Collections.emptyList();
        }
        List fieldNames = LogicalTypeChecks.getFieldNames((LogicalType)accumulatorType);
        List fieldDataTypes = accumulatorDataType.getChildren();
        ArrayList<DataViewSpec> specs = new ArrayList<DataViewSpec>();
        for (int fieldIndex = 0; fieldIndex < fieldDataTypes.size(); ++fieldIndex) {
            DataType fieldDataType = (DataType)fieldDataTypes.get(fieldIndex);
            LogicalType fieldType = fieldDataType.getLogicalType();
            if (DataViewUtils.isDataView(fieldType, ListView.class)) {
                specs.add(new ListViewSpec(DataViewUtils.createStateId(aggIndex, (String)fieldNames.get(fieldIndex)), fieldIndex, (DataType)fieldDataType.getChildren().get(0)));
            } else if (DataViewUtils.isDataView(fieldType, MapView.class)) {
                specs.add(new MapViewSpec(DataViewUtils.createStateId(aggIndex, (String)fieldNames.get(fieldIndex)), fieldIndex, (DataType)fieldDataType.getChildren().get(0), false));
            }
            if (!fieldType.getChildren().stream().anyMatch(c -> LogicalTypeChecks.hasNested((LogicalType)c, t -> DataViewUtils.isDataView(t, DataView.class)))) continue;
            throw new TableException("Data views are only supported in the first level of a composite accumulator type.");
        }
        return specs;
    }

    public static DataType replaceDataViewsWithNull(DataType accumulatorDataType) {
        return DataTypeUtils.transform((DataType)accumulatorDataType, (TypeTransformation[])new TypeTransformation[]{DataViewsTransformation.INSTANCE});
    }

    public static DataType createDistinctViewDataType(DataType keyDataType, int filterArgs, int filterArgsLimit) {
        DataType valueDataType = filterArgs <= filterArgsLimit ? (DataType)DataTypes.BIGINT().notNull() : (DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.BIGINT().notNull())).bridgedTo(long[].class);
        return MapView.newMapViewDataType((DataType)keyDataType, (DataType)valueDataType);
    }

    public static DistinctViewSpec createDistinctViewSpec(int index, DataType distinctViewDataType) {
        return new DistinctViewSpec("distinctAcc_" + index, distinctViewDataType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isDataView(LogicalType t, Class<? extends DataView> viewClass) {
        if (!LogicalTypeChecks.hasRoot((LogicalType)t, (LogicalTypeRoot)LogicalTypeRoot.STRUCTURED_TYPE)) return false;
        if (((StructuredType)t).getImplementationClass().map(viewClass::isAssignableFrom).orElse(false) == false) return false;
        return true;
    }

    private static String createStateId(int fieldIndex, String fieldName) {
        return "agg" + fieldIndex + "$" + fieldName;
    }

    private DataViewUtils() {
    }

    public static class DistinctViewSpec
    extends MapViewSpec {
        private final DataType distinctViewDataType;

        public DistinctViewSpec(String stateId, DataType distinctViewDataType) {
            super(stateId, -1, (DataType)distinctViewDataType.getChildren().get(0), true);
            this.distinctViewDataType = distinctViewDataType;
        }

        public DataType getDistinctViewDataType() {
            return this.distinctViewDataType;
        }
    }

    public static class MapViewSpec
    extends DataViewSpec {
        private final boolean containsNullKey;
        @Nullable
        private final TypeSerializer<?> keySerializer;
        @Nullable
        private final TypeSerializer<?> valueSerializer;

        public MapViewSpec(String stateId, int fieldIndex, DataType dataType, boolean containsNullKey) {
            this(stateId, fieldIndex, dataType, containsNullKey, null, null);
        }

        @Deprecated
        public MapViewSpec(String stateId, int fieldIndex, DataType dataType, boolean containsNullKey, TypeSerializer<?> keySerializer, TypeSerializer<?> valueSerializer) {
            super(stateId, fieldIndex, dataType);
            this.containsNullKey = containsNullKey;
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
        }

        public DataType getKeyDataType() {
            KeyValueDataType mapDataType = (KeyValueDataType)this.getDataType();
            return mapDataType.getKeyDataType();
        }

        public DataType getValueDataType() {
            KeyValueDataType mapDataType = (KeyValueDataType)this.getDataType();
            return mapDataType.getValueDataType();
        }

        public Optional<TypeSerializer<?>> getKeySerializer() {
            return Optional.ofNullable(this.keySerializer);
        }

        public Optional<TypeSerializer<?>> getValueSerializer() {
            return Optional.ofNullable(this.valueSerializer);
        }

        public boolean containsNullKey() {
            return this.containsNullKey;
        }
    }

    public static class ListViewSpec
    extends DataViewSpec {
        @Nullable
        private final TypeSerializer<?> elementSerializer;

        public ListViewSpec(String stateId, int fieldIndex, DataType dataType) {
            this(stateId, fieldIndex, dataType, (TypeSerializer<?>)null);
        }

        @Deprecated
        public ListViewSpec(String stateId, int fieldIndex, DataType dataType, TypeSerializer<?> elementSerializer) {
            super(stateId, fieldIndex, dataType);
            this.elementSerializer = elementSerializer;
        }

        public DataType getElementDataType() {
            CollectionDataType arrayDataType = (CollectionDataType)this.getDataType();
            return arrayDataType.getElementDataType();
        }

        public Optional<TypeSerializer<?>> getElementSerializer() {
            return Optional.ofNullable(this.elementSerializer);
        }
    }

    public static abstract class DataViewSpec
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String stateId;
        private final int fieldIndex;
        private final DataType dataType;

        private DataViewSpec(String stateId, int fieldIndex, DataType dataType) {
            this.stateId = stateId;
            this.fieldIndex = fieldIndex;
            this.dataType = dataType;
        }

        public String getStateId() {
            return this.stateId;
        }

        public int getFieldIndex() {
            return this.fieldIndex;
        }

        public DataType getDataType() {
            return this.dataType;
        }
    }

    private static class DataViewsTransformation
    implements TypeTransformation {
        static final DataViewsTransformation INSTANCE = new DataViewsTransformation();

        private DataViewsTransformation() {
        }

        public DataType transform(DataType dataType) {
            if (DataViewUtils.isDataView(dataType.getLogicalType(), DataView.class)) {
                return DataTypes.RAW((Class)dataType.getConversionClass(), (TypeSerializer)NullSerializer.INSTANCE);
            }
            return dataType;
        }
    }
}

