/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.sources;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;
import java.util.function.Function;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.ResolvedFieldReference;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.expressions.converter.ExpressionConverter;
import org.apache.flink.table.runtime.types.DataTypePrecisionFixer;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.runtime.types.TypeInfoLogicalTypeConverter;
import org.apache.flink.table.sources.DefinedFieldMapping;
import org.apache.flink.table.sources.DefinedProctimeAttribute;
import org.apache.flink.table.sources.DefinedRowtimeAttributes;
import org.apache.flink.table.sources.RowtimeAttributeDescriptor;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.tsextractors.TimestampExtractor;
import org.apache.flink.table.sources.tsextractors.TimestampExtractorUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypeVisitor;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class TableSourceUtil$ {
    public static TableSourceUtil$ MODULE$;

    static {
        new TableSourceUtil$();
    }

    public DataType fixPrecisionForProducedDataType(TableSource<?> tableSource, RowType logicalSchema) {
        LogicalType logicalType;
        LogicalType sourceLogicalType;
        RowType rowType;
        Option<String> option = this.getProctimeAttribute(tableSource);
        if (option instanceof Some) {
            Some some = (Some)option;
            String proctime = (String)some.value();
            List fields = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(logicalSchema.getFields()).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)TableSourceUtil$.$anonfun$fixPrecisionForProducedDataType$1(proctime, f)))).asJava();
            rowType = new RowType(logicalSchema.isNullable(), fields);
        } else if (None$.MODULE$.equals(option)) {
            rowType = logicalSchema;
        } else {
            throw new MatchError(option);
        }
        RowType schemaWithoutProctime = rowType;
        LogicalType logicalType2 = sourceLogicalType = LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)tableSource.getProducedDataType());
        if (logicalType2 instanceof RowType) {
            RowType rowType2 = (RowType)logicalType2;
            Map logicalNamesToTypes = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(schemaWithoutProctime.getFields()).map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)f.getName(), (Object)f.getType()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            List fields = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rowType2.getFields()).map((Function1 & Serializable & scala.Serializable)f -> {
                Some some;
                String n;
                Option option = TableSourceUtil$.mapping$1(f.getName(), tableSource);
                LogicalType logicalType = option instanceof Some && logicalNamesToTypes.contains((Object)(n = (String)(some = (Some)option).value())) ? (LogicalType)logicalNamesToTypes.apply((Object)n) : f.getType();
                LogicalType t = logicalType;
                return new RowType.RowField(f.getName(), t);
            }, Buffer$.MODULE$.canBuildFrom())).asJava();
            logicalType = new RowType(schemaWithoutProctime.isNullable(), fields);
        } else {
            logicalType = ((RowType.RowField)schemaWithoutProctime.getFields().get(0)).getType();
        }
        LogicalType correspondingLogicalType = logicalType;
        return (DataType)tableSource.getProducedDataType().accept((DataTypeVisitor)new DataTypePrecisionFixer(correspondingLogicalType));
    }

    public RelDataType getSourceRowTypeFromSource(FlinkTypeFactory typeFactory, TableSource<?> tableSource, boolean streaming) {
        ObjectRef fieldTypes;
        String[] fieldNames;
        block0: {
            TableSchema tableSchema = tableSource.getTableSchema();
            fieldNames = tableSchema.getFieldNames();
            DataType[] fieldDataTypes = tableSchema.getFieldDataTypes();
            fieldTypes = ObjectRef.create((Object)((LogicalType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldDataTypes)).map((Function1 & Serializable & scala.Serializable)x$1 -> LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)))));
            if (!streaming) break block0;
            String[] rowtimeAttributes = this.getRowtimeAttributes(tableSource);
            Option<String> proctimeAttributes = this.getProctimeAttribute(tableSource);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rowtimeAttributes)).foreach((Function1 & Serializable & scala.Serializable)rowtimeField -> {
                TableSourceUtil$.$anonfun$getSourceRowTypeFromSource$2(fieldNames, fieldTypes, rowtimeField);
                return BoxedUnit.UNIT;
            });
            proctimeAttributes.foreach((Function1 & Serializable & scala.Serializable)proctimeField -> {
                TableSourceUtil$.$anonfun$getSourceRowTypeFromSource$3(fieldNames, fieldTypes, proctimeField);
                return BoxedUnit.UNIT;
            });
        }
        return typeFactory.buildRelNodeRowType((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])fieldNames), (Seq<LogicalType>)Predef$.MODULE$.wrapRefArray((Object[])((LogicalType[])fieldTypes.elem)));
    }

    public RelDataType getSourceRowType(FlinkTypeFactory typeFactory, TableSchema tableSchema, Option<TableSource<?>> tableSource, boolean streaming) {
        RelDataType relDataType;
        String[] fieldNames = tableSchema.getFieldNames();
        DataType[] fieldDataTypes = tableSchema.getFieldDataTypes();
        if (tableSource.isDefined()) {
            relDataType = this.getSourceRowTypeFromSource(typeFactory, (TableSource)tableSource.get(), streaming);
        } else {
            LogicalType[] fieldTypes = (LogicalType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldDataTypes)).map((Function1 & Serializable & scala.Serializable)x$1 -> LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)));
            relDataType = typeFactory.buildRelNodeRowType((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])fieldNames), (Seq<LogicalType>)Predef$.MODULE$.wrapRefArray((Object[])fieldTypes));
        }
        return relDataType;
    }

    public Option<RowtimeAttributeDescriptor> getRowtimeAttributeDescriptor(TableSource<?> tableSource, RelDataType rowType) {
        None$ none$;
        TableSource<?> tableSource2 = tableSource;
        if (tableSource2 instanceof DefinedRowtimeAttributes) {
            Object object;
            DefinedRowtimeAttributes definedRowtimeAttributes = (DefinedRowtimeAttributes)tableSource2;
            List descriptors = definedRowtimeAttributes.getRowtimeAttributeDescriptors();
            if (descriptors.size() == 0) {
                object = None$.MODULE$;
            } else {
                if (descriptors.size() > 1) {
                    throw new ValidationException("Table with has more than a single rowtime attribute..");
                }
                RowtimeAttributeDescriptor descriptor = (RowtimeAttributeDescriptor)descriptors.get(0);
                object = rowType.getFieldNames().contains(descriptor.getAttributeName()) ? new Some((Object)descriptor) : None$.MODULE$;
            }
            none$ = object;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public RexNode getRowtimeExtractionExpression(TimestampExtractor extractor, DataType physicalInputType, RelBuilder relBuilder, Function<String, String> nameMapping) {
        ResolvedFieldReference[] accessedFields = TimestampExtractorUtils.getAccessedFields((TimestampExtractor)extractor, (DataType)physicalInputType, nameMapping);
        relBuilder.push(this.createSchemaRelNode(accessedFields, relBuilder.getCluster()));
        RexNode expr = (RexNode)this.constructExpression(extractor, accessedFields).accept((ExpressionVisitor)new ExpressionConverter(relBuilder));
        relBuilder.clear();
        return expr;
    }

    private RelNode createSchemaRelNode(ResolvedFieldReference[] fields, RelOptCluster cluster) {
        int maxIdx = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.fieldIndex()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).max((Ordering)Ordering.Int$.MODULE$));
        Map idxMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)f.fieldIndex())), (Object)new Tuple2((Object)f.name(), (Object)TypeInfoLogicalTypeConverter.fromTypeInfoToLogicalType((TypeInformation)f.resultType()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))));
        Tuple2 tuple2 = ((GenericTraversableTemplate)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), maxIdx).map((Function1 & Serializable & scala.Serializable)i -> TableSourceUtil$.$anonfun$createSchemaRelNode$3(idxMap, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        IndexedSeq physicalFields = (IndexedSeq)tuple2._1();
        IndexedSeq physicalTypes = (IndexedSeq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)physicalFields, (Object)physicalTypes);
        Tuple2 tuple23 = tuple22;
        IndexedSeq physicalFields2 = (IndexedSeq)tuple23._1();
        IndexedSeq physicalTypes2 = (IndexedSeq)tuple23._2();
        RelDataType physicalSchema = ((FlinkTypeFactory)cluster.getTypeFactory()).buildRelNodeRowType((Seq<String>)physicalFields2, (Seq<LogicalType>)physicalTypes2);
        return LogicalValues.createEmpty(cluster, physicalSchema);
    }

    private Expression constructExpression(TimestampExtractor timestampExtractor, ResolvedFieldReference[] fieldAccesses) {
        Expression expression = timestampExtractor.getExpression(fieldAccesses);
        DataType outputType = (DataType)DataTypes.TIMESTAMP((int)3).bridgedTo(Timestamp.class);
        return new CallExpression((FunctionDefinition)BuiltInFunctionDefinitions.REINTERPRET_CAST, JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResolvedExpression[]{(ResolvedExpression)expression, ApiExpressionUtils.typeLiteral((DataType)outputType), ApiExpressionUtils.valueLiteral((Object)BoxesRunTime.boxToBoolean((boolean)false))}))), outputType);
    }

    private String[] getRowtimeAttributes(TableSource<?> tableSource) {
        String[] stringArray;
        TableSource<?> tableSource2 = tableSource;
        if (tableSource2 instanceof DefinedRowtimeAttributes) {
            DefinedRowtimeAttributes definedRowtimeAttributes = (DefinedRowtimeAttributes)tableSource2;
            stringArray = (String[])((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(definedRowtimeAttributes.getRowtimeAttributeDescriptors()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getAttributeName(), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        } else {
            stringArray = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        }
        return stringArray;
    }

    private Option<String> getProctimeAttribute(TableSource<?> tableSource) {
        DefinedProctimeAttribute definedProctimeAttribute;
        TableSource<?> tableSource2 = tableSource;
        Object object = tableSource2 instanceof DefinedProctimeAttribute && (definedProctimeAttribute = (DefinedProctimeAttribute)tableSource2).getProctimeAttribute() != null ? new Some((Object)definedProctimeAttribute.getProctimeAttribute()) : None$.MODULE$;
        return object;
    }

    public static final /* synthetic */ boolean $anonfun$fixPrecisionForProducedDataType$1(String proctime$1, RowType.RowField f) {
        return !f.getName().equals(proctime$1);
    }

    private static final Option mapping$1(String physicalName, TableSource tableSource$1) {
        Some some;
        DefinedFieldMapping definedFieldMapping;
        TableSource tableSource = tableSource$1;
        if (tableSource instanceof DefinedFieldMapping && (definedFieldMapping = (DefinedFieldMapping)tableSource).getFieldMapping() != null) {
            Map map = (Map)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(definedFieldMapping.getFieldMapping()).toMap(Predef$.MODULE$.$conforms()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.swap(), Map$.MODULE$.canBuildFrom());
            some = map.get((Object)physicalName);
        } else {
            some = new Some((Object)physicalName);
        }
        return some;
    }

    public static final /* synthetic */ void $anonfun$getSourceRowTypeFromSource$2(String[] fieldNames$1, ObjectRef fieldTypes$1, String rowtimeField) {
        int idx = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames$1)).indexOf((Object)rowtimeField);
        TimestampType rowtimeType = new TimestampType(true, TimestampKind.ROWTIME, 3);
        fieldTypes$1.elem = (LogicalType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((LogicalType[])fieldTypes$1.elem))).patch(idx, (GenSeq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimestampType[]{rowtimeType})), 1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)));
    }

    public static final /* synthetic */ void $anonfun$getSourceRowTypeFromSource$3(String[] fieldNames$1, ObjectRef fieldTypes$1, String proctimeField) {
        int idx = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames$1)).indexOf((Object)proctimeField);
        TimestampType proctimeType = new TimestampType(true, TimestampKind.PROCTIME, 3);
        fieldTypes$1.elem = (LogicalType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((LogicalType[])fieldTypes$1.elem))).patch(idx, (GenSeq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimestampType[]{proctimeType})), 1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)));
    }

    public static final /* synthetic */ Tuple2 $anonfun$createSchemaRelNode$3(Map idxMap$1, int i) {
        return (Tuple2)idxMap$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)i), (Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)"", (Object)new TinyIntType()));
    }

    private TableSourceUtil$() {
        MODULE$ = this;
    }
}

