/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.dataview.ListView;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.data.binary.BinaryStringDataUtil;
import org.apache.flink.table.planner.functions.aggfunctions.InternalAggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.FlinkRuntimeException;

@Internal
public final class ListAggWithRetractAggFunction
extends InternalAggregateFunction<StringData, ListAggWithRetractAccumulator> {
    private static final long serialVersionUID = -2836795091288790955L;
    private static final BinaryStringData lineDelimiter = BinaryStringData.fromString((String)",");

    @Override
    public DataType[] getInputDataTypes() {
        return new DataType[]{(DataType)DataTypes.STRING().bridgedTo(StringData.class)};
    }

    @Override
    public DataType getAccumulatorDataType() {
        return DataTypes.STRUCTURED(ListAggWithRetractAccumulator.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"list", (DataType)ListView.newListViewDataType((DataType)((DataType)((DataType)DataTypes.STRING().notNull()).bridgedTo(StringData.class)))), DataTypes.FIELD((String)"retractList", (DataType)ListView.newListViewDataType((DataType)((DataType)((DataType)DataTypes.STRING().notNull()).bridgedTo(StringData.class))))});
    }

    @Override
    public DataType getOutputDataType() {
        return (DataType)DataTypes.STRING().bridgedTo(StringData.class);
    }

    public ListAggWithRetractAccumulator createAccumulator() {
        ListAggWithRetractAccumulator acc = new ListAggWithRetractAccumulator();
        acc.list = new ListView();
        acc.retractList = new ListView();
        return acc;
    }

    public void accumulate(ListAggWithRetractAccumulator acc, StringData value) throws Exception {
        if (value != null) {
            acc.list.add((Object)value);
        }
    }

    public void retract(ListAggWithRetractAccumulator acc, StringData value) throws Exception {
        if (value != null && !acc.list.remove((Object)value)) {
            acc.retractList.add((Object)value);
        }
    }

    public void merge(ListAggWithRetractAccumulator acc, Iterable<ListAggWithRetractAccumulator> its) throws Exception {
        for (ListAggWithRetractAccumulator otherAcc : its) {
            Object binaryString2;
            ArrayList<StringData> buffer = new ArrayList<StringData>();
            for (Object binaryString2 : acc.list.get()) {
                buffer.add((StringData)binaryString2);
            }
            for (Object binaryString2 : otherAcc.list.get()) {
                buffer.add((StringData)binaryString2);
            }
            ArrayList<StringData> retractBuffer = new ArrayList<StringData>();
            for (StringData binaryString3 : acc.retractList.get()) {
                retractBuffer.add(binaryString3);
            }
            binaryString2 = otherAcc.retractList.get().iterator();
            while (binaryString2.hasNext()) {
                StringData binaryString3;
                binaryString3 = (StringData)binaryString2.next();
                retractBuffer.add(binaryString3);
            }
            ArrayList<StringData> newRetractBuffer = new ArrayList<StringData>();
            for (StringData binaryString4 : retractBuffer) {
                if (buffer.remove(binaryString4)) continue;
                newRetractBuffer.add(binaryString4);
            }
            acc.list.clear();
            acc.list.addAll(buffer);
            acc.retractList.clear();
            acc.retractList.addAll(newRetractBuffer);
        }
    }

    public StringData getValue(ListAggWithRetractAccumulator acc) {
        try {
            Iterable accList = acc.list.get();
            if (accList == null || !accList.iterator().hasNext()) {
                return null;
            }
            return BinaryStringDataUtil.concatWs((BinaryStringData)lineDelimiter, (Iterable)accList);
        }
        catch (Exception e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    public void resetAccumulator(ListAggWithRetractAccumulator acc) {
        acc.list.clear();
        acc.retractList.clear();
    }

    public static class ListAggWithRetractAccumulator {
        public ListView<StringData> list;
        public ListView<StringData> retractList;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListAggWithRetractAccumulator that = (ListAggWithRetractAccumulator)o;
            return Objects.equals(this.list, that.list) && Objects.equals(this.retractList, that.retractList);
        }

        public int hashCode() {
            return Objects.hash(this.list, this.retractList);
        }
    }
}

