/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io.jdbc.writer;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.java.io.jdbc.JDBCUtils;
import org.apache.flink.api.java.io.jdbc.writer.JDBCWriter;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class AppendOnlyWriter
implements JDBCWriter {
    private static final long serialVersionUID = 1L;
    private final String insertSQL;
    private final int[] fieldTypes;
    private transient List<Row> cachedRows;
    private transient PreparedStatement statement;

    public AppendOnlyWriter(String insertSQL, int[] fieldTypes) {
        this.insertSQL = insertSQL;
        this.fieldTypes = fieldTypes;
    }

    @Override
    public void open(Connection connection) throws SQLException {
        this.cachedRows = new ArrayList<Row>();
        this.statement = connection.prepareStatement(this.insertSQL);
    }

    @Override
    public void addRecord(Tuple2<Boolean, Row> record) {
        Preconditions.checkArgument((boolean)((Boolean)record.f0), (Object)"Append mode can not receive retract/delete message.");
        this.cachedRows.add((Row)record.f1);
    }

    @Override
    public void executeBatch() throws SQLException {
        if (this.cachedRows.size() > 0) {
            for (Row row : this.cachedRows) {
                JDBCUtils.setRecordToStatement(this.statement, this.fieldTypes, row);
                this.statement.addBatch();
            }
            this.statement.executeBatch();
            this.cachedRows.clear();
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.statement != null) {
            this.statement.close();
            this.statement = null;
        }
    }
}

