/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionScope;
import org.apache.dubbo.common.extension.SPI;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.AbstractServiceNameMapping;
import org.apache.dubbo.metadata.MappingListener;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;
import org.apache.dubbo.rpc.service.Destroyable;

@SPI(value="metadata", scope=ExtensionScope.APPLICATION)
public interface ServiceNameMapping
extends Destroyable {
    public static final String DEFAULT_MAPPING_GROUP = "mapping";

    public boolean map(URL var1);

    public boolean hasValidMetadataCenter();

    public static ServiceNameMapping getDefaultExtension(ScopeModel scopeModel) {
        return (ServiceNameMapping)ScopeModelUtil.getApplicationModel((ScopeModel)scopeModel).getDefaultExtension(ServiceNameMapping.class);
    }

    public static String buildMappingKey(URL url) {
        return ServiceNameMapping.buildGroup(url.getServiceInterface());
    }

    public static String buildGroup(String serviceInterface) {
        return serviceInterface;
    }

    public static String toStringKeys(Set<String> serviceNames) {
        if (CollectionUtils.isEmpty(serviceNames)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String n : serviceNames) {
            builder.append(n);
            builder.append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public static Set<String> getAppNames(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return Collections.emptySet();
        }
        return new TreeSet<String>(Arrays.asList(content.split(",")));
    }

    public static Set<String> getMappingByUrl(URL consumerURL) {
        String providedBy = consumerURL.getParameter("provided-by");
        if (StringUtils.isBlank((CharSequence)providedBy)) {
            return null;
        }
        return AbstractServiceNameMapping.parseServices(providedBy);
    }

    public Set<String> getAndListen(URL var1, URL var2, MappingListener var3);

    public MappingListener stopListen(URL var1, MappingListener var2);

    public void putCachedMapping(String var1, Set<String> var2);

    public Set<String> getMapping(URL var1);

    public Set<String> getRemoteMapping(URL var1);

    public Set<String> removeCachedMapping(String var1);
}

