/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.pigeon;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractRemoteTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.pigeon.PigeonConfig;
import org.apache.dolphinscheduler.plugin.task.pigeon.PigeonParameters;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class PigeonTask
extends AbstractRemoteTask {
    public static final String KEY_POOL_VAR_PIGEON_HOST = "p_host";
    private final TaskExecutionContext taskExecutionContext;
    private PigeonParameters parameters;
    private BizResult triggerResult;
    private final PigeonConfig config;

    public PigeonTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
        this.config = PigeonConfig.getInstance();
    }

    public List<String> getApplicationIds() throws TaskException {
        return Collections.emptyList();
    }

    public void init() {
        super.init();
        this.logger.info("PIGEON task params {}", (Object)this.taskExecutionContext.getTaskParams());
        this.parameters = (PigeonParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), PigeonParameters.class));
        if (!this.parameters.checkParameters()) {
            throw new RuntimeException("datax task params is not valid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handle(TaskCallBack taskCallBack) throws TaskException {
        this.logger.info("start execute PIGEON task");
        long startTime = System.currentTimeMillis();
        String targetJobName = this.parameters.getTargetJobName();
        String host = this.getHost();
        try {
            int taskId;
            ExecResult execState;
            block42: {
                String triggerUrl = this.getTriggerUrl();
                String getStatusUrl = this.config.getJobStatusUrl(host);
                HttpPost post = new HttpPost(triggerUrl);
                post.addHeader("appname", targetJobName);
                this.addFormUrlencoded(post);
                StringEntity entity = new StringEntity(this.config.getJobTriggerPostBody(), StandardCharsets.UTF_8);
                post.setEntity((HttpEntity)entity);
                execState = null;
                WebSocketClient webSocket = null;
                try (CloseableHttpClient client = HttpClients.createDefault();
                     CloseableHttpResponse response = client.execute((HttpUriRequest)post);){
                    this.triggerResult = this.processResponse(triggerUrl, response, BizResult.class);
                    if (!this.triggerResult.isSuccess()) {
                        List<String> errormsg = this.triggerResult.getErrormsg();
                        StringBuffer errs = new StringBuffer();
                        if (!CollectionUtils.isNotEmpty(errormsg)) throw new Exception("trigger PIGEON job faild taskName:" + targetJobName + errs.toString());
                        errs.append(",errs:").append(errormsg.stream().collect(Collectors.joining(",")));
                        throw new Exception("trigger PIGEON job faild taskName:" + targetJobName + errs.toString());
                    }
                    taskId = this.triggerResult.getBizresult().getTaskid();
                    webSocket = this.receiveRealtimeLog(host, targetJobName, taskId);
                    this.setAppIds(String.valueOf(taskId));
                    CloseableHttpResponse status = null;
                    while (true) {
                        try {
                            while (true) {
                                post = new HttpPost(getStatusUrl);
                                entity = new StringEntity("{\n taskid: " + taskId + "\n, log: false }", StandardCharsets.UTF_8);
                                post.setEntity((HttpEntity)entity);
                                status = client.execute((HttpUriRequest)post);
                                StatusResult execStatus = this.processResponse(getStatusUrl, status, StatusResult.class);
                                Map bizresult = execStatus.getBizresult();
                                Map s = (Map)bizresult.get("status");
                                execState = ExecResult.parse((Integer)s.get("state"));
                                if (execState != ExecResult.SUCCESS && execState != ExecResult.FAILD) {
                                    Thread.sleep(3000L);
                                    continue;
                                }
                                break block42;
                                break;
                            }
                        }
                        finally {
                            status.close();
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    if (webSocket != null) {
                        Thread.sleep(4000L);
                        try {
                            webSocket.close();
                        }
                        catch (Throwable e) {
                            this.logger.warn(e.getMessage(), e);
                        }
                    }
                }
            }
            long costTime = System.currentTimeMillis() - startTime;
            this.logger.info("PIGEON task: {},taskId:{} costTime : {} milliseconds, statusCode : {}", new Object[]{targetJobName, taskId, costTime, execState == ExecResult.SUCCESS ? "'success'" : "'failure'"});
            this.setExitStatusCode(execState == ExecResult.SUCCESS ? 0 : -1);
            return;
        }
        catch (Exception e) {
            this.logger.error("execute PIGEON dataX faild,PIGEON task name:" + targetJobName, (Throwable)e);
            this.setExitStatusCode(-1);
            if (!(e instanceof InterruptedException)) throw new TaskException("Execute pigeon task failed", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new TaskException("Execute pigeon task failed", (Throwable)e);
        }
    }

    public void submitApplication() throws TaskException {
    }

    public void trackApplicationStatus() throws TaskException {
    }

    private void addFormUrlencoded(HttpPost post) {
        post.addHeader("content-type", "application/x-www-form-urlencoded");
    }

    public void cancelApplication() throws TaskException {
        this.logger.info("start to cancelApplication");
        Objects.requireNonNull(this.triggerResult, "triggerResult can not be null");
        this.logger.info("start to cancelApplication taskId:{}", (Object)this.triggerResult.getTaskId());
        String triggerUrl = this.getTriggerUrl();
        StringEntity entity = new StringEntity(this.config.getJobCancelPostBody(this.triggerResult.getTaskId()), StandardCharsets.UTF_8);
        CancelResult cancelResult = null;
        HttpPost post = new HttpPost(triggerUrl);
        this.addFormUrlencoded(post);
        post.setEntity((HttpEntity)entity);
        try (CloseableHttpClient client = HttpClients.createDefault();
             CloseableHttpResponse response = client.execute((HttpUriRequest)post);){
            cancelResult = this.processResponse(triggerUrl, response, CancelResult.class);
            if (!cancelResult.isSuccess()) {
                List<String> errormsg = this.triggerResult.getErrormsg();
                StringBuffer errs = new StringBuffer();
                if (CollectionUtils.isNotEmpty(errormsg)) {
                    errs.append(",errs:").append(errormsg.stream().collect(Collectors.joining(",")));
                }
                throw new TaskException("cancel PIGEON job faild taskId:" + this.triggerResult.getTaskId() + errs);
            }
        }
        catch (ClientProtocolException e) {
            throw new TaskException("client protocol error", (Throwable)e);
        }
        catch (Exception e) {
            throw new TaskException("pigeon execute error", (Throwable)e);
        }
    }

    private String getTriggerUrl() {
        String tisHost = this.getHost();
        return this.config.getJobTriggerUrl(tisHost);
    }

    private String getHost() {
        String host = (String)this.taskExecutionContext.getDefinedParams().get(KEY_POOL_VAR_PIGEON_HOST);
        if (StringUtils.isEmpty((CharSequence)host)) {
            throw new IllegalStateException("global var 'p_host' can not be empty");
        }
        return host;
    }

    private WebSocketClient receiveRealtimeLog(String tisHost, String dataXName, final int taskId) throws Exception {
        String applyURI = this.config.getJobLogsFetchUrl(tisHost, dataXName, taskId);
        this.logger.info("apply ws connection,uri:{}", (Object)applyURI);
        WebSocketClient webSocketClient = new WebSocketClient(new URI(applyURI)){

            public void onOpen(ServerHandshake handshakedata) {
                PigeonTask.this.logger.info("start to receive remote execute log");
            }

            public void onMessage(String message) {
                ExecLog execLog = (ExecLog)JSONUtils.parseObject((String)message, ExecLog.class);
                PigeonTask.this.logger.info(execLog.getMsg());
            }

            public void onClose(int code, String reason, boolean remote) {
                PigeonTask.this.logger.info("stop to receive remote log,reason:{},taskId:{}", (Object)reason, (Object)taskId);
            }

            public void onError(Exception t) {
                PigeonTask.this.logger.error(t.getMessage(), (Throwable)t);
            }
        };
        webSocketClient.connect();
        return webSocketClient;
    }

    private <T extends AjaxResult> T processResponse(String applyUrl, CloseableHttpResponse response, Class<T> clazz) throws Exception {
        StatusLine resStatus = response.getStatusLine();
        if (200 != resStatus.getStatusCode()) {
            throw new IllegalStateException("request server " + applyUrl + " faild:" + resStatus.getReasonPhrase());
        }
        HttpEntity entity = response.getEntity();
        String resp = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
        AjaxResult result = (AjaxResult)JSONUtils.parseObject((String)resp, clazz);
        return (T)result;
    }

    public AbstractParameters getParameters() {
        Objects.requireNonNull(this.parameters, "tisParameters can not be null");
        return this.parameters;
    }

    private static class ExecLog {
        private String logType;
        private String msg;
        private int taskId;

        private ExecLog() {
        }

        public String getLogType() {
            return this.logType;
        }

        public void setLogType(String logType) {
            this.logType = logType;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public int getTaskId() {
            return this.taskId;
        }

        public void setTaskId(int taskId) {
            this.taskId = taskId;
        }
    }

    private static enum ExecResult {
        SUCCESS(1),
        FAILD(-1),
        DOING(2),
        ASYN_DOING(22),
        CANCEL(3);

        private final int value;

        public static ExecResult parse(int value) {
            for (ExecResult r : ExecResult.values()) {
                if (r.value != value) continue;
                return r;
            }
            throw new IllegalStateException("vale:" + value + " is illegal");
        }

        private ExecResult(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    private static class TriggerBuildResult {
        private int taskid;

        private TriggerBuildResult() {
        }

        public int getTaskid() {
            return this.taskid;
        }

        public void setTaskid(int taskid) {
            this.taskid = taskid;
        }
    }

    private static abstract class AjaxResult<T> {
        private boolean success;
        private List<String> errormsg;
        private List<String> msg;

        private AjaxResult() {
        }

        public abstract T getBizresult();

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public List<String> getErrormsg() {
            return this.errormsg;
        }

        public void setErrormsg(List<String> errormsg) {
            this.errormsg = errormsg;
        }

        public List<String> getMsg() {
            return this.msg;
        }

        public void setMsg(List<String> msg) {
            this.msg = msg;
        }
    }

    private static class StatusResult
    extends AjaxResult<Map> {
        private Map bizresult;

        private StatusResult() {
        }

        @Override
        public Map getBizresult() {
            return this.bizresult;
        }

        public void setBizresult(Map bizresult) {
            this.bizresult = bizresult;
        }
    }

    private static class BizResult
    extends AjaxResult<TriggerBuildResult> {
        private TriggerBuildResult bizresult;

        private BizResult() {
        }

        @Override
        public TriggerBuildResult getBizresult() {
            return this.bizresult;
        }

        public int getTaskId() {
            return this.bizresult.taskid;
        }

        public void setBizresult(TriggerBuildResult bizresult) {
            this.bizresult = bizresult;
        }
    }

    private static class CancelResult
    extends AjaxResult<Object> {
        private Object bizresult;

        private CancelResult() {
        }

        @Override
        public Object getBizresult() {
            return this.bizresult;
        }

        public void setBizresult(Object bizresult) {
            this.bizresult = bizresult;
        }
    }
}

