/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.io.decoder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.server.dns.io.decoder.AddressRecordDecoder;
import org.apache.directory.server.dns.io.decoder.IPv6RecordDecoder;
import org.apache.directory.server.dns.io.decoder.MailExchangeRecordDecoder;
import org.apache.directory.server.dns.io.decoder.NameServerRecordDecoder;
import org.apache.directory.server.dns.io.decoder.RecordDecoder;
import org.apache.directory.server.dns.messages.DnsMessage;
import org.apache.directory.server.dns.messages.DnsMessageModifier;
import org.apache.directory.server.dns.messages.MessageType;
import org.apache.directory.server.dns.messages.OpCode;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.RecordClass;
import org.apache.directory.server.dns.messages.RecordType;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.messages.ResourceRecordImpl;
import org.apache.directory.server.dns.messages.ResponseCode;
import org.apache.directory.server.i18n.I18n;
import org.apache.mina.core.buffer.IoBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnsMessageDecoder {
    private final Logger logger = LoggerFactory.getLogger(DnsMessageDecoder.class);
    private static final Map<RecordType, RecordDecoder> DEFAULT_DECODERS;

    public DnsMessage decode(IoBuffer in) throws IOException {
        DnsMessageModifier modifier = new DnsMessageModifier();
        modifier.setTransactionId(in.getUnsignedShort());
        byte header = in.get();
        modifier.setMessageType(this.decodeMessageType(header));
        modifier.setOpCode(this.decodeOpCode(header));
        modifier.setAuthoritativeAnswer(this.decodeAuthoritativeAnswer(header));
        modifier.setTruncated(this.decodeTruncated(header));
        modifier.setRecursionDesired(this.decodeRecursionDesired(header));
        header = in.get();
        modifier.setRecursionAvailable(this.decodeRecursionAvailable(header));
        modifier.setResponseCode(this.decodeResponseCode(header));
        short questionCount = in.getShort();
        short answerCount = in.getShort();
        short authorityCount = in.getShort();
        short additionalCount = in.getShort();
        this.logger.debug("decoding {} question records", (Object)questionCount);
        modifier.setQuestionRecords(this.getQuestions(in, questionCount));
        this.logger.debug("decoding {} answer records", (Object)answerCount);
        modifier.setAnswerRecords(this.getRecords(in, answerCount));
        this.logger.debug("decoding {} authority records", (Object)authorityCount);
        modifier.setAuthorityRecords(this.getRecords(in, authorityCount));
        this.logger.debug("decoding {} additional records", (Object)additionalCount);
        modifier.setAdditionalRecords(this.getRecords(in, additionalCount));
        return modifier.getDnsMessage();
    }

    private List<ResourceRecord> getRecords(IoBuffer byteBuffer, short recordCount) throws IOException {
        ArrayList<ResourceRecord> records = new ArrayList<ResourceRecord>(recordCount);
        for (int ii = 0; ii < recordCount; ++ii) {
            String domainName = DnsMessageDecoder.getDomainName(byteBuffer);
            RecordType recordType = RecordType.convert(byteBuffer.getShort());
            RecordClass recordClass = RecordClass.convert(byteBuffer.getShort());
            int timeToLive = byteBuffer.getInt();
            short dataLength = byteBuffer.getShort();
            Map<String, Object> attributes = this.decode(byteBuffer, recordType, dataLength);
            records.add(new ResourceRecordImpl(domainName, recordType, recordClass, timeToLive, attributes));
        }
        return records;
    }

    private Map<String, Object> decode(IoBuffer byteBuffer, RecordType type, short length) throws IOException {
        RecordDecoder recordDecoder = DEFAULT_DECODERS.get(type);
        if (recordDecoder == null) {
            throw new IllegalArgumentException(I18n.err((String)I18n.ERR_600, (Object[])new Object[]{type}));
        }
        return recordDecoder.decode(byteBuffer, length);
    }

    private List<QuestionRecord> getQuestions(IoBuffer byteBuffer, short questionCount) {
        ArrayList<QuestionRecord> questions = new ArrayList<QuestionRecord>(questionCount);
        for (int ii = 0; ii < questionCount; ++ii) {
            String domainName = DnsMessageDecoder.getDomainName(byteBuffer);
            RecordType recordType = RecordType.convert(byteBuffer.getShort());
            RecordClass recordClass = RecordClass.convert(byteBuffer.getShort());
            questions.add(new QuestionRecord(domainName, recordType, recordClass));
        }
        return questions;
    }

    static String getDomainName(IoBuffer byteBuffer) {
        StringBuffer domainName = new StringBuffer();
        DnsMessageDecoder.recurseDomainName(byteBuffer, domainName);
        return domainName.toString();
    }

    static void recurseDomainName(IoBuffer byteBuffer, StringBuffer domainName) {
        short length = byteBuffer.getUnsigned();
        if (DnsMessageDecoder.isOffset(length)) {
            short position = byteBuffer.getUnsigned();
            int offset = length & 0xFFFF3F00;
            int originalPosition = byteBuffer.position();
            byteBuffer.position(position + offset);
            DnsMessageDecoder.recurseDomainName(byteBuffer, domainName);
            byteBuffer.position(originalPosition);
        } else if (DnsMessageDecoder.isLabel(length)) {
            short labelLength = length;
            DnsMessageDecoder.getLabel(byteBuffer, domainName, labelLength);
            DnsMessageDecoder.recurseDomainName(byteBuffer, domainName);
        }
    }

    static boolean isOffset(int length) {
        return (length & 0xC0) == 192;
    }

    static boolean isLabel(int length) {
        return length != 0 && (length & 0xC0) == 0;
    }

    static void getLabel(IoBuffer byteBuffer, StringBuffer domainName, int labelLength) {
        for (int jj = 0; jj < labelLength; ++jj) {
            char character = (char)byteBuffer.get();
            domainName.append(character);
        }
        if (byteBuffer.get(byteBuffer.position()) != 0) {
            domainName.append(".");
        }
    }

    private MessageType decodeMessageType(byte header) {
        return MessageType.convert((byte)((header & 0x80) >>> 7));
    }

    private OpCode decodeOpCode(byte header) {
        return OpCode.convert((byte)((header & 0x78) >>> 3));
    }

    private boolean decodeAuthoritativeAnswer(byte header) {
        return (header & 4) >>> 2 == 1;
    }

    private boolean decodeTruncated(byte header) {
        return (header & 2) >>> 1 == 1;
    }

    private boolean decodeRecursionDesired(byte header) {
        return (header & 1) == 1;
    }

    private boolean decodeRecursionAvailable(byte header) {
        return (header & 0x80) >>> 7 == 1;
    }

    private ResponseCode decodeResponseCode(byte header) {
        return ResponseCode.convert((byte)(header & 0xF));
    }

    static {
        HashMap<RecordType, RecordDecoder> map = new HashMap<RecordType, RecordDecoder>();
        map.put(RecordType.A, new AddressRecordDecoder());
        map.put(RecordType.NS, new NameServerRecordDecoder());
        map.put(RecordType.MX, new MailExchangeRecordDecoder());
        map.put(RecordType.AAAA, new IPv6RecordDecoder());
        DEFAULT_DECODERS = Collections.unmodifiableMap(map);
    }
}

