/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsn.util;

import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.wsn.util.WSNHelper;
import org.apache.cxf.wsn.wsdl.WSNWSDLLocator;

public class CXFWSNHelper
extends WSNHelper {
    @Override
    public boolean supportsExtraClasses() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getPort(String address, Class<T> serviceInterface, Class<?> ... extraClasses) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            if (this.setClassLoader) {
                Thread.currentThread().setContextClassLoader(WSNHelper.class.getClassLoader());
            }
            JaxWsProxyFactoryBean jwfb = new JaxWsProxyFactoryBean();
            jwfb.getClientFactoryBean().setWsdlURL(WSNWSDLLocator.getWSDLUrl().toExternalForm());
            jwfb.setServiceName(new QName("http://cxf.apache.org/wsn/jaxws", serviceInterface.getSimpleName() + "Service"));
            jwfb.setEndpointName(new QName("http://cxf.apache.org/wsn/jaxws", "Soap"));
            jwfb.setAddress(address);
            if (extraClasses != null && extraClasses.length > 0) {
                HashMap<String, Class<?>[]> props = new HashMap<String, Class<?>[]>();
                props.put("jaxb.additionalContextClasses", extraClasses);
                jwfb.getClientFactoryBean().getServiceFactory().setProperties(props);
            }
            Object object = jwfb.create(serviceInterface);
            return (T)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @Override
    public Endpoint publish(String address, Object o, Class<?> ... extraClasses) {
        Endpoint endpoint = Endpoint.create((Object)o);
        if (extraClasses != null && extraClasses.length > 0) {
            HashMap<String, Class<?>[]> props = new HashMap<String, Class<?>[]>();
            props.put("jaxb.additionalContextClasses", extraClasses);
            endpoint.setProperties(props);
        }
        endpoint.publish(address);
        return endpoint;
    }
}

