/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import org.apache.camel.CamelContext;
import org.apache.camel.core.osgi.CompositeRegistry;
import org.apache.camel.core.osgi.OsgiClassResolver;
import org.apache.camel.core.osgi.OsgiComponentResolver;
import org.apache.camel.core.osgi.OsgiDataFormatResolver;
import org.apache.camel.core.osgi.OsgiFactoryFinderResolver;
import org.apache.camel.core.osgi.OsgiLanguageResolver;
import org.apache.camel.core.osgi.OsgiPackageScanClassResolver;
import org.apache.camel.core.osgi.OsgiServiceRegistry;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public final class OsgiCamelContextHelper {
    private static final transient Log LOG = LogFactory.getLog(OsgiCamelContextHelper.class);

    private OsgiCamelContextHelper() {
    }

    public static void osgiUpdate(DefaultCamelContext camelContext, BundleContext bundleContext) {
        LOG.debug((Object)"Using the OsgiClassResolver");
        camelContext.setClassResolver((ClassResolver)new OsgiClassResolver(bundleContext));
        LOG.debug((Object)"Using OsgiFactoryFinderResolver");
        camelContext.setFactoryFinderResolver((FactoryFinderResolver)new OsgiFactoryFinderResolver(bundleContext));
        LOG.debug((Object)"Using OsgiPackageScanClassResolver");
        camelContext.setPackageScanClassResolver((PackageScanClassResolver)new OsgiPackageScanClassResolver(bundleContext));
        LOG.debug((Object)"Using OsgiComponentResolver");
        camelContext.setComponentResolver((ComponentResolver)new OsgiComponentResolver(bundleContext));
        LOG.debug((Object)"Using OsgiLanguageResolver");
        camelContext.setLanguageResolver((LanguageResolver)new OsgiLanguageResolver(bundleContext));
        LOG.debug((Object)"Using OsgiDataFormatResolver");
        camelContext.setDataFormatResolver((DataFormatResolver)new OsgiDataFormatResolver(bundleContext));
    }

    public static Registry wrapRegistry(CamelContext camelContext, Registry registry, BundleContext bundleContext) {
        ObjectHelper.notNull((Object)bundleContext, (String)"BundleContext");
        LOG.debug((Object)"Setting the OSGi ServiceRegistry");
        OsgiServiceRegistry osgiServiceRegistry = new OsgiServiceRegistry(bundleContext);
        camelContext.addLifecycleStrategy((LifecycleStrategy)osgiServiceRegistry);
        CompositeRegistry compositeRegistry = new CompositeRegistry();
        compositeRegistry.addRegistry(osgiServiceRegistry);
        compositeRegistry.addRegistry(registry);
        return compositeRegistry;
    }
}

