/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.artemis.shaded.org.jgroups.util.BaseDataOutputStream;

public class PartialOutputStream
extends BaseDataOutputStream {
    protected final DataOutput out;
    protected final int offset;
    protected final int end;

    public PartialOutputStream(DataOutput out, int offset, int length) {
        this.out = out;
        this.offset = offset;
        this.end = offset + length - 1;
    }

    @Override
    public void write(int b) {
        if (this.pos > this.end) {
            return;
        }
        if (this.pos < this.offset) {
            ++this.pos;
        } else {
            this._write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (this.pos > this.end) {
            return;
        }
        if (this.pos < this.offset) {
            int bytess_to_skip = this.offset - this.pos;
            if (bytess_to_skip >= len) {
                this.pos += len;
            } else {
                this.pos += bytess_to_skip;
                this.write(b, off + bytess_to_skip, len - bytess_to_skip);
            }
        } else {
            int bytes_to_be_written = Math.min(len, this.remaining());
            this._write(b, off, bytes_to_be_written);
        }
    }

    public int remaining() {
        int start = Math.max(this.offset, this.pos);
        return Math.max(0, this.end - start + 1);
    }

    @Override
    public String toString() {
        return String.format("%s, range=[%d..%d] (remaining=%d) (%s)", super.toString(), this.offset, this.end, this.remaining(), this.inRange() ? "in range" : "outside range");
    }

    @Override
    protected void ensureCapacity(int bytes) {
    }

    protected void _write(int b) {
        try {
            this.out.write(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            ++this.pos;
        }
    }

    protected void _write(byte[] b, int off, int len) {
        try {
            this.out.write(b, off, len);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.pos += len;
        }
    }

    protected boolean inRange() {
        return this.pos >= this.offset && this.pos <= this.end;
    }
}

