/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.shaded.org.jgroups.Header;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.ClassConfigurator;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public final class Headers {
    private static final int RESIZE_INCR = 3;

    private Headers() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static <T extends Header> T getHeader(Header[] hdrs, short id) {
        if (hdrs == null) {
            return null;
        }
        for (Header hdr : hdrs) {
            if (hdr == null) {
                return null;
            }
            if (hdr.getProtId() != id) continue;
            return (T)hdr;
        }
        return null;
    }

    public static <T extends Header> T getHeader(Header[] hdrs, short ... ids) {
        if (hdrs == null || ids == null || ids.length == 0) {
            return null;
        }
        for (Header hdr : hdrs) {
            if (hdr == null) {
                return null;
            }
            for (short id : ids) {
                if (hdr.getProtId() != id) continue;
                return (T)hdr;
            }
        }
        return null;
    }

    public static Map<Short, Header> getHeaders(Header[] hdrs) {
        if (hdrs == null) {
            return new HashMap<Short, Header>();
        }
        HashMap<Short, Header> retval = new HashMap<Short, Header>(hdrs.length);
        for (Header hdr : hdrs) {
            if (hdr == null) break;
            retval.put(hdr.getProtId(), hdr);
        }
        return retval;
    }

    public static String printHeaders(Header[] hdrs) {
        if (hdrs == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Header hdr : hdrs) {
            if (hdr == null) break;
            short id = hdr.getProtId();
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            Class<?> clazz = ClassConfigurator.getProtocol(id);
            String name = clazz != null ? clazz.getSimpleName() : Short.toString(id);
            sb.append(name).append(": ").append(hdr);
        }
        return sb.toString();
    }

    public static Header[] putHeader(Header[] headers, short id, Header hdr, boolean replace_if_present) {
        int i = 0;
        Header[] hdrs = headers;
        boolean resized = false;
        while (i < hdrs.length) {
            if (hdrs[i] == null) {
                hdrs[i] = hdr;
                return resized ? hdrs : null;
            }
            short hdr_id = hdrs[i].getProtId();
            if (hdr_id == id) {
                if (replace_if_present || hdrs[i] == null) {
                    hdrs[i] = hdr;
                }
                return resized ? hdrs : null;
            }
            if (++i < hdrs.length) continue;
            hdrs = Headers.resize(hdrs);
            resized = true;
        }
        throw new IllegalStateException("unable to add element " + id + ", index=" + i);
    }

    public static Header[] resize(Header[] headers) {
        int new_capacity = headers.length + 3;
        Header[] new_hdrs = new Header[new_capacity];
        System.arraycopy(headers, 0, new_hdrs, 0, headers.length);
        return new_hdrs;
    }

    public static Header[] copy(Header[] headers) {
        if (headers == null) {
            return new Header[0];
        }
        Header[] retval = new Header[headers.length];
        System.arraycopy(headers, 0, retval, 0, headers.length);
        return retval;
    }

    public static int marshalledSize(Header[] hdrs) {
        int retval = 0;
        if (hdrs == null) {
            return retval;
        }
        for (Header hdr : hdrs) {
            if (hdr == null) break;
            retval += 4;
            retval += hdr.serializedSize();
        }
        return retval;
    }

    public static int size(Header[] hdrs) {
        int retval = 0;
        if (hdrs == null) {
            return retval;
        }
        for (Header hdr : hdrs) {
            if (hdr == null) break;
            ++retval;
        }
        return retval;
    }

    public static int size(Header[] hdrs, short ... excluded_ids) {
        int retval = 0;
        if (hdrs == null) {
            return retval;
        }
        for (Header hdr : hdrs) {
            if (hdr == null) break;
            if (Util.containsId(hdr.getProtId(), excluded_ids)) continue;
            ++retval;
        }
        return retval;
    }
}

