/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.activemq.artemis.shaded.org.jgroups.Header;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Bits;

public class Frag3Header
extends Header {
    protected int id;
    protected int frag_id;
    protected int num_frags;
    protected int original_length;
    protected int offset;
    protected boolean needs_deserialization;

    public Frag3Header() {
    }

    public Frag3Header(int id, int frag_id, int num_frags) {
        this.id = id;
        this.frag_id = frag_id;
        this.num_frags = num_frags;
    }

    public Frag3Header(int id, int frag_id, int num_frags, int original_length, int offset) {
        this.id = id;
        this.frag_id = frag_id;
        this.num_frags = num_frags;
        this.original_length = original_length;
        this.offset = offset;
    }

    @Override
    public short getMagicId() {
        return 91;
    }

    @Override
    public Supplier<? extends Header> create() {
        return Frag3Header::new;
    }

    public boolean needsDeserialization() {
        return this.needs_deserialization;
    }

    public Frag3Header needsDeserialization(boolean flag) {
        this.needs_deserialization = flag;
        return this;
    }

    @Override
    public String toString() {
        return String.format("[id=%d, frag-id=%d, num_frags=%d orig-length=%d, offset=%d]", this.id, this.frag_id, this.num_frags, this.original_length, this.offset);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        Bits.writeIntCompressed(this.id, out);
        Bits.writeIntCompressed(this.frag_id, out);
        Bits.writeIntCompressed(this.num_frags, out);
        Bits.writeIntCompressed(this.original_length, out);
        Bits.writeIntCompressed(this.offset, out);
        out.writeBoolean(this.needs_deserialization);
    }

    @Override
    public int serializedSize() {
        return Bits.size(this.id) + Bits.size(this.frag_id) + Bits.size(this.num_frags) + Bits.size(this.original_length) + Bits.size(this.offset) + 1;
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        this.id = Bits.readIntCompressed(in);
        this.frag_id = Bits.readIntCompressed(in);
        this.num_frags = Bits.readIntCompressed(in);
        this.original_length = Bits.readIntCompressed(in);
        this.offset = Bits.readIntCompressed(in);
        this.needs_deserialization = in.readBoolean();
    }
}

