/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class SessionIndividualAcknowledgeMessage
extends PacketImpl {
    private long consumerID;
    private long messageID;
    private boolean requiresResponse;

    public SessionIndividualAcknowledgeMessage(long consumerID, long messageID, boolean requiresResponse) {
        super((byte)81);
        this.consumerID = consumerID;
        this.messageID = messageID;
        this.requiresResponse = requiresResponse;
    }

    public SessionIndividualAcknowledgeMessage() {
        super((byte)81);
    }

    public long getConsumerID() {
        return this.consumerID;
    }

    public long getMessageID() {
        return this.messageID;
    }

    @Override
    public boolean isRequiresResponse() {
        return this.requiresResponse;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeLong(this.consumerID);
        buffer.writeLong(this.messageID);
        buffer.writeBoolean(this.requiresResponse);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.consumerID = buffer.readLong();
        this.messageID = buffer.readLong();
        this.requiresResponse = buffer.readBoolean();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.consumerID ^ this.consumerID >>> 32);
        result = 31 * result + (int)(this.messageID ^ this.messageID >>> 32);
        result = 31 * result + (this.requiresResponse ? 1231 : 1237);
        return result;
    }

    @Override
    protected String getPacketString() {
        StringBuffer buff = new StringBuffer(super.getPacketString());
        buff.append(", consumerID=" + this.consumerID);
        buff.append(", messageID=" + this.messageID);
        buff.append(", requiresResponse=" + this.requiresResponse);
        return buff.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionIndividualAcknowledgeMessage)) {
            return false;
        }
        SessionIndividualAcknowledgeMessage other = (SessionIndividualAcknowledgeMessage)obj;
        if (this.consumerID != other.consumerID) {
            return false;
        }
        if (this.messageID != other.messageID) {
            return false;
        }
        return this.requiresResponse == other.requiresResponse;
    }
}

