/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.drivers;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCUtils;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;
import org.jboss.logging.Logger;

public abstract class AbstractJDBCDriver {
    private static final Logger logger = Logger.getLogger(AbstractJDBCDriver.class);
    protected Connection connection;
    protected SQLProvider sqlProvider;
    private String jdbcConnectionUrl;
    private String jdbcDriverClass;
    private DataSource dataSource;
    private Executor networkTimeoutExecutor;
    private int networkTimeoutMillis;

    public AbstractJDBCDriver() {
        this.networkTimeoutExecutor = null;
        this.networkTimeoutMillis = -1;
    }

    public AbstractJDBCDriver(SQLProvider sqlProvider, String jdbcConnectionUrl, String jdbcDriverClass) {
        this.jdbcConnectionUrl = jdbcConnectionUrl;
        this.jdbcDriverClass = jdbcDriverClass;
        this.sqlProvider = sqlProvider;
        this.networkTimeoutExecutor = null;
        this.networkTimeoutMillis = -1;
    }

    public AbstractJDBCDriver(DataSource dataSource, SQLProvider provider) {
        this.dataSource = dataSource;
        this.sqlProvider = provider;
        this.networkTimeoutExecutor = null;
        this.networkTimeoutMillis = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws SQLException {
        this.connect();
        Connection connection = this.connection;
        synchronized (connection) {
            this.createSchema();
            this.prepareStatements();
        }
    }

    public AbstractJDBCDriver(Connection connection, SQLProvider sqlProvider) {
        this.connection = connection;
        this.sqlProvider = sqlProvider;
        this.networkTimeoutExecutor = null;
        this.networkTimeoutMillis = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws SQLException {
        Connection connection = this.connection;
        synchronized (connection) {
            if (this.sqlProvider.closeConnectionOnShutdown()) {
                try {
                    this.connection.close();
                }
                catch (SQLException e) {
                    logger.error((Object)JDBCUtils.appendSQLExceptionDetails(new StringBuilder(), e));
                    throw e;
                }
            }
        }
    }

    protected abstract void prepareStatements() throws SQLException;

    protected abstract void createSchema() throws SQLException;

    protected final void createTable(String ... schemaSqls) throws SQLException {
        AbstractJDBCDriver.createTableIfNotExists(this.connection, this.sqlProvider.getTableName(), schemaSqls);
    }

    private void connect() throws SQLException {
        if (this.connection == null) {
            if (this.dataSource != null) {
                try {
                    this.connection = this.dataSource.getConnection();
                }
                catch (SQLException e) {
                    logger.error((Object)JDBCUtils.appendSQLExceptionDetails(new StringBuilder(), e));
                    throw e;
                }
            }
            try {
                if (this.jdbcDriverClass == null || this.jdbcDriverClass.isEmpty()) {
                    throw new IllegalStateException("jdbcDriverClass is null or empty!");
                }
                if (this.jdbcConnectionUrl == null || this.jdbcConnectionUrl.isEmpty()) {
                    throw new IllegalStateException("jdbcConnectionUrl is null or empty!");
                }
                Driver dbDriver = this.getDriver(this.jdbcDriverClass);
                this.connection = dbDriver.connect(this.jdbcConnectionUrl, new Properties());
                if (this.connection == null) {
                    throw new IllegalStateException("the driver: " + this.jdbcDriverClass + " isn't able to connect to the requested url: " + this.jdbcConnectionUrl);
                }
            }
            catch (SQLException e) {
                logger.error((Object)JDBCUtils.appendSQLExceptionDetails(new StringBuilder(), e));
                ActiveMQJournalLogger.LOGGER.error((Object)("Unable to connect to database using URL: " + this.jdbcConnectionUrl));
                throw e;
            }
            if (this.networkTimeoutMillis >= 0 && this.networkTimeoutExecutor != null) {
                try {
                    this.connection.setNetworkTimeout(this.networkTimeoutExecutor, this.networkTimeoutMillis);
                }
                catch (SQLException e) {
                    logger.warn((Object)JDBCUtils.appendSQLExceptionDetails(new StringBuilder(), e));
                    ActiveMQJournalLogger.LOGGER.warn((Object)"Unable to set a network timeout on the JDBC connection");
                }
                catch (Throwable throwable) {
                    logger.warn((Object)"Unable to set a network timeout on the JDBC connection", throwable);
                }
            }
        }
    }

    public void destroy() throws Exception {
        String dropTableSql = "DROP TABLE " + this.sqlProvider.getTableName();
        try {
            this.connection.setAutoCommit(false);
            try (Statement statement = this.connection.createStatement();){
                statement.executeUpdate(dropTableSql);
            }
            this.connection.commit();
        }
        catch (SQLException e) {
            logger.error((Object)JDBCUtils.appendSQLExceptionDetails(new StringBuilder(), e, dropTableSql));
            try {
                this.connection.rollback();
            }
            catch (SQLException rollbackEx) {
                logger.error((Object)JDBCUtils.appendSQLExceptionDetails(new StringBuilder(), rollbackEx, dropTableSql));
                throw rollbackEx;
            }
            throw e;
        }
    }

    private static void createTableIfNotExists(Connection connection, String tableName, String ... sqls) throws SQLException {
        logger.tracef("Validating if table %s didn't exist before creating", (Object)tableName);
        try {
            block31: {
                connection.setAutoCommit(false);
                try (ResultSet rs = connection.getMetaData().getTables(null, null, tableName, null);){
                    SQLWarning sqlWarning;
                    if (rs == null || rs.next()) break block31;
                    if (logger.isTraceEnabled()) {
                        logger.tracef("Table %s did not exist, creating it with SQL=%s", (Object)tableName, (Object)Arrays.toString(sqls));
                    }
                    if ((sqlWarning = rs.getWarnings()) != null) {
                        logger.warn((Object)JDBCUtils.appendSQLExceptionDetails(new StringBuilder(), sqlWarning));
                    }
                    try (Statement statement = connection.createStatement();){
                        for (String sql : sqls) {
                            statement.executeUpdate(sql);
                            SQLWarning statementSqlWarning = statement.getWarnings();
                            if (statementSqlWarning == null) continue;
                            logger.warn((Object)JDBCUtils.appendSQLExceptionDetails(new StringBuilder(), statementSqlWarning, sql));
                        }
                    }
                }
            }
            connection.commit();
        }
        catch (SQLException e) {
            String sqlStatements = Stream.of(sqls).collect(Collectors.joining("\n"));
            logger.error((Object)JDBCUtils.appendSQLExceptionDetails(new StringBuilder(), e, sqlStatements));
            try {
                connection.rollback();
            }
            catch (SQLException rollbackEx) {
                logger.error((Object)JDBCUtils.appendSQLExceptionDetails(new StringBuilder(), rollbackEx, sqlStatements));
                throw rollbackEx;
            }
            throw e;
        }
    }

    private Driver getDriver(String className) {
        try {
            Driver driver = (Driver)Class.forName(className).newInstance();
            if (className.equals("org.apache.derby.jdbc.EmbeddedDriver")) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            DriverManager.getConnection("jdbc:derby:;shutdown=true");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
            return driver;
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Could not find class: " + className);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate driver class: ", e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public final void setConnection(Connection connection) {
        if (connection == null) {
            this.connection = connection;
        }
    }

    public void setSqlProvider(SQLProvider sqlProvider) {
        this.sqlProvider = sqlProvider;
    }

    public void setJdbcConnectionUrl(String jdbcConnectionUrl) {
        this.jdbcConnectionUrl = jdbcConnectionUrl;
    }

    public void setJdbcDriverClass(String jdbcDriverClass) {
        this.jdbcDriverClass = jdbcDriverClass;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setNetworkTimeout(Executor executor, int milliseconds) {
        this.networkTimeoutExecutor = executor;
        this.networkTimeoutMillis = milliseconds;
    }
}

