/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.nio;

import java.io.IOException;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.transport.nio.SelectorSelection;
import org.apache.activemq.transport.nio.SelectorWorker;

public final class SelectorManager {
    public static final SelectorManager SINGLETON = new SelectorManager();
    private Executor selectorExecutor;
    private Executor channelExecutor;
    private final LinkedList<SelectorWorker> freeWorkers;
    private int maxChannelsPerWorker;

    public SelectorManager() {
        this.channelExecutor = this.selectorExecutor = this.createDefaultExecutor();
        this.freeWorkers = new LinkedList();
        this.maxChannelsPerWorker = 1024;
    }

    protected ExecutorService createDefaultExecutor() {
        ThreadPoolExecutor rc = new ThreadPoolExecutor(SelectorManager.getDefaultCorePoolSize(), SelectorManager.getDefaultMaximumPoolSize(), (long)SelectorManager.getDefaultKeepAliveTime(), TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
            private long i = 0L;

            @Override
            public Thread newThread(Runnable runnable) {
                Thread t = new Thread(runnable, "ActiveMQ NIO Worker " + this.i++);
                t.setDaemon(false);
                return t;
            }
        });
        return rc;
    }

    private static int getDefaultCorePoolSize() {
        return Integer.getInteger("org.apache.activemq.transport.nio.SelectorManager.corePoolSize", 0);
    }

    private static int getDefaultMaximumPoolSize() {
        return Integer.getInteger("org.apache.activemq.transport.nio.SelectorManager.maximumPoolSize", Integer.MAX_VALUE);
    }

    private static int getDefaultKeepAliveTime() {
        return Integer.getInteger("org.apache.activemq.transport.nio.SelectorManager.keepAliveTime", 30);
    }

    public static SelectorManager getInstance() {
        return SINGLETON;
    }

    public synchronized SelectorSelection register(AbstractSelectableChannel selectableChannel, Listener listener) throws IOException {
        SelectorSelection selection = null;
        while (selection == null) {
            SelectorWorker worker;
            if (this.freeWorkers.size() > 0) {
                worker = this.freeWorkers.getFirst();
                if (worker.isReleased()) {
                    this.freeWorkers.remove(worker);
                    continue;
                }
                worker.retain();
                selection = new SelectorSelection(worker, selectableChannel, listener);
                continue;
            }
            worker = new SelectorWorker(this);
            this.freeWorkers.addFirst(worker);
            selection = new SelectorSelection(worker, selectableChannel, listener);
        }
        return selection;
    }

    synchronized void onWorkerFullEvent(SelectorWorker worker) {
        this.freeWorkers.remove(worker);
    }

    public synchronized void onWorkerEmptyEvent(SelectorWorker worker) {
        this.freeWorkers.remove(worker);
    }

    public synchronized void onWorkerNotFullEvent(SelectorWorker worker) {
        this.freeWorkers.addFirst(worker);
    }

    public Executor getChannelExecutor() {
        return this.channelExecutor;
    }

    public void setChannelExecutor(Executor channelExecutor) {
        this.channelExecutor = channelExecutor;
    }

    public int getMaxChannelsPerWorker() {
        return this.maxChannelsPerWorker;
    }

    public void setMaxChannelsPerWorker(int maxChannelsPerWorker) {
        this.maxChannelsPerWorker = maxChannelsPerWorker;
    }

    public Executor getSelectorExecutor() {
        return this.selectorExecutor;
    }

    public void setSelectorExecutor(Executor selectorExecutor) {
        this.selectorExecutor = selectorExecutor;
    }

    public static interface Listener {
        public void onSelect(SelectorSelection var1);

        public void onError(SelectorSelection var1, Throwable var2);
    }
}

