/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls.test;

import java.io.IOException;
import java.io.PrintStream;
import java.security.SecureRandom;
import java.util.Vector;
import shaded.org.bouncycastle.asn1.x500.X500Name;
import shaded.org.bouncycastle.tls.AlertDescription;
import shaded.org.bouncycastle.tls.AlertLevel;
import shaded.org.bouncycastle.tls.Certificate;
import shaded.org.bouncycastle.tls.CertificateRequest;
import shaded.org.bouncycastle.tls.DefaultTlsServer;
import shaded.org.bouncycastle.tls.ProtocolVersion;
import shaded.org.bouncycastle.tls.TlsCredentialedDecryptor;
import shaded.org.bouncycastle.tls.TlsCredentialedSigner;
import shaded.org.bouncycastle.tls.TlsFatalAlert;
import shaded.org.bouncycastle.tls.TlsUtils;
import shaded.org.bouncycastle.tls.crypto.TlsCertificate;
import shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import shaded.org.bouncycastle.tls.test.TlsTestUtils;
import shaded.org.bouncycastle.util.encoders.Hex;

class MockTlsServer
extends DefaultTlsServer {
    MockTlsServer() {
        super(new BcTlsCrypto(new SecureRandom()));
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        PrintStream out = alertLevel == 2 ? System.err : System.out;
        out.println("TLS server raised alert: " + AlertLevel.getText(alertLevel) + ", " + AlertDescription.getText(alertDescription));
        if (message != null) {
            out.println("> " + message);
        }
        if (cause != null) {
            cause.printStackTrace(out);
        }
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        PrintStream out = alertLevel == 2 ? System.err : System.out;
        out.println("TLS server received alert: " + AlertLevel.getText(alertLevel) + ", " + AlertDescription.getText(alertDescription));
    }

    @Override
    public ProtocolVersion getServerVersion() throws IOException {
        ProtocolVersion serverVersion = super.getServerVersion();
        System.out.println("TLS server negotiated " + serverVersion);
        return serverVersion;
    }

    @Override
    public CertificateRequest getCertificateRequest() throws IOException {
        short[] certificateTypes = new short[]{1, 2, 64};
        Vector serverSigAlgs = null;
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(this.serverVersion)) {
            serverSigAlgs = TlsUtils.getDefaultSupportedSignatureAlgorithms(this.context);
        }
        Vector<X500Name> certificateAuthorities = new Vector<X500Name>();
        certificateAuthorities.addElement(new X500Name("CN=BouncyCastle TLS Test CA"));
        return new CertificateRequest(certificateTypes, serverSigAlgs, certificateAuthorities);
    }

    @Override
    public void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        boolean isEmpty;
        TlsCertificate[] chain = clientCertificate.getCertificateList();
        System.out.println("TLS server received client certificate chain of length " + chain.length);
        for (int i = 0; i != chain.length; ++i) {
            shaded.org.bouncycastle.asn1.x509.Certificate entry = shaded.org.bouncycastle.asn1.x509.Certificate.getInstance(chain[i].getEncoded());
            System.out.println("    fingerprint:SHA-256 " + TlsTestUtils.fingerprint(entry) + " (" + entry.getSubject() + ")");
        }
        boolean bl = isEmpty = clientCertificate == null || clientCertificate.isEmpty();
        if (!isEmpty && !TlsTestUtils.isCertificateOneOf(this.context.getCrypto(), chain[0], new String[]{"x509-client-dsa.pem", "x509-client-ecdsa.pem", "x509-client-rsa.pem"})) {
            throw new TlsFatalAlert(42);
        }
    }

    @Override
    public void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        byte[] tlsUnique = this.context.exportChannelBinding(1);
        System.out.println("'tls-unique': " + Hex.toHexString(tlsUnique));
    }

    @Override
    protected TlsCredentialedDecryptor getRSAEncryptionCredentials() throws IOException {
        return TlsTestUtils.loadEncryptionCredentials(this.context, new String[]{"x509-server-rsa-enc.pem", "x509-ca-rsa.pem"}, "x509-server-key-rsa-enc.pem");
    }

    @Override
    protected TlsCredentialedSigner getRSASignerCredentials() throws IOException {
        return TlsTestUtils.loadSignerCredentials(this.context, this.supportedSignatureAlgorithms, (short)1, "x509-server-rsa-sign.pem", "x509-server-key-rsa-sign.pem");
    }
}

