/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls.test;

import java.io.IOException;
import java.net.DatagramPacket;
import java.util.Vector;
import shaded.org.bouncycastle.tls.DatagramTransport;

public class MockDatagramAssociation {
    private int mtu;
    private MockDatagramTransport client;
    private MockDatagramTransport server;

    public MockDatagramAssociation(int mtu) {
        this.mtu = mtu;
        Vector clientQueue = new Vector();
        Vector serverQueue = new Vector();
        this.client = new MockDatagramTransport(clientQueue, serverQueue);
        this.server = new MockDatagramTransport(serverQueue, clientQueue);
    }

    public DatagramTransport getClient() {
        return this.client;
    }

    public DatagramTransport getServer() {
        return this.server;
    }

    private class MockDatagramTransport
    implements DatagramTransport {
        private Vector receiveQueue;
        private Vector sendQueue;

        MockDatagramTransport(Vector receiveQueue, Vector sendQueue) {
            this.receiveQueue = receiveQueue;
            this.sendQueue = sendQueue;
        }

        @Override
        public int getReceiveLimit() throws IOException {
            return MockDatagramAssociation.this.mtu;
        }

        @Override
        public int getSendLimit() throws IOException {
            return MockDatagramAssociation.this.mtu;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int receive(byte[] buf, int off, int len, int waitMillis) throws IOException {
            Vector vector = this.receiveQueue;
            synchronized (vector) {
                if (this.receiveQueue.isEmpty()) {
                    try {
                        this.receiveQueue.wait(waitMillis);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.receiveQueue.isEmpty()) {
                        return -1;
                    }
                }
                DatagramPacket packet = (DatagramPacket)this.receiveQueue.remove(0);
                int copyLength = Math.min(len, packet.getLength());
                System.arraycopy(packet.getData(), packet.getOffset(), buf, off, copyLength);
                return copyLength;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(byte[] buf, int off, int len) throws IOException {
            if (len > MockDatagramAssociation.this.mtu) {
                // empty if block
            }
            byte[] copy = new byte[len];
            System.arraycopy(buf, off, copy, 0, len);
            DatagramPacket packet = new DatagramPacket(copy, len);
            Vector vector = this.sendQueue;
            synchronized (vector) {
                this.sendQueue.addElement(packet);
                this.sendQueue.notify();
            }
        }

        @Override
        public void close() throws IOException {
        }
    }
}

