/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls.test;

import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.x500.X500Principal;
import shaded.org.bouncycastle.asn1.x500.X500Name;
import shaded.org.bouncycastle.asn1.x509.BasicConstraints;
import shaded.org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import shaded.org.bouncycastle.asn1.x509.Extension;
import shaded.org.bouncycastle.asn1.x509.KeyPurposeId;
import shaded.org.bouncycastle.cert.X509CertificateHolder;
import shaded.org.bouncycastle.cert.X509v3CertificateBuilder;
import shaded.org.bouncycastle.cert.jcajce.JcaX500NameUtil;
import shaded.org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import shaded.org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import shaded.org.bouncycastle.cert.jcajce.JcaX509v1CertificateBuilder;
import shaded.org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import shaded.org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class CertChainUtil {
    public static String BC = "BC";
    private static final AtomicLong serialNumber = new AtomicLong(1L);

    public static X509Certificate createMasterCert(String masterDN, KeyPair keyPair) throws Exception {
        JcaX509v1CertificateBuilder v1CertBuilder = new JcaX509v1CertificateBuilder(new X500Name(masterDN), BigInteger.valueOf(serialNumber.getAndIncrement()), new Date(System.currentTimeMillis() - 2592000000L), new Date(System.currentTimeMillis() + 2592000000L), new X500Name(masterDN), keyPair.getPublic());
        X509CertificateHolder cert = v1CertBuilder.build(new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(keyPair.getPrivate()));
        return new JcaX509CertificateConverter().setProvider(BC).getCertificate(cert);
    }

    public static X509Certificate createIntermediateCert(String interDN, PublicKey pubKey, PrivateKey rootPrivKey, X509Certificate rootCert) throws Exception {
        JcaX509v3CertificateBuilder v3CertBuilder = new JcaX509v3CertificateBuilder(JcaX500NameUtil.getIssuer(rootCert), BigInteger.valueOf(serialNumber.getAndIncrement()), new Date(System.currentTimeMillis() - 2592000000L), new Date(System.currentTimeMillis() + 2592000000L), new X500Name(interDN), pubKey);
        JcaX509ExtensionUtils utils = new JcaX509ExtensionUtils();
        v3CertBuilder.addExtension(Extension.subjectKeyIdentifier, false, utils.createSubjectKeyIdentifier(pubKey));
        v3CertBuilder.addExtension(Extension.authorityKeyIdentifier, false, utils.createAuthorityKeyIdentifier(rootCert));
        v3CertBuilder.addExtension(Extension.basicConstraints, true, new BasicConstraints(0));
        X509CertificateHolder cert = v3CertBuilder.build(new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(rootPrivKey));
        return new JcaX509CertificateConverter().setProvider(BC).getCertificate(cert);
    }

    public static X509Certificate createEndEntityCert(String endEntityDN, PublicKey pubKey, PrivateKey caPrivKey, X509Certificate caCert) throws Exception {
        X509v3CertificateBuilder v3CertBuilder = CertChainUtil.createBaseEndEntityBuilder(endEntityDN, pubKey, caCert);
        X509CertificateHolder cert = v3CertBuilder.build(new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(caPrivKey));
        return new JcaX509CertificateConverter().setProvider(BC).getCertificate(cert);
    }

    public static X509Certificate createEndEntityCert(String endEntityDN, PublicKey pubKey, PrivateKey caPrivKey, X509Certificate caCert, KeyPurposeId keyPurposeId) throws Exception {
        X509v3CertificateBuilder v3CertBuilder = CertChainUtil.createBaseEndEntityBuilder(endEntityDN, pubKey, caCert);
        v3CertBuilder.addExtension(Extension.extendedKeyUsage, true, new ExtendedKeyUsage(keyPurposeId));
        X509CertificateHolder cert = v3CertBuilder.build(new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(caPrivKey));
        return new JcaX509CertificateConverter().setProvider(BC).getCertificate(cert);
    }

    private static X509v3CertificateBuilder createBaseEndEntityBuilder(String endEntityDN, PublicKey pubKey, X509Certificate caCert) throws IOException, NoSuchAlgorithmException {
        JcaX509v3CertificateBuilder v3CertBuilder = new JcaX509v3CertificateBuilder(caCert.getIssuerX500Principal(), BigInteger.valueOf(serialNumber.getAndIncrement()), new Date(System.currentTimeMillis() - 2592000000L), new Date(System.currentTimeMillis() + 2592000000L), new X500Principal(new X500Name(endEntityDN).getEncoded()), pubKey);
        JcaX509ExtensionUtils utils = new JcaX509ExtensionUtils();
        v3CertBuilder.addExtension(Extension.subjectKeyIdentifier, false, utils.createSubjectKeyIdentifier(pubKey));
        v3CertBuilder.addExtension(Extension.authorityKeyIdentifier, false, utils.createAuthorityKeyIdentifier(caCert.getPublicKey()));
        v3CertBuilder.addExtension(Extension.basicConstraints, true, new BasicConstraints(false));
        return v3CertBuilder;
    }
}

