/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import java.security.SecureRandom;
import shaded.org.bouncycastle.tls.TlsFatalAlert;
import shaded.org.bouncycastle.tls.crypto.TlsCipher;
import shaded.org.bouncycastle.tls.crypto.TlsCrypto;
import shaded.org.bouncycastle.tls.crypto.TlsCryptoParameters;
import shaded.org.bouncycastle.tls.crypto.TlsHMAC;
import shaded.org.bouncycastle.tls.crypto.impl.TlsBlockCipherImpl;
import shaded.org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import shaded.org.bouncycastle.tls.crypto.impl.TlsSuiteHMac;
import shaded.org.bouncycastle.tls.crypto.impl.TlsSuiteMac;
import shaded.org.bouncycastle.util.Arrays;

public class TlsBlockCipher
implements TlsCipher {
    protected final TlsCrypto crypto;
    protected final TlsCryptoParameters cryptoParams;
    protected final byte[] randomData;
    protected final boolean encryptThenMAC;
    protected final boolean useExplicitIV;
    protected final boolean useExtraPadding;
    protected final TlsBlockCipherImpl decryptCipher;
    protected final TlsBlockCipherImpl encryptCipher;
    protected final TlsSuiteMac readMac;
    protected final TlsSuiteMac writeMac;

    public TlsBlockCipher(TlsCrypto crypto, TlsCryptoParameters cryptoParams, TlsBlockCipherImpl encryptCipher, TlsBlockCipherImpl decryptCipher, TlsHMAC clientMac, TlsHMAC serverMac, int cipherKeySize) throws IOException {
        TlsBlockCipherImpl serverCipher;
        TlsBlockCipherImpl clientCipher;
        this.cryptoParams = cryptoParams;
        this.crypto = crypto;
        this.randomData = cryptoParams.getNonceGenerator().generateNonce(256);
        this.encryptThenMAC = cryptoParams.getSecurityParameters().isEncryptThenMAC();
        this.useExplicitIV = TlsImplUtils.isTLSv11(cryptoParams);
        this.useExtraPadding = !cryptoParams.getServerVersion().isDTLS() && (this.encryptThenMAC || !cryptoParams.getSecurityParameters().isTruncatedHMac());
        this.encryptCipher = encryptCipher;
        this.decryptCipher = decryptCipher;
        if (cryptoParams.isServer()) {
            clientCipher = decryptCipher;
            serverCipher = encryptCipher;
        } else {
            clientCipher = encryptCipher;
            serverCipher = decryptCipher;
        }
        int key_block_size = 2 * cipherKeySize + clientMac.getMacLength() + serverMac.getMacLength();
        if (!this.useExplicitIV) {
            key_block_size += clientCipher.getBlockSize() + serverCipher.getBlockSize();
        }
        byte[] key_block = TlsImplUtils.calculateKeyBlock(cryptoParams, key_block_size);
        int offset = 0;
        clientMac.setKey(key_block, offset, clientMac.getMacLength());
        serverMac.setKey(key_block, offset += clientMac.getMacLength(), serverMac.getMacLength());
        clientCipher.setKey(key_block, offset += serverMac.getMacLength(), cipherKeySize);
        serverCipher.setKey(key_block, offset += cipherKeySize, cipherKeySize);
        offset += cipherKeySize;
        if (!this.useExplicitIV) {
            clientCipher.init(key_block, offset, clientCipher.getBlockSize());
            serverCipher.init(key_block, offset += clientCipher.getBlockSize(), serverCipher.getBlockSize());
            offset += serverCipher.getBlockSize();
        }
        if (offset != key_block_size) {
            throw new TlsFatalAlert(80);
        }
        if (cryptoParams.isServer()) {
            this.writeMac = new TlsSuiteHMac(cryptoParams, serverMac);
            this.readMac = new TlsSuiteHMac(cryptoParams, clientMac);
        } else {
            this.writeMac = new TlsSuiteHMac(cryptoParams, clientMac);
            this.readMac = new TlsSuiteHMac(cryptoParams, serverMac);
        }
    }

    @Override
    public int getCiphertextLimit(int plaintextLimit) {
        int maxPadding;
        int blockSize = this.encryptCipher.getBlockSize();
        int macSize = this.writeMac.getSize();
        int ciphertextLimit = plaintextLimit;
        if (this.useExplicitIV) {
            ciphertextLimit += blockSize;
        }
        int n = maxPadding = this.useExtraPadding ? 255 : blockSize;
        if (this.encryptThenMAC) {
            ciphertextLimit += maxPadding;
            ciphertextLimit -= ciphertextLimit % blockSize;
            ciphertextLimit += macSize;
        } else {
            ciphertextLimit += macSize;
            ciphertextLimit += maxPadding;
            ciphertextLimit -= ciphertextLimit % blockSize;
        }
        return ciphertextLimit;
    }

    @Override
    public int getPlaintextLimit(int ciphertextLimit) {
        int blockSize = this.encryptCipher.getBlockSize();
        int macSize = this.writeMac.getSize();
        int plaintextLimit = ciphertextLimit;
        if (this.useExplicitIV) {
            plaintextLimit -= blockSize;
        }
        if (this.encryptThenMAC) {
            plaintextLimit -= macSize;
            plaintextLimit -= plaintextLimit % blockSize;
        } else {
            plaintextLimit -= plaintextLimit % blockSize;
            plaintextLimit -= macSize;
        }
        return --plaintextLimit;
    }

    @Override
    public byte[] encodePlaintext(long seqNo, short type, byte[] plaintext, int offset, int len) throws IOException {
        int blockSize = this.encryptCipher.getBlockSize();
        int macSize = this.writeMac.getSize();
        int enc_input_length = len;
        if (!this.encryptThenMAC) {
            enc_input_length += macSize;
        }
        int padding_length = blockSize - 1 - enc_input_length % blockSize;
        if (this.useExtraPadding) {
            int maxExtraPadBlocks = (255 - padding_length) / blockSize;
            int actualExtraPadBlocks = this.chooseExtraPadBlocks(this.crypto.getSecureRandom(), maxExtraPadBlocks);
            padding_length += actualExtraPadBlocks * blockSize;
        }
        int totalSize = len + macSize + padding_length + 1;
        if (this.useExplicitIV) {
            totalSize += blockSize;
        }
        byte[] outBuf = new byte[totalSize];
        int outOff = 0;
        if (this.useExplicitIV) {
            byte[] explicitIV = this.cryptoParams.getNonceGenerator().generateNonce(blockSize);
            this.encryptCipher.init(explicitIV, 0, blockSize);
            System.arraycopy(explicitIV, 0, outBuf, outOff, blockSize);
            outOff += blockSize;
        }
        int blocks_start = outOff;
        System.arraycopy(plaintext, offset, outBuf, outOff, len);
        outOff += len;
        if (!this.encryptThenMAC) {
            byte[] mac = this.writeMac.calculateMac(seqNo, type, plaintext, offset, len);
            System.arraycopy(mac, 0, outBuf, outOff, mac.length);
            outOff += mac.length;
        }
        for (int i = 0; i <= padding_length; ++i) {
            outBuf[outOff++] = (byte)padding_length;
        }
        this.encryptCipher.doFinal(outBuf, blocks_start, outOff - blocks_start, outBuf, blocks_start);
        if (this.encryptThenMAC) {
            byte[] mac = this.writeMac.calculateMac(seqNo, type, outBuf, 0, outOff);
            System.arraycopy(mac, 0, outBuf, outOff, mac.length);
            outOff += mac.length;
        }
        return outBuf;
    }

    @Override
    public byte[] decodeCiphertext(long seqNo, short type, byte[] ciphertext, int offset, int len) throws IOException {
        int blockSize = this.decryptCipher.getBlockSize();
        int macSize = this.readMac.getSize();
        int minLen = blockSize;
        minLen = this.encryptThenMAC ? (minLen += macSize) : Math.max(minLen, macSize + 1);
        if (this.useExplicitIV) {
            minLen += blockSize;
        }
        if (len < minLen) {
            throw new TlsFatalAlert(50);
        }
        int blocks_length = len;
        if (this.encryptThenMAC) {
            blocks_length -= macSize;
        }
        if (blocks_length % blockSize != 0) {
            throw new TlsFatalAlert(21);
        }
        if (this.encryptThenMAC) {
            boolean badMac;
            int end = offset + len;
            byte[] receivedMac = Arrays.copyOfRange(ciphertext, end - macSize, end);
            byte[] calculatedMac = this.readMac.calculateMac(seqNo, type, ciphertext, offset, len - macSize);
            boolean bl = badMac = !Arrays.constantTimeAreEqual(calculatedMac, receivedMac);
            if (badMac) {
                throw new TlsFatalAlert(20);
            }
        }
        if (this.useExplicitIV) {
            this.decryptCipher.init(ciphertext, offset, blockSize);
            offset += blockSize;
            blocks_length -= blockSize;
        }
        this.decryptCipher.doFinal(ciphertext, offset, blocks_length, ciphertext, offset);
        int totalPad = this.checkPaddingConstantTime(ciphertext, offset, blocks_length, blockSize, this.encryptThenMAC ? 0 : macSize);
        boolean badMac = totalPad == 0;
        int dec_output_length = blocks_length - totalPad;
        if (!this.encryptThenMAC) {
            int macInputLen = dec_output_length -= macSize;
            int macOff = offset + macInputLen;
            byte[] receivedMac = Arrays.copyOfRange(ciphertext, macOff, macOff + macSize);
            byte[] calculatedMac = this.readMac.calculateMacConstantTime(seqNo, type, ciphertext, offset, macInputLen, blocks_length - macSize, this.randomData);
            badMac |= !Arrays.constantTimeAreEqual(calculatedMac, receivedMac);
        }
        if (badMac) {
            throw new TlsFatalAlert(20);
        }
        return Arrays.copyOfRange(ciphertext, offset, offset + dec_output_length);
    }

    protected int checkPaddingConstantTime(byte[] buf, int off, int len, int blockSize, int macSize) {
        int end = off + len;
        byte lastByte = buf[end - 1];
        int padlen = lastByte & 0xFF;
        int totalPad = padlen + 1;
        int dummyIndex = 0;
        int padDiff = 0;
        if (macSize + totalPad > len) {
            totalPad = 0;
        } else {
            int padPos = end - totalPad;
            do {
                padDiff = (byte)(padDiff | buf[padPos++] ^ lastByte);
            } while (padPos < end);
            dummyIndex = totalPad;
            if (padDiff != 0) {
                totalPad = 0;
            }
        }
        byte[] dummyPad = this.randomData;
        while (dummyIndex < 256) {
            padDiff = (byte)(padDiff | dummyPad[dummyIndex++] ^ lastByte);
        }
        dummyPad[0] = (byte)(dummyPad[0] ^ padDiff);
        return totalPad;
    }

    protected int chooseExtraPadBlocks(SecureRandom r, int max) {
        int x = r.nextInt();
        int n = this.lowestBitSet(x);
        return Math.min(n, max);
    }

    protected int lowestBitSet(int x) {
        if (x == 0) {
            return 32;
        }
        int n = 0;
        while ((x & 1) == 0) {
            ++n;
            x >>= 1;
        }
        return n;
    }
}

