/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls;

import java.io.IOException;
import java.io.OutputStream;
import shaded.org.bouncycastle.asn1.ASN1Encodable;
import shaded.org.bouncycastle.asn1.ASN1Integer;
import shaded.org.bouncycastle.asn1.DEROctetString;
import shaded.org.bouncycastle.asn1.DERSequence;
import shaded.org.bouncycastle.tls.TlsContext;
import shaded.org.bouncycastle.tls.TlsUtils;
import shaded.org.bouncycastle.tls.crypto.TlsCertificate;
import shaded.org.bouncycastle.tls.crypto.TlsSecret;
import shaded.org.bouncycastle.util.Arrays;

public abstract class TlsSM2Utils {
    private TlsSM2Utils() {
    }

    public static TlsSecret generateEncryptedPreMasterSecret(TlsContext context, TlsCertificate certificate, OutputStream output) throws IOException {
        TlsSecret preMasterSecret = context.getCrypto().generateSM2PreMasterSecret(context.getClientVersion());
        byte[] encryptedPreMasterSecret = preMasterSecret.encrypt(certificate);
        byte[] trimedBlock = 145 == encryptedPreMasterSecret.length && 4 == encryptedPreMasterSecret[0] ? Arrays.copyOfRange(encryptedPreMasterSecret, 1, encryptedPreMasterSecret.length) : encryptedPreMasterSecret;
        byte[] kx = Arrays.copyOfRange(trimedBlock, 0, 32);
        byte[] ky = Arrays.copyOfRange(trimedBlock, kx.length, kx.length * 2);
        byte[] hash = Arrays.copyOfRange(trimedBlock, kx.length + ky.length, kx.length + ky.length + 32);
        byte[] cipherBytes = Arrays.copyOfRange(trimedBlock, kx.length + ky.length + hash.length, trimedBlock.length);
        ASN1Integer kxASN1 = new ASN1Integer(kx);
        ASN1Integer kyASN1 = new ASN1Integer(ky);
        DEROctetString hashASN1 = new DEROctetString(hash);
        DEROctetString cipherASN1 = new DEROctetString(cipherBytes);
        DERSequence preMasterSecretSequence = new DERSequence(new ASN1Encodable[]{kxASN1, kyASN1, hashASN1, cipherASN1});
        byte[] preMasterSecretEncodBytes = preMasterSecretSequence.getEncoded();
        TlsUtils.writeOpaque16(preMasterSecretEncodBytes, output);
        return preMasterSecret;
    }
}

