/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import shaded.org.bouncycastle.tls.AbstractTlsKeyExchange;
import shaded.org.bouncycastle.tls.Certificate;
import shaded.org.bouncycastle.tls.TlsCredentialedDecryptor;
import shaded.org.bouncycastle.tls.TlsCredentials;
import shaded.org.bouncycastle.tls.TlsDHConfigVerifier;
import shaded.org.bouncycastle.tls.TlsDHUtils;
import shaded.org.bouncycastle.tls.TlsECCUtils;
import shaded.org.bouncycastle.tls.TlsECConfigVerifier;
import shaded.org.bouncycastle.tls.TlsFatalAlert;
import shaded.org.bouncycastle.tls.TlsPSKIdentity;
import shaded.org.bouncycastle.tls.TlsPSKIdentityManager;
import shaded.org.bouncycastle.tls.TlsRSAUtils;
import shaded.org.bouncycastle.tls.TlsUtils;
import shaded.org.bouncycastle.tls.crypto.TlsAgreement;
import shaded.org.bouncycastle.tls.crypto.TlsCertificate;
import shaded.org.bouncycastle.tls.crypto.TlsCryptoParameters;
import shaded.org.bouncycastle.tls.crypto.TlsDHConfig;
import shaded.org.bouncycastle.tls.crypto.TlsECConfig;
import shaded.org.bouncycastle.tls.crypto.TlsSecret;
import shaded.org.bouncycastle.util.Arrays;

public class TlsPSKKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsPSKIdentity pskIdentity;
    protected TlsPSKIdentityManager pskIdentityManager;
    protected TlsDHConfigVerifier dhConfigVerifier;
    protected TlsECConfigVerifier ecConfigVerifier;
    protected short[] clientECPointFormats;
    protected short[] serverECPointFormats;
    protected byte[] psk_identity_hint = null;
    protected byte[] psk = null;
    protected TlsDHConfig dhConfig;
    protected TlsECConfig ecConfig;
    protected TlsAgreement agreement;
    protected TlsCredentialedDecryptor serverCredentials = null;
    protected TlsCertificate serverCertificate;
    protected TlsSecret preMasterSecret;

    public TlsPSKKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsPSKIdentity pskIdentity, TlsDHConfigVerifier dhConfigVerifier, TlsECConfigVerifier ecConfigVerifier, short[] clientECPointFormats, short[] serverECPointFormats) {
        this(keyExchange, supportedSignatureAlgorithms, pskIdentity, null, dhConfigVerifier, null, ecConfigVerifier, null, clientECPointFormats, serverECPointFormats);
    }

    public TlsPSKKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsPSKIdentity pskIdentity, TlsPSKIdentityManager pskIdentityManager, TlsDHConfig dhConfig, TlsECConfig ecConfig, short[] serverECPointFormats) {
        this(keyExchange, supportedSignatureAlgorithms, pskIdentity, pskIdentityManager, null, dhConfig, null, ecConfig, null, serverECPointFormats);
    }

    private TlsPSKKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsPSKIdentity pskIdentity, TlsPSKIdentityManager pskIdentityManager, TlsDHConfigVerifier dhConfigVerifier, TlsDHConfig dhConfig, TlsECConfigVerifier ecConfigVerifier, TlsECConfig ecConfig, short[] clientECPointFormats, short[] serverECPointFormats) {
        super(keyExchange, supportedSignatureAlgorithms);
        switch (keyExchange) {
            case 13: 
            case 14: 
            case 15: 
            case 24: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported key exchange algorithm");
            }
        }
        this.pskIdentity = pskIdentity;
        this.pskIdentityManager = pskIdentityManager;
        this.dhConfigVerifier = dhConfigVerifier;
        this.dhConfig = dhConfig;
        this.ecConfigVerifier = ecConfigVerifier;
        this.ecConfig = ecConfig;
        this.clientECPointFormats = clientECPointFormats;
        this.serverECPointFormats = serverECPointFormats;
    }

    @Override
    public void skipServerCredentials() throws IOException {
        if (this.keyExchange == 15) {
            throw new TlsFatalAlert(80);
        }
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (this.keyExchange != 15) {
            throw new TlsFatalAlert(80);
        }
        if (!(serverCredentials instanceof TlsCredentialedDecryptor)) {
            throw new TlsFatalAlert(80);
        }
        this.serverCredentials = (TlsCredentialedDecryptor)serverCredentials;
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (this.keyExchange != 15) {
            throw new TlsFatalAlert(10);
        }
        if (serverCertificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        this.checkServerCertSigAlg(serverCertificate);
        this.serverCertificate = serverCertificate.getCertificateAt(0).useInRole(0, this.keyExchange);
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        this.psk_identity_hint = this.pskIdentityManager.getHint();
        if (this.psk_identity_hint == null && !this.requiresServerKeyExchange()) {
            return null;
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        if (this.psk_identity_hint == null) {
            TlsUtils.writeOpaque16(TlsUtils.EMPTY_BYTES, buf);
        } else {
            TlsUtils.writeOpaque16(this.psk_identity_hint, buf);
        }
        if (this.keyExchange == 14) {
            if (this.dhConfig == null) {
                throw new TlsFatalAlert(80);
            }
            TlsDHUtils.writeDHConfig(this.dhConfig, buf);
            this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
            this.generateEphemeralDH(buf);
        } else if (this.keyExchange == 24) {
            if (this.ecConfig == null) {
                throw new TlsFatalAlert(80);
            }
            TlsECCUtils.writeECConfig(this.ecConfig, buf);
            this.agreement = this.context.getCrypto().createECDomain(this.ecConfig).createECDH();
            this.generateEphemeralECDH(buf);
        }
        return buf.toByteArray();
    }

    @Override
    public boolean requiresServerKeyExchange() {
        switch (this.keyExchange) {
            case 14: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        this.psk_identity_hint = TlsUtils.readOpaque16(input);
        if (this.keyExchange == 14) {
            this.dhConfig = TlsDHUtils.receiveDHConfig(this.dhConfigVerifier, input);
            byte[] y = TlsUtils.readOpaque16(input);
            this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
            this.processEphemeralDH(y);
        } else if (this.keyExchange == 24) {
            this.ecConfig = TlsECCUtils.receiveECConfig(this.ecConfigVerifier, this.serverECPointFormats, input);
            byte[] point = TlsUtils.readOpaque8(input);
            this.agreement = this.context.getCrypto().createECDomain(this.ecConfig).createECDH();
            this.processEphemeralECDH(this.clientECPointFormats, point);
        }
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void generateClientKeyExchange(OutputStream output) throws IOException {
        if (this.psk_identity_hint == null) {
            this.pskIdentity.skipIdentityHint();
        } else {
            this.pskIdentity.notifyIdentityHint(this.psk_identity_hint);
        }
        byte[] psk_identity = this.pskIdentity.getPSKIdentity();
        if (psk_identity == null) {
            throw new TlsFatalAlert(80);
        }
        this.psk = this.pskIdentity.getPSK();
        if (this.psk == null) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.writeOpaque16(psk_identity, output);
        this.context.getSecurityParameters().pskIdentity = Arrays.clone(psk_identity);
        if (this.keyExchange == 14) {
            this.generateEphemeralDH(output);
        } else if (this.keyExchange == 24) {
            this.generateEphemeralECDH(output);
        } else if (this.keyExchange == 15) {
            this.preMasterSecret = TlsRSAUtils.generateEncryptedPreMasterSecret(this.context, this.serverCertificate, output);
        }
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        byte[] psk_identity = TlsUtils.readOpaque16(input);
        this.psk = this.pskIdentityManager.getPSK(psk_identity);
        if (this.psk == null) {
            throw new TlsFatalAlert(115);
        }
        this.context.getSecurityParameters().pskIdentity = psk_identity;
        if (this.keyExchange == 14) {
            byte[] y = TlsUtils.readOpaque16(input);
            this.processEphemeralDH(y);
        } else if (this.keyExchange == 24) {
            byte[] point = TlsUtils.readOpaque8(input);
            this.processEphemeralECDH(this.serverECPointFormats, point);
        } else if (this.keyExchange == 15) {
            byte[] encryptedPreMasterSecret = TlsUtils.readOpaque16(input);
            this.preMasterSecret = this.serverCredentials.decrypt(new TlsCryptoParameters(this.context), encryptedPreMasterSecret);
        }
    }

    @Override
    public TlsSecret generatePreMasterSecret() throws IOException {
        byte[] other_secret = this.generateOtherSecret(this.psk.length);
        ByteArrayOutputStream buf = new ByteArrayOutputStream(4 + other_secret.length + this.psk.length);
        TlsUtils.writeOpaque16(other_secret, buf);
        TlsUtils.writeOpaque16(this.psk, buf);
        Arrays.fill(this.psk, (byte)0);
        this.psk = null;
        return this.context.getCrypto().createSecret(buf.toByteArray());
    }

    protected void generateEphemeralDH(OutputStream output) throws IOException {
        byte[] y = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque16(y, output);
    }

    protected void generateEphemeralECDH(OutputStream output) throws IOException {
        byte[] point = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque8(point, output);
    }

    protected byte[] generateOtherSecret(int pskLength) throws IOException {
        if (this.keyExchange == 13) {
            return new byte[pskLength];
        }
        if ((this.keyExchange == 14 || this.keyExchange == 24) && this.agreement != null) {
            return this.agreement.calculateSecret().extract();
        }
        if (this.keyExchange == 15 && this.preMasterSecret != null) {
            return this.preMasterSecret.extract();
        }
        throw new TlsFatalAlert(80);
    }

    protected void processEphemeralDH(byte[] y) throws IOException {
        this.agreement.receivePeerValue(y);
    }

    protected void processEphemeralECDH(short[] localECPointFormats, byte[] point) throws IOException {
        TlsECCUtils.checkPointEncoding(localECPointFormats, this.ecConfig.getNamedGroup(), point);
        this.agreement.receivePeerValue(point);
    }
}

