/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import shaded.org.bouncycastle.tls.AbstractTlsKeyExchange;
import shaded.org.bouncycastle.tls.Certificate;
import shaded.org.bouncycastle.tls.TlsCredentialedAgreement;
import shaded.org.bouncycastle.tls.TlsCredentials;
import shaded.org.bouncycastle.tls.TlsDHConfigVerifier;
import shaded.org.bouncycastle.tls.TlsDHUtils;
import shaded.org.bouncycastle.tls.TlsFatalAlert;
import shaded.org.bouncycastle.tls.TlsUtils;
import shaded.org.bouncycastle.tls.crypto.TlsAgreement;
import shaded.org.bouncycastle.tls.crypto.TlsCertificate;
import shaded.org.bouncycastle.tls.crypto.TlsDHConfig;
import shaded.org.bouncycastle.tls.crypto.TlsSecret;

public class TlsDHKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsDHConfigVerifier dhConfigVerifier;
    protected TlsCredentialedAgreement agreementCredentials;
    protected TlsCertificate dhPeerCertificate;
    protected TlsDHConfig dhConfig;
    protected TlsAgreement agreement;

    private static int checkKeyExchange(int keyExchange) {
        switch (keyExchange) {
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                return keyExchange;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsDHKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsDHConfigVerifier dhConfigVerifier) {
        this(keyExchange, supportedSignatureAlgorithms, dhConfigVerifier, null);
    }

    public TlsDHKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsDHConfig dhConfig) {
        this(keyExchange, supportedSignatureAlgorithms, null, dhConfig);
    }

    private TlsDHKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsDHConfigVerifier dhConfigVerifier, TlsDHConfig dhConfig) {
        super(TlsDHKeyExchange.checkKeyExchange(keyExchange), supportedSignatureAlgorithms);
        this.dhConfigVerifier = dhConfigVerifier;
        this.dhConfig = dhConfig;
    }

    @Override
    public void skipServerCredentials() throws IOException {
        if (this.keyExchange != 11) {
            throw new TlsFatalAlert(80);
        }
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (this.keyExchange == 11) {
            throw new TlsFatalAlert(80);
        }
        if (!(serverCredentials instanceof TlsCredentialedAgreement)) {
            throw new TlsFatalAlert(80);
        }
        this.agreementCredentials = (TlsCredentialedAgreement)serverCredentials;
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (this.keyExchange == 11) {
            throw new TlsFatalAlert(10);
        }
        this.checkServerCertSigAlg(serverCertificate);
        this.dhPeerCertificate = this.validatePeerCertificate(0, serverCertificate);
    }

    @Override
    public boolean requiresServerKeyExchange() {
        switch (this.keyExchange) {
            case 3: 
            case 5: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        if (!this.requiresServerKeyExchange()) {
            return null;
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        TlsDHUtils.writeDHConfig(this.dhConfig, buf);
        this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
        this.generateEphemeral(buf);
        return buf.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        if (!this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(10);
        }
        this.dhConfig = TlsDHUtils.receiveDHConfig(this.dhConfigVerifier, input);
        byte[] y = TlsUtils.readOpaque16(input);
        this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
        this.processEphemeral(y);
    }

    @Override
    public short[] getClientCertificateTypes() {
        if (this.keyExchange == 11) {
            return null;
        }
        return new short[]{4, 3};
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        if (this.keyExchange == 11) {
            throw new TlsFatalAlert(80);
        }
        if (!(clientCredentials instanceof TlsCredentialedAgreement)) {
            throw new TlsFatalAlert(80);
        }
        this.agreementCredentials = (TlsCredentialedAgreement)clientCredentials;
    }

    @Override
    public void generateClientKeyExchange(OutputStream output) throws IOException {
        if (this.agreementCredentials == null) {
            this.generateEphemeral(output);
        }
    }

    @Override
    public void processClientCertificate(Certificate clientCertificate) throws IOException {
        if (this.keyExchange == 11) {
            throw new TlsFatalAlert(10);
        }
        if (this.agreementCredentials != null) {
            this.dhPeerCertificate = this.validatePeerCertificate(1, clientCertificate);
        }
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        if (this.dhPeerCertificate != null) {
            return;
        }
        byte[] y = TlsUtils.readOpaque16(input);
        this.processEphemeral(y);
    }

    @Override
    public TlsSecret generatePreMasterSecret() throws IOException {
        if (this.agreementCredentials != null) {
            return this.agreementCredentials.generateAgreement(this.dhPeerCertificate);
        }
        if (this.agreement != null) {
            return this.agreement.calculateSecret();
        }
        throw new TlsFatalAlert(80);
    }

    protected void generateEphemeral(OutputStream output) throws IOException {
        byte[] y = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque16(y, output);
    }

    protected void processEphemeral(byte[] y) throws IOException {
        this.agreement.receivePeerValue(y);
    }

    protected TlsCertificate validatePeerCertificate(int connectionEnd, Certificate peerCertificate) throws IOException {
        if (peerCertificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        return peerCertificate.getCertificateAt(0).useInRole(connectionEnd, this.keyExchange);
    }
}

