/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import shaded.org.bouncycastle.tls.DeferredHash;
import shaded.org.bouncycastle.tls.ProtocolVersion;
import shaded.org.bouncycastle.tls.RecordPreview;
import shaded.org.bouncycastle.tls.SimpleOutputStream;
import shaded.org.bouncycastle.tls.TlsCompression;
import shaded.org.bouncycastle.tls.TlsContext;
import shaded.org.bouncycastle.tls.TlsFatalAlert;
import shaded.org.bouncycastle.tls.TlsHandshakeHash;
import shaded.org.bouncycastle.tls.TlsNullCompression;
import shaded.org.bouncycastle.tls.TlsProtocol;
import shaded.org.bouncycastle.tls.TlsUtils;
import shaded.org.bouncycastle.tls.crypto.TlsCipher;
import shaded.org.bouncycastle.tls.crypto.TlsNullNullCipher;

class RecordStream {
    private static int DEFAULT_PLAINTEXT_LIMIT = 16384;
    private TlsProtocol handler;
    private InputStream input;
    private OutputStream output;
    private TlsCompression pendingCompression = null;
    private TlsCompression readCompression = null;
    private TlsCompression writeCompression = null;
    private TlsCipher pendingCipher = null;
    private TlsCipher readCipher = null;
    private TlsCipher writeCipher = null;
    private SequenceNumber readSeqNo = new SequenceNumber();
    private SequenceNumber writeSeqNo = new SequenceNumber();
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private TlsHandshakeHash handshakeHash = null;
    private SimpleOutputStream handshakeHashUpdater = new SimpleOutputStream(){

        @Override
        public void write(byte[] buf, int off, int len) throws IOException {
            RecordStream.this.handshakeHash.update(buf, off, len);
        }
    };
    private ProtocolVersion readVersion = null;
    private ProtocolVersion writeVersion = null;
    private boolean restrictReadVersion = true;
    private int plaintextLimit;
    private int compressedLimit;
    private int ciphertextLimit;

    RecordStream(TlsProtocol handler, InputStream input, OutputStream output) {
        this.handler = handler;
        this.input = input;
        this.output = output;
        this.writeCompression = this.readCompression = new TlsNullCompression();
    }

    void init(TlsContext context) {
        this.writeCipher = this.readCipher = new TlsNullNullCipher();
        this.handshakeHash = new DeferredHash(context);
        this.setPlaintextLimit(DEFAULT_PLAINTEXT_LIMIT);
    }

    int getPlaintextLimit() {
        return this.plaintextLimit;
    }

    void setPlaintextLimit(int plaintextLimit) {
        this.plaintextLimit = plaintextLimit;
        this.compressedLimit = this.plaintextLimit + 1024;
        this.ciphertextLimit = this.compressedLimit + 1024;
    }

    ProtocolVersion getReadVersion() {
        return this.readVersion;
    }

    void setReadVersion(ProtocolVersion readVersion) {
        this.readVersion = readVersion;
    }

    void setWriteVersion(ProtocolVersion writeVersion) {
        this.writeVersion = writeVersion;
    }

    void setRestrictReadVersion(boolean enabled) {
        this.restrictReadVersion = enabled;
    }

    void setPendingConnectionState(TlsCompression tlsCompression, TlsCipher tlsCipher) {
        this.pendingCompression = tlsCompression;
        this.pendingCipher = tlsCipher;
    }

    void sentWriteCipherSpec() throws IOException {
        if (this.pendingCompression == null || this.pendingCipher == null) {
            throw new TlsFatalAlert(40);
        }
        this.writeCompression = this.pendingCompression;
        this.writeCipher = this.pendingCipher;
        this.writeSeqNo = new SequenceNumber();
    }

    void receivedReadCipherSpec() throws IOException {
        if (this.pendingCompression == null || this.pendingCipher == null) {
            throw new TlsFatalAlert(40);
        }
        this.readCompression = this.pendingCompression;
        this.readCipher = this.pendingCipher;
        this.readSeqNo = new SequenceNumber();
    }

    void finaliseHandshake() throws IOException {
        if (this.readCompression != this.pendingCompression || this.writeCompression != this.pendingCompression || this.readCipher != this.pendingCipher || this.writeCipher != this.pendingCipher) {
            throw new TlsFatalAlert(40);
        }
        this.pendingCompression = null;
        this.pendingCipher = null;
    }

    RecordPreview previewRecordHeader(byte[] recordHeader, boolean appDataReady) throws IOException {
        short type = TlsUtils.readUint8(recordHeader, 0);
        if (!appDataReady && type == 23) {
            throw new TlsFatalAlert(10);
        }
        RecordStream.checkType(type, (short)10);
        if (!this.restrictReadVersion) {
            int version = TlsUtils.readVersionRaw(recordHeader, 1);
            if ((version & 0xFFFFFF00) != 768) {
                throw new TlsFatalAlert(47);
            }
        } else {
            ProtocolVersion version = TlsUtils.readVersion(recordHeader, 1);
            if (this.readVersion != null && !version.equals(this.readVersion)) {
                throw new TlsFatalAlert(47);
            }
        }
        int length = TlsUtils.readUint16(recordHeader, 3);
        RecordStream.checkLength(length, this.ciphertextLimit, (short)22);
        int recordSize = 5 + length;
        int applicationDataLimit = 0;
        if (type == 23) {
            applicationDataLimit = this.getPlaintextLimit();
            if (this.readCompression.getClass() == TlsNullCompression.class) {
                applicationDataLimit = Math.min(applicationDataLimit, this.readCipher.getPlaintextLimit(length));
            }
        }
        return new RecordPreview(recordSize, applicationDataLimit);
    }

    RecordPreview previewOutputRecord(int applicationDataSize) {
        int applicationDataLimit;
        int recordSize = applicationDataLimit = Math.max(0, Math.min(this.getPlaintextLimit(), applicationDataSize));
        if (this.writeCompression.getClass() != TlsNullCompression.class) {
            recordSize += 1024;
        }
        recordSize = this.writeCipher.getCiphertextLimit(recordSize) + 5;
        return new RecordPreview(recordSize, applicationDataLimit);
    }

    boolean readFullRecord(byte[] record) throws IOException {
        if (record.length < 5) {
            return false;
        }
        int length = TlsUtils.readUint16(record, 3);
        if (record.length != 5 + length) {
            return false;
        }
        short type = TlsUtils.readUint8(record, 0);
        RecordStream.checkType(type, (short)10);
        if (!this.restrictReadVersion) {
            int version = TlsUtils.readVersionRaw(record, 1);
            if ((version & 0xFFFFFF00) != 768) {
                throw new TlsFatalAlert(47);
            }
        } else {
            ProtocolVersion version = TlsUtils.readVersion(record, 1);
            if (this.readVersion == null) {
                this.readVersion = version;
            } else if (!version.equals(this.readVersion)) {
                throw new TlsFatalAlert(47);
            }
        }
        RecordStream.checkLength(length, this.ciphertextLimit, (short)22);
        byte[] plaintext = this.decodeAndVerify(type, record, 5, length);
        this.handler.processRecord(type, plaintext, 0, plaintext.length);
        return true;
    }

    boolean readRecord() throws IOException {
        byte[] recordHeader = TlsUtils.readAllOrNothing(5, this.input);
        if (recordHeader == null) {
            return false;
        }
        short type = TlsUtils.readUint8(recordHeader, 0);
        RecordStream.checkType(type, (short)10);
        if (!this.restrictReadVersion) {
            int version = TlsUtils.readVersionRaw(recordHeader, 1);
            if ((version & 0xFFFFFF00) != 768 && (version & 0xFFFFFF00) != 256) {
                throw new TlsFatalAlert(47);
            }
        } else {
            ProtocolVersion version = TlsUtils.readVersion(recordHeader, 1);
            if (this.readVersion == null) {
                this.readVersion = version;
            } else if (!version.equals(this.readVersion)) {
                throw new TlsFatalAlert(47);
            }
        }
        int length = TlsUtils.readUint16(recordHeader, 3);
        RecordStream.checkLength(length, this.ciphertextLimit, (short)22);
        byte[] ciphertext = TlsUtils.readFully(length, this.input);
        byte[] plaintext = this.decodeAndVerify(type, ciphertext, 0, length);
        this.handler.processRecord(type, plaintext, 0, plaintext.length);
        return true;
    }

    byte[] decodeAndVerify(short type, byte[] ciphertext, int off, int len) throws IOException {
        long seqNo = this.readSeqNo.nextValue((short)10);
        byte[] decoded = this.readCipher.decodeCiphertext(seqNo, type, ciphertext, off, len);
        RecordStream.checkLength(decoded.length, this.compressedLimit, (short)22);
        OutputStream cOut = this.readCompression.decompress(this.buffer);
        if (cOut != this.buffer) {
            cOut.write(decoded, 0, decoded.length);
            cOut.flush();
            decoded = this.getBufferContents();
        }
        RecordStream.checkLength(decoded.length, this.plaintextLimit, (short)30);
        if (decoded.length < 1 && type != 23) {
            throw new TlsFatalAlert(47);
        }
        return decoded;
    }

    void writeRecord(short type, byte[] plaintext, int plaintextOffset, int plaintextLength) throws IOException {
        byte[] ciphertext;
        if (this.writeVersion == null) {
            return;
        }
        RecordStream.checkType(type, (short)80);
        RecordStream.checkLength(plaintextLength, this.plaintextLimit, (short)80);
        if (plaintextLength < 1 && type != 23) {
            throw new TlsFatalAlert(80);
        }
        OutputStream cOut = this.writeCompression.compress(this.buffer);
        long seqNo = this.writeSeqNo.nextValue((short)80);
        if (cOut == this.buffer) {
            ciphertext = this.writeCipher.encodePlaintext(seqNo, type, plaintext, plaintextOffset, plaintextLength);
        } else {
            cOut.write(plaintext, plaintextOffset, plaintextLength);
            cOut.flush();
            byte[] compressed = this.getBufferContents();
            RecordStream.checkLength(compressed.length, plaintextLength + 1024, (short)80);
            ciphertext = this.writeCipher.encodePlaintext(seqNo, type, compressed, 0, compressed.length);
        }
        RecordStream.checkLength(ciphertext.length, this.ciphertextLimit, (short)80);
        byte[] record = new byte[5 + ciphertext.length];
        TlsUtils.writeUint8(type, record, 0);
        TlsUtils.writeVersion(this.writeVersion, record, 1);
        TlsUtils.writeUint16(ciphertext.length, record, 3);
        System.arraycopy(ciphertext, 0, record, 5, ciphertext.length);
        this.output.write(record);
        this.output.flush();
    }

    void notifyHelloComplete() {
        this.handshakeHash = this.handshakeHash.notifyPRFDetermined();
    }

    TlsHandshakeHash getHandshakeHash() {
        return this.handshakeHash;
    }

    OutputStream getHandshakeHashUpdater() {
        return this.handshakeHashUpdater;
    }

    TlsHandshakeHash prepareToFinish() {
        TlsHandshakeHash result = this.handshakeHash;
        this.handshakeHash = this.handshakeHash.stopTracking();
        return result;
    }

    void safeClose() {
        try {
            this.input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void flush() throws IOException {
        this.output.flush();
    }

    private byte[] getBufferContents() {
        byte[] contents = this.buffer.toByteArray();
        this.buffer.reset();
        return contents;
    }

    private static void checkType(short type, short alertDescription) throws IOException {
        switch (type) {
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            default: {
                throw new TlsFatalAlert(alertDescription);
            }
        }
    }

    private static void checkLength(int length, int limit, short alertDescription) throws IOException {
        if (length > limit) {
            throw new TlsFatalAlert(alertDescription);
        }
    }

    private static class SequenceNumber {
        private long value = 0L;
        private boolean exhausted = false;

        private SequenceNumber() {
        }

        synchronized long nextValue(short alertDescription) throws TlsFatalAlert {
            if (this.exhausted) {
                throw new TlsFatalAlert(alertDescription);
            }
            long result = this.value++;
            if (this.value == 0L) {
                this.exhausted = true;
            }
            return result;
        }
    }
}

