/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.jsse.provider.test;

import java.security.SecureRandom;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import junit.framework.TestCase;
import shaded.org.bouncycastle.jsse.provider.test.CipherSuitesTestConfig;
import shaded.org.bouncycastle.jsse.provider.test.TestProtocolUtil;
import shaded.org.bouncycastle.jsse.provider.test.TestUtils;
import shaded.org.bouncycastle.util.Arrays;

public class CipherSuitesTestCase
extends TestCase {
    protected final CipherSuitesTestConfig config;
    private static final String HOST = "localhost";
    private static final AtomicInteger PORT_NO = new AtomicInteger(9100);

    public CipherSuitesTestCase(String name) {
        super(name);
        this.config = null;
    }

    public CipherSuitesTestCase(CipherSuitesTestConfig config) {
        super(config.cipherSuite);
        this.config = config;
    }

    public void testDummy() {
    }

    protected void runTest() throws Throwable {
        if (this.config == null) {
            return;
        }
        int port = PORT_NO.incrementAndGet();
        SimpleServer server = new SimpleServer(port, this.config);
        SimpleClient client = new SimpleClient(port, this.config);
        TestProtocolUtil.runClientAndServer(server, client);
        TestCase.assertNotNull((Object)server.tlsUnique);
        TestCase.assertNotNull((Object)client.tlsUnique);
        TestCase.assertTrue((boolean)Arrays.areEqual(server.tlsUnique, client.tlsUnique));
    }

    static class SimpleServer
    implements TestProtocolUtil.BlockingCallable {
        private final int port;
        private final CipherSuitesTestConfig config;
        private final CountDownLatch latch;
        private byte[] tlsUnique = null;

        SimpleServer(int port, CipherSuitesTestConfig config) {
            this.port = port;
            this.config = config;
            this.latch = new CountDownLatch(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Exception call() throws Exception {
            try {
                KeyManagerFactory keyMgrFact = KeyManagerFactory.getInstance("PKIX", "BCJSSE");
                keyMgrFact.init(this.config.serverKeyStore, this.config.serverPassword);
                SSLContext serverContext = SSLContext.getInstance("TLS", "BCJSSE");
                serverContext.init(keyMgrFact.getKeyManagers(), null, SecureRandom.getInstance("DEFAULT", "BC"));
                SSLServerSocketFactory fact = serverContext.getServerSocketFactory();
                SSLServerSocket sSock = (SSLServerSocket)fact.createServerSocket(this.port);
                sSock.setEnabledCipherSuites(new String[]{this.config.cipherSuite});
                this.latch.countDown();
                SSLSocket sslSock = (SSLSocket)sSock.accept();
                sslSock.setUseClientMode(false);
                this.tlsUnique = TestUtils.getChannelBinding(sslSock, "tls-unique");
                TestProtocolUtil.doServerProtocol(sslSock, "World");
                sslSock.close();
                sSock.close();
            }
            finally {
                this.latch.countDown();
            }
            return null;
        }

        @Override
        public void await() throws InterruptedException {
            this.latch.await();
        }
    }

    static class SimpleClient
    implements TestProtocolUtil.BlockingCallable {
        private final int port;
        private final CipherSuitesTestConfig config;
        private final CountDownLatch latch;
        private byte[] tlsUnique = null;

        SimpleClient(int port, CipherSuitesTestConfig config) {
            this.port = port;
            this.config = config;
            this.latch = new CountDownLatch(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Exception call() throws Exception {
            try {
                TrustManagerFactory trustMgrFact = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
                trustMgrFact.init(this.config.clientTrustStore);
                SSLContext clientContext = SSLContext.getInstance("TLS", "BCJSSE");
                clientContext.init(null, trustMgrFact.getTrustManagers(), SecureRandom.getInstance("DEFAULT", "BC"));
                SSLSocketFactory fact = clientContext.getSocketFactory();
                SSLSocket cSock = (SSLSocket)fact.createSocket(CipherSuitesTestCase.HOST, this.port);
                cSock.setEnabledCipherSuites(new String[]{this.config.cipherSuite});
                this.tlsUnique = TestUtils.getChannelBinding(cSock, "tls-unique");
                TestProtocolUtil.doClientProtocol(cSock, "Hello");
            }
            finally {
                this.latch.countDown();
            }
            return null;
        }

        @Override
        public void await() throws InterruptedException {
            this.latch.await();
        }
    }
}

