/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.jsse.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import shaded.org.bouncycastle.jsse.BCSNIMatcher;
import shaded.org.bouncycastle.jsse.BCSNIServerName;
import shaded.org.bouncycastle.jsse.provider.JsseUtils;
import shaded.org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import shaded.org.bouncycastle.jsse.provider.SSLParametersUtil;

class ProvSSLParameters {
    static final boolean hasSslParameters;
    private String[] cipherSuites;
    private String[] protocols;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private Object algorithmConstraints;
    private String endpointIdentificationAlgorithm;
    private boolean useCipherSuitesOrder;
    private List<BCSNIMatcher> sniMatchers;
    private List<BCSNIServerName> sniServerNames;

    ProvSSLParameters() {
    }

    private static <T> List<T> copyList(List<T> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public void setCipherSuites(String[] cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public void setProtocols(String[] protocols) {
        this.protocols = protocols;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public String[] getCipherSuites() {
        return (String[])this.cipherSuites.clone();
    }

    public String[] getProtocols() {
        return (String[])this.protocols.clone();
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public Object getAlgorithmConstraints() {
        return this.algorithmConstraints;
    }

    public void setAlgorithmConstraints(Object algorithmConstraints) {
        this.algorithmConstraints = algorithmConstraints;
    }

    public String getEndpointIdentificationAlgorithm() {
        return this.endpointIdentificationAlgorithm;
    }

    public void setEndpointIdentificationAlgorithm(String endpointIdentificationAlgorithm) {
        this.endpointIdentificationAlgorithm = endpointIdentificationAlgorithm;
    }

    public boolean getUseCipherSuitesOrder() {
        return this.useCipherSuitesOrder;
    }

    public void setUseCipherSuitesOrder(boolean honorOrder) {
        this.useCipherSuitesOrder = honorOrder;
    }

    public List<BCSNIServerName> getServerNames() {
        return ProvSSLParameters.copyList(this.sniServerNames);
    }

    public void setServerNames(List<BCSNIServerName> serverNames) {
        this.sniServerNames = ProvSSLParameters.copyList(serverNames);
    }

    public Collection<BCSNIMatcher> getSNIMatchers() {
        return ProvSSLParameters.copyList(this.sniMatchers);
    }

    public void setSNIMatchers(Collection<BCSNIMatcher> matchers) {
        throw new UnsupportedOperationException();
    }

    static ProvSSLParameters extractDefaultParameters(ProvSSLContextSpi context) {
        String[] protocols;
        if (hasSslParameters) {
            return SSLParametersUtil.toProvSSLParameters(context.engineGetDefaultSSLParameters());
        }
        ProvSSLParameters params = new ProvSSLParameters();
        String[] cipherSuites = context.getDefaultCipherSuites();
        if (cipherSuites != null) {
            params.setCipherSuites(cipherSuites);
        }
        if ((protocols = context.getDefaultProtocols()) != null) {
            params.setProtocols(protocols);
        }
        params.setNeedClientAuth(false);
        params.setWantClientAuth(false);
        return params;
    }

    static {
        Class clazz = null;
        try {
            clazz = JsseUtils.loadClass(ProvSSLParameters.class, "javax.net.ssl.SSLParameters");
        }
        catch (Exception e) {
            clazz = null;
        }
        hasSslParameters = clazz != null;
    }
}

