/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.crypto.agreement;

import java.math.BigInteger;
import shaded.org.bouncycastle.crypto.CipherParameters;
import shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import shaded.org.bouncycastle.crypto.agreement.ECDHCBasicAgreement;
import shaded.org.bouncycastle.crypto.agreement.Utils;
import shaded.org.bouncycastle.crypto.params.ECDHUPrivateParameters;
import shaded.org.bouncycastle.crypto.params.ECDHUPublicParameters;
import shaded.org.bouncycastle.util.BigIntegers;

public class ECDHCUnifiedAgreement {
    private ECDHUPrivateParameters privParams;

    public void init(CipherParameters cipherParameters) {
        this.privParams = (ECDHUPrivateParameters)cipherParameters;
        CryptoServicesRegistrar.checkConstraints(Utils.getDefaultProperties("ECCDHU", this.privParams.getStaticPrivateKey()));
    }

    public int getFieldSize() {
        return (this.privParams.getStaticPrivateKey().getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public byte[] calculateAgreement(CipherParameters cipherParameters) {
        ECDHUPublicParameters eCDHUPublicParameters = (ECDHUPublicParameters)cipherParameters;
        ECDHCBasicAgreement eCDHCBasicAgreement = new ECDHCBasicAgreement();
        ECDHCBasicAgreement eCDHCBasicAgreement2 = new ECDHCBasicAgreement();
        eCDHCBasicAgreement.init(this.privParams.getStaticPrivateKey());
        BigInteger bigInteger = eCDHCBasicAgreement.calculateAgreement(eCDHUPublicParameters.getStaticPublicKey());
        eCDHCBasicAgreement2.init(this.privParams.getEphemeralPrivateKey());
        BigInteger bigInteger2 = eCDHCBasicAgreement2.calculateAgreement(eCDHUPublicParameters.getEphemeralPublicKey());
        int n = this.getFieldSize();
        byte[] byArray = new byte[n * 2];
        BigIntegers.asUnsignedByteArray(bigInteger2, byArray, 0, n);
        BigIntegers.asUnsignedByteArray(bigInteger, byArray, n, n);
        return byArray;
    }
}

