/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import shaded.org.bouncycastle.asn1.ASN1Encodable;
import shaded.org.bouncycastle.asn1.ASN1EncodableVector;
import shaded.org.bouncycastle.asn1.ASN1Object;
import shaded.org.bouncycastle.asn1.ASN1OctetString;
import shaded.org.bouncycastle.asn1.ASN1Set;
import shaded.org.bouncycastle.asn1.BEROctetString;
import shaded.org.bouncycastle.asn1.BERSet;
import shaded.org.bouncycastle.asn1.DEROctetString;
import shaded.org.bouncycastle.asn1.DERSet;
import shaded.org.bouncycastle.asn1.cms.AuthenticatedData;
import shaded.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import shaded.org.bouncycastle.asn1.cms.ContentInfo;
import shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import shaded.org.bouncycastle.cms.CMSAuthenticatedData;
import shaded.org.bouncycastle.cms.CMSAuthenticatedGenerator;
import shaded.org.bouncycastle.cms.CMSException;
import shaded.org.bouncycastle.cms.CMSTypedData;
import shaded.org.bouncycastle.cms.DefaultAuthenticatedAttributeTableGenerator;
import shaded.org.bouncycastle.operator.DigestCalculator;
import shaded.org.bouncycastle.operator.DigestCalculatorProvider;
import shaded.org.bouncycastle.operator.MacCalculator;
import shaded.org.bouncycastle.operator.OperatorCreationException;
import shaded.org.bouncycastle.util.io.TeeOutputStream;

public class CMSAuthenticatedDataGenerator
extends CMSAuthenticatedGenerator {
    public CMSAuthenticatedData generate(CMSTypedData cMSTypedData, MacCalculator macCalculator) throws CMSException {
        return this.generate(cMSTypedData, macCalculator, null);
    }

    public CMSAuthenticatedData generate(CMSTypedData cMSTypedData, MacCalculator macCalculator, final DigestCalculator digestCalculator) throws CMSException {
        AuthenticatedData authenticatedData;
        Object object2;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (Object object2 : this.recipientInfoGenerators) {
            aSN1EncodableVector.add((ASN1Encodable)object2.generate(macCalculator.getKey()));
        }
        if (digestCalculator != null) {
            DEROctetString dEROctetString;
            Object object3;
            BEROctetString bEROctetString;
            Object object4;
            try {
                object2 = new ByteArrayOutputStream();
                object4 = new TeeOutputStream(digestCalculator.getOutputStream(), (OutputStream)object2);
                cMSTypedData.write((OutputStream)object4);
                ((OutputStream)object4).close();
                bEROctetString = new BEROctetString(((ByteArrayOutputStream)object2).toByteArray());
            }
            catch (IOException iOException) {
                throw new CMSException("unable to perform digest calculation: " + iOException.getMessage(), iOException);
            }
            object2 = this.getBaseParameters(cMSTypedData.getContentType(), digestCalculator.getAlgorithmIdentifier(), macCalculator.getAlgorithmIdentifier(), digestCalculator.getDigest());
            if (this.authGen == null) {
                this.authGen = new DefaultAuthenticatedAttributeTableGenerator();
            }
            object4 = new DERSet(this.authGen.getAttributes(Collections.unmodifiableMap(object2)).toASN1EncodableVector());
            try {
                object3 = macCalculator.getOutputStream();
                ((OutputStream)object3).write(((ASN1Object)object4).getEncoded("DER"));
                ((OutputStream)object3).close();
                dEROctetString = new DEROctetString(macCalculator.getMac());
            }
            catch (IOException iOException) {
                throw new CMSException("exception decoding algorithm parameters.", iOException);
            }
            object3 = this.unauthGen != null ? new BERSet(this.unauthGen.getAttributes(Collections.unmodifiableMap(object2)).toASN1EncodableVector()) : null;
            ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.data, (ASN1Encodable)bEROctetString);
            authenticatedData = new AuthenticatedData(this.originatorInfo, (ASN1Set)new DERSet(aSN1EncodableVector), macCalculator.getAlgorithmIdentifier(), digestCalculator.getAlgorithmIdentifier(), contentInfo, (ASN1Set)object4, (ASN1OctetString)dEROctetString, (ASN1Set)object3);
        } else {
            DEROctetString dEROctetString;
            BEROctetString bEROctetString;
            TeeOutputStream teeOutputStream;
            try {
                object2 = new ByteArrayOutputStream();
                teeOutputStream = new TeeOutputStream((OutputStream)object2, macCalculator.getOutputStream());
                cMSTypedData.write(teeOutputStream);
                ((OutputStream)teeOutputStream).close();
                bEROctetString = new BEROctetString(((ByteArrayOutputStream)object2).toByteArray());
                dEROctetString = new DEROctetString(macCalculator.getMac());
            }
            catch (IOException iOException) {
                throw new CMSException("exception decoding algorithm parameters.", iOException);
            }
            object2 = this.unauthGen != null ? new BERSet(this.unauthGen.getAttributes(new HashMap()).toASN1EncodableVector()) : null;
            teeOutputStream = new ContentInfo(CMSObjectIdentifiers.data, (ASN1Encodable)bEROctetString);
            authenticatedData = new AuthenticatedData(this.originatorInfo, (ASN1Set)new DERSet(aSN1EncodableVector), macCalculator.getAlgorithmIdentifier(), null, (ContentInfo)teeOutputStream, null, (ASN1OctetString)dEROctetString, (ASN1Set)object2);
        }
        object2 = new ContentInfo(CMSObjectIdentifiers.authenticatedData, (ASN1Encodable)authenticatedData);
        return new CMSAuthenticatedData((ContentInfo)object2, new DigestCalculatorProvider(){

            public DigestCalculator get(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
                return digestCalculator;
            }
        });
    }
}

