/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.cert.crmf;

import java.io.IOException;
import java.io.OutputStream;
import shaded.org.bouncycastle.asn1.cmp.PBMParameter;
import shaded.org.bouncycastle.asn1.crmf.PKMACValue;
import shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import shaded.org.bouncycastle.cert.crmf.CRMFException;
import shaded.org.bouncycastle.cert.crmf.PKMACBuilder;
import shaded.org.bouncycastle.operator.MacCalculator;
import shaded.org.bouncycastle.util.Arrays;

class PKMACValueVerifier {
    private final PKMACBuilder builder;

    public PKMACValueVerifier(PKMACBuilder pKMACBuilder) {
        this.builder = pKMACBuilder;
    }

    public boolean isValid(PKMACValue pKMACValue, char[] cArray, SubjectPublicKeyInfo subjectPublicKeyInfo) throws CRMFException {
        this.builder.setParameters(PBMParameter.getInstance((Object)pKMACValue.getAlgId().getParameters()));
        MacCalculator macCalculator = this.builder.build(cArray);
        OutputStream outputStream = macCalculator.getOutputStream();
        try {
            outputStream.write(subjectPublicKeyInfo.getEncoded("DER"));
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new CRMFException("exception encoding mac input: " + iOException.getMessage(), iOException);
        }
        return Arrays.areEqual(macCalculator.getMac(), pKMACValue.getValue().getBytes());
    }
}

