/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.util;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import shaded.cfca.sadk.algorithm.common.Mechanism;
import shaded.cfca.sadk.algorithm.common.PKIException;
import shaded.cfca.sadk.algorithm.sm2.SM2PrivateKey;
import shaded.cfca.sadk.algorithm.sm2.SM2PublicKey;
import shaded.cfca.sadk.algorithm.util.InitKeyStore;
import shaded.cfca.sadk.asn1.parser.ASN1Parser;
import shaded.cfca.sadk.asn1.pkcs.PKCS12;
import shaded.cfca.sadk.asn1.pkcs.PKCS12_SM2;
import shaded.cfca.sadk.lib.crypto.Session;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import shaded.cfca.sadk.util.Base64;

public class KeyUtil {
    public static PrivateKey getPrivateKeyFromPFX(InputStream inputStream, String pfxFilePwd) throws PKIException {
        PKCS12 pkcs12 = new PKCS12();
        pkcs12.load(inputStream);
        pkcs12.decrypt(pfxFilePwd.toCharArray());
        return pkcs12.getPrivateKey();
    }

    public static PrivateKey getPrivateKeyFromPFX(String pfxFilePath, String pfxFilePwd) throws PKIException {
        PKCS12 pkcs12 = new PKCS12();
        pkcs12.load(pfxFilePath);
        pkcs12.decrypt(pfxFilePwd.toCharArray());
        return pkcs12.getPrivateKey();
    }

    public static PrivateKey getPrivateKeyFromPFX(byte[] pfxFileData, String pfxFilePwd) throws PKIException {
        PKCS12 pkcs12 = new PKCS12();
        pkcs12.load(pfxFileData);
        pkcs12.decrypt(pfxFilePwd.toCharArray());
        return pkcs12.getPrivateKey();
    }

    public static SM2PrivateKey getPrivateKeyFromSM2(String sm2FilePath, String sm2FilePwd) throws PKIException {
        FilterInputStream ais = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(sm2FilePath);
            byte[] data = new byte[fis.available()];
            fis.read(data);
            fis.close();
            boolean isB64 = ASN1Parser.isBase64Compatability(data);
            if (isB64) {
                data = Base64.decode(data);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            ais = new ASN1InputStream(bis);
            PKCS12_SM2 sm2Pfx = PKCS12_SM2.getInstance(((ASN1InputStream)ais).readObject());
            SM2PrivateKey sM2PrivateKey = sm2Pfx.getPrivateKey(sm2FilePwd);
            return sM2PrivateKey;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            if (ais != null) {
                try {
                    ais.close();
                }
                catch (IOException e) {
                    throw new PKIException(e.getMessage());
                }
            }
        }
    }

    public static SM2PrivateKey getPrivateKeyFromSM2(InputStream inputStream, String sm2FilePwd) throws PKIException {
        FilterInputStream ais = null;
        try {
            byte[] data = new byte[inputStream.available()];
            inputStream.read(data);
            boolean isB64 = ASN1Parser.isBase64Compatability(data);
            if (isB64) {
                data = Base64.decode(data);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            ais = new ASN1InputStream(bis);
            PKCS12_SM2 object = PKCS12_SM2.getInstance(((ASN1InputStream)ais).readObject());
            SM2PrivateKey sM2PrivateKey = object.getPrivateKey(sm2FilePwd);
            return sM2PrivateKey;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            if (ais != null) {
                try {
                    ais.close();
                }
                catch (IOException e) {
                    throw new PKIException(e.getMessage());
                }
            }
        }
    }

    public static SM2PrivateKey getPrivateKeyFromSM2(byte[] sm2FileData, String sm2FilePwd) throws PKIException {
        FilterInputStream ais = null;
        try {
            boolean isB64 = ASN1Parser.isBase64Compatability(sm2FileData);
            if (isB64) {
                sm2FileData = Base64.decode(sm2FileData);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(sm2FileData);
            ais = new ASN1InputStream(bis);
            PKCS12_SM2 object = PKCS12_SM2.getInstance(((ASN1InputStream)ais).readObject());
            SM2PrivateKey sM2PrivateKey = object.getPrivateKey(sm2FilePwd);
            return sM2PrivateKey;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
        finally {
            if (ais != null) {
                try {
                    ais.close();
                }
                catch (IOException e) {
                    throw new PKIException(e.getMessage());
                }
            }
        }
    }

    public static PrivateKey getPrivateKeyFromJKS(String jksFilePath, String jksFilePwd, String alias) throws PKIException {
        try {
            KeyStore ks = InitKeyStore.initJKSKeyStore(jksFilePath, jksFilePwd);
            char[] password = jksFilePwd.toCharArray();
            return (PrivateKey)ks.getKey(alias, password);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static PrivateKey getPrivateKeyFromJKS(InputStream is, String jksFilePwd, String alias) throws PKIException {
        try {
            KeyStore ks = InitKeyStore.initJKSKeyStore(is, jksFilePwd);
            char[] password = jksFilePwd.toCharArray();
            return (PrivateKey)ks.getKey(alias, password);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static KeyPair generateKeyPair(Mechanism mechanism, int keyLength, Session session) throws PKIException {
        if ("SM2".equals(mechanism.getMechanismType()) && 256 != keyLength) {
            throw new PKIException("key length must be 256 bits for SM2");
        }
        return session.generateKeyPair(mechanism, keyLength);
    }

    public static Key generateKey(Mechanism keyType, Session session) throws PKIException {
        return session.generateKey(keyType);
    }

    public static Key generateKey(Mechanism keyType, byte[] keyData, Session session) throws PKIException {
        return session.generateKey(keyType, keyData);
    }

    public static SM2PublicKey getSM2PublicKey(byte[] pubX, byte[] pubY) {
        return new SM2PublicKey(pubX, pubY);
    }

    public static SM2PrivateKey getSM2PrivateKey(byte[] da, byte[] pubX, byte[] pubY) {
        return new SM2PrivateKey(da, pubX, pubY);
    }
}

