/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.signature.sm2;

import java.math.BigInteger;
import java.security.Key;
import shaded.cfca.sadk.algorithm.common.PKIException;
import shaded.cfca.sadk.algorithm.sm2.SM2PrivateKey;
import shaded.cfca.sadk.algorithm.sm2.SM2PublicKey;
import shaded.cfca.sadk.algorithm.sm2.SM2Result;
import shaded.cfca.sadk.algorithm.util.BigIntegerUtil;
import shaded.cfca.sadk.lib.crypto.bcsoft.BCSoftSM2;
import shaded.cfca.sadk.lib.crypto.jni.JNISM2;

public class SM2PackageUtil {
    public static byte[] encryptByBC(byte[] digestData, Key privateKey) throws Exception {
        byte[] sign = new byte[64];
        if (digestData == null || digestData.length != 32) {
            throw new Exception("the digest data is null or not 32 bytes!");
        }
        SM2PrivateKey key = null;
        if (!(privateKey instanceof SM2PrivateKey)) {
            throw new PKIException("The private key type is not sm2 type!");
        }
        key = (SM2PrivateKey)privateKey;
        BCSoftSM2 bcSoftSM2 = new BCSoftSM2();
        SM2Result sm2Ret = new SM2Result();
        bcSoftSM2.sign(digestData, key.getDByInt(), sm2Ret);
        System.arraycopy(BigIntegerUtil.asUnsigned32ByteArray(sm2Ret.r), 0, sign, 0, 32);
        System.arraycopy(BigIntegerUtil.asUnsigned32ByteArray(sm2Ret.s), 0, sign, 32, 32);
        return sign;
    }

    public static boolean verifyByBC(byte[] digestData, byte[] signature, Key publicKey) throws Exception {
        byte[] r = new byte[32];
        byte[] s = new byte[32];
        SM2PublicKey key = null;
        if (!(publicKey instanceof SM2PublicKey)) {
            throw new PKIException("the key type is not SM2 public key");
        }
        key = (SM2PublicKey)publicKey;
        if (digestData == null || digestData.length != 32) {
            throw new Exception("the digest data is null or not 32 bytes!");
        }
        if (signature == null || signature.length != 64) {
            throw new Exception("the signature data is null or not 64 bytes!");
        }
        System.arraycopy(signature, 0, r, 0, 32);
        System.arraycopy(signature, 32, s, 0, 32);
        BCSoftSM2 sm2 = new BCSoftSM2();
        SM2Result sm2Ret = new SM2Result();
        sm2Ret.r = new BigInteger(1, r);
        sm2Ret.s = new BigInteger(1, s);
        return sm2.verify(digestData, key.getQ(), sm2Ret);
    }

    public static final byte[] encryptByJNI(byte[] digestData, BigInteger da) throws Exception {
        byte[] sign = new byte[64];
        byte[] r = new byte[32];
        byte[] s = new byte[32];
        if (digestData == null || digestData.length != 32) {
            throw new Exception("the digest data is null or not 32 bytes!");
        }
        JNISM2.sign(digestData, BigIntegerUtil.asUnsigned32ByteArray(da), r, s);
        System.arraycopy(r, 0, sign, 0, 32);
        System.arraycopy(s, 0, sign, 32, 32);
        return sign;
    }

    public static boolean verifyByJNI(byte[] digestData, byte[] signature, byte[] pubX, byte[] pubY) throws Exception {
        byte[] r = new byte[32];
        byte[] s = new byte[32];
        if (digestData == null || digestData.length != 32) {
            throw new Exception("the digest data is null or not 32 bytes!");
        }
        if (signature == null || signature.length != 64) {
            throw new Exception("the signature data is null or not 64 bytes!");
        }
        System.arraycopy(signature, 0, r, 0, 32);
        System.arraycopy(signature, 32, s, 0, 32);
        return JNISM2.verify(r, s, pubX, pubY, digestData);
    }
}

