/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.openssl.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Security;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import shaded.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import shaded.cfca.sadk.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import shaded.cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import shaded.cfca.sadk.org.bouncycastle.openssl.PEMParser;
import shaded.cfca.sadk.org.bouncycastle.openssl.PEMWriter;
import shaded.cfca.sadk.org.bouncycastle.openssl.PKCS8Generator;
import shaded.cfca.sadk.org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import shaded.cfca.sadk.org.bouncycastle.openssl.jcajce.JcaPKCS8Generator;
import shaded.cfca.sadk.org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import shaded.cfca.sadk.org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8EncryptorBuilder;
import shaded.cfca.sadk.org.bouncycastle.openssl.test.ParserTest;
import shaded.cfca.sadk.org.bouncycastle.openssl.test.WriterTest;
import shaded.cfca.sadk.org.bouncycastle.operator.OperatorCreationException;
import shaded.cfca.sadk.org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import shaded.cfca.sadk.org.bouncycastle.pkcs.PKCSException;
import shaded.cfca.sadk.org.bouncycastle.util.test.SimpleTestResult;

public class AllTests
extends TestCase {
    public void testOpenSSL() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        shaded.cfca.sadk.org.bouncycastle.util.test.Test[] tests = new shaded.cfca.sadk.org.bouncycastle.util.test.Test[]{new WriterTest(), new ParserTest()};
        for (int i = 0; i != tests.length; ++i) {
            SimpleTestResult result = (SimpleTestResult)tests[i].perform();
            if (result.isSuccessful()) continue;
            AllTests.fail((String)result.toString());
        }
    }

    public void testPKCS8Encrypted() throws Exception {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA", "BC");
        kpGen.initialize(1024);
        PrivateKey key = kpGen.generateKeyPair().getPrivate();
        this.encryptedTestNew(key, PKCS8Generator.AES_256_CBC);
        this.encryptedTestNew(key, PKCS8Generator.DES3_CBC);
        this.encryptedTestNew(key, PKCS8Generator.PBE_SHA1_3DES);
    }

    private void encryptedTestNew(PrivateKey key, ASN1ObjectIdentifier algorithm) throws NoSuchProviderException, NoSuchAlgorithmException, IOException, OperatorCreationException, PKCSException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        PEMWriter pWrt = new PEMWriter(new OutputStreamWriter(bOut));
        JceOpenSSLPKCS8EncryptorBuilder encryptorBuilder = new JceOpenSSLPKCS8EncryptorBuilder(algorithm);
        encryptorBuilder.setProvider("BC");
        encryptorBuilder.setPasssword("hello".toCharArray());
        JcaPKCS8Generator pkcs8 = new JcaPKCS8Generator(key, encryptorBuilder.build());
        pWrt.writeObject(pkcs8);
        pWrt.close();
        PEMParser pRd = new PEMParser(new InputStreamReader(new ByteArrayInputStream(bOut.toByteArray())));
        PKCS8EncryptedPrivateKeyInfo pInfo = (PKCS8EncryptedPrivateKeyInfo)pRd.readObject();
        PrivateKey rdKey = new JcaPEMKeyConverter().setProvider("BC").getPrivateKey(pInfo.decryptPrivateKeyInfo(new JceOpenSSLPKCS8DecryptorProviderBuilder().setProvider("BC").build("hello".toCharArray())));
        AllTests.assertEquals((Object)key, (Object)rdKey);
    }

    public void testPKCS8PlainNew() throws Exception {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA", "BC");
        kpGen.initialize(1024);
        PrivateKey key = kpGen.generateKeyPair().getPrivate();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        PEMWriter pWrt = new PEMWriter(new OutputStreamWriter(bOut));
        JcaPKCS8Generator pkcs8 = new JcaPKCS8Generator(key, null);
        pWrt.writeObject(pkcs8);
        pWrt.close();
        PEMParser pRd = new PEMParser(new InputStreamReader(new ByteArrayInputStream(bOut.toByteArray())));
        PrivateKeyInfo kp = (PrivateKeyInfo)pRd.readObject();
        PrivateKey rdKey = new JcaPEMKeyConverter().setProvider("BC").getPrivateKey(kp);
        AllTests.assertEquals((Object)key, (Object)rdKey);
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        TestRunner.run((Test)AllTests.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("OpenSSL Tests");
        suite.addTestSuite(AllTests.class);
        return suite;
    }
}

