/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.openssl.jcajce;

import java.security.Provider;
import shaded.cfca.sadk.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import shaded.cfca.sadk.org.bouncycastle.jcajce.util.JcaJceHelper;
import shaded.cfca.sadk.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import shaded.cfca.sadk.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import shaded.cfca.sadk.org.bouncycastle.openssl.PEMDecryptor;
import shaded.cfca.sadk.org.bouncycastle.openssl.PEMDecryptorProvider;
import shaded.cfca.sadk.org.bouncycastle.openssl.PEMException;
import shaded.cfca.sadk.org.bouncycastle.openssl.PasswordException;
import shaded.cfca.sadk.org.bouncycastle.openssl.jcajce.PEMUtilities;

public class JcePEMDecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JcePEMDecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePEMDecryptorProviderBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public PEMDecryptorProvider build(final char[] password) {
        return new PEMDecryptorProvider(){

            public PEMDecryptor get(final String dekAlgName) {
                return new PEMDecryptor(){

                    public byte[] decrypt(byte[] keyBytes, byte[] iv) throws PEMException {
                        if (password == null) {
                            throw new PasswordException("Password is null, but a password is required");
                        }
                        return PEMUtilities.crypt(false, JcePEMDecryptorProviderBuilder.this.helper, keyBytes, password, dekAlgName, iv);
                    }
                };
            }
        };
    }
}

