/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.math.ec;

import java.math.BigInteger;
import shaded.cfca.sadk.org.bouncycastle.math.ec.AbstractECMultiplier;
import shaded.cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import shaded.cfca.sadk.org.bouncycastle.math.ec.WNafUtil;

public class NafL2RMultiplier
extends AbstractECMultiplier {
    protected ECPoint multiplyPositive(ECPoint p, BigInteger k) {
        int[] naf = WNafUtil.generateCompactNaf(k);
        ECPoint addP = p.normalize();
        ECPoint subP = addP.negate();
        ECPoint R = p.getCurve().getInfinity();
        int i = naf.length;
        while (--i >= 0) {
            int ni = naf[i];
            int digit = ni >> 16;
            int zeroes = ni & 0xFFFF;
            R = R.twicePlus(digit < 0 ? subP : addP);
            R = R.timesPow2(zeroes);
        }
        return R;
    }
}

