/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.math.ec;

import java.math.BigInteger;
import shaded.cfca.sadk.org.bouncycastle.math.ec.AbstractECMultiplier;
import shaded.cfca.sadk.org.bouncycastle.math.ec.ECAlgorithms;
import shaded.cfca.sadk.org.bouncycastle.math.ec.ECCurve;
import shaded.cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import shaded.cfca.sadk.org.bouncycastle.math.ec.ECPointMap;
import shaded.cfca.sadk.org.bouncycastle.math.ec.endo.GLVEndomorphism;

public class GLVMultiplier
extends AbstractECMultiplier {
    protected final ECCurve curve;
    protected final GLVEndomorphism glvEndomorphism;

    public GLVMultiplier(ECCurve curve, GLVEndomorphism glvEndomorphism) {
        if (curve == null || curve.getOrder() == null) {
            throw new IllegalArgumentException("Need curve with known group order");
        }
        this.curve = curve;
        this.glvEndomorphism = glvEndomorphism;
    }

    protected ECPoint multiplyPositive(ECPoint p, BigInteger k) {
        if (!this.curve.equals(p.getCurve())) {
            throw new IllegalStateException();
        }
        BigInteger n = p.getCurve().getOrder();
        BigInteger[] ab = this.glvEndomorphism.decomposeScalar(k.mod(n));
        BigInteger a = ab[0];
        BigInteger b = ab[1];
        ECPointMap pointMap = this.glvEndomorphism.getPointMap();
        if (this.glvEndomorphism.hasEfficientPointMap()) {
            return ECAlgorithms.implShamirsTrickWNaf(p, a, pointMap, b);
        }
        return ECAlgorithms.implShamirsTrickWNaf(p, a, pointMap.map(p), b);
    }
}

