/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.jce.provider.test;

import java.security.MessageDigest;
import java.security.Security;
import shaded.cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import shaded.cfca.sadk.org.bouncycastle.util.encoders.Hex;
import shaded.cfca.sadk.org.bouncycastle.util.test.SimpleTest;

public class SHA3Test
extends SimpleTest {
    static final String provider = "BC";
    private static byte[] nullMsg = new byte[0];
    private static String[][] nullVectors = new String[][]{{"SHA3-224", "f71837502ba8e10837bdd8d365adb85591895602fc552b48b7390abd"}, {"SHA3-256", "c5d2460186f7233c927e7db2dcc703c0e500b653ca82273b7bfad8045d85a470"}, {"SHA3-384", "2c23146a63a29acf99e73b88f8c24eaa7dc60aa771780ccc006afbfa8fe2479b2dd2b21362337441ac12b515911957ff"}, {"SHA3-512", "0eab42de4c3ceb9235fc91acffe746b29c29a8c366b7c60e4e67c466f36a4304c00fa9caf9d87976ba469bcbe06713b435f091ef2769fb160cdab33d3670680e"}};
    private static byte[] shortMsg = Hex.decode("54686520717569636b2062726f776e20666f78206a756d7073206f76657220746865206c617a7920646f67");
    private static String[][] shortVectors = new String[][]{{"SHA3-224", "310aee6b30c47350576ac2873fa89fd190cdc488442f3ef654cf23fe"}, {"SHA3-256", "4d741b6f1eb29cb2a9b9911c82f56fa8d73b04959d3d9d222895df6c0b28aa15"}, {"SHA3-384", "283990fa9d5fb731d786c5bbee94ea4db4910f18c62c03d173fc0a5e494422e8a0b3da7574dae7fa0baf005e504063b3"}, {"SHA3-512", "d135bb84d0439dbac432247ee573a23ea7d3c9deb2a968eb31d47c4fb45f1ef4422d6c531b5b9bd6f449ebcc449ea94d0a8f05f62130fda612da53c79659f609"}};

    public String getName() {
        return "SHA3";
    }

    void test(String algorithm, byte[] message, String expected) throws Exception {
        MessageDigest digest = MessageDigest.getInstance(algorithm, provider);
        byte[] result = digest.digest(message);
        byte[] result2 = digest.digest(message);
        if (!MessageDigest.isEqual(result, Hex.decode(expected))) {
            this.fail("null result not equal for " + algorithm);
        }
        if (!MessageDigest.isEqual(result, result2)) {
            this.fail("Result object 1 not equal");
        }
        if (!MessageDigest.isEqual(result, Hex.decode(expected))) {
            this.fail("Result object 1 not equal");
        }
        for (int i = 0; i < message.length; ++i) {
            digest.update(message[i]);
        }
        result2 = digest.digest();
        if (!MessageDigest.isEqual(result, result2)) {
            this.fail("Result object 2 not equal");
        }
        digest.update(message, 0, message.length / 2);
        digest.update(message, message.length / 2, message.length - message.length / 2);
        result2 = digest.digest();
        if (!MessageDigest.isEqual(result, result2)) {
            this.fail("Result object 3 not equal");
        }
        digest.update(message, 0, message.length / 2);
        MessageDigest d = (MessageDigest)digest.clone();
        digest.update(message, message.length / 2, message.length - message.length / 2);
        result2 = digest.digest();
        if (!MessageDigest.isEqual(result, result2)) {
            this.fail("Result object 4(a) not equal");
        }
        d.update(message, message.length / 2, message.length - message.length / 2);
        result2 = d.digest();
        if (!MessageDigest.isEqual(result, result2)) {
            this.fail("Result object 4(b) not equal");
        }
        digest.update(message, 0, message.length / 2);
        digest.reset();
        digest.update(message, 0, message.length / 2);
        digest.update(message, message.length / 2, message.length - message.length / 2);
        result2 = digest.digest();
        if (!MessageDigest.isEqual(result, result2)) {
            this.fail("Result object 5 not equal");
        }
    }

    public void performTest() throws Exception {
        for (int i = 0; i != nullVectors.length; ++i) {
            this.test(nullVectors[i][0], nullMsg, nullVectors[i][1]);
            this.test(shortVectors[i][0], shortMsg, shortVectors[i][1]);
        }
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        SHA3Test.runTest(new SHA3Test());
    }
}

