/*
 * Decompiled with CFR 0.152.
 */
package shaded.cfca.sadk.org.bouncycastle.jce.provider.test;

import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import shaded.cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import shaded.cfca.sadk.org.bouncycastle.util.test.SimpleTestResult;
import shaded.cfca.sadk.org.bouncycastle.util.test.Test;
import shaded.cfca.sadk.org.bouncycastle.util.test.TestResult;

public class DoFinalTest
implements Test {
    private boolean equalArray(byte[] a, int aOff, byte[] b, int length) {
        if (aOff + a.length < length) {
            return false;
        }
        if (b.length < length) {
            return false;
        }
        for (int i = 0; i != length; ++i) {
            if (a[aOff + i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public TestResult checkCipher(String cipherName) {
        String lCode = "ABCDEFGHIJKLMNOPQRSTUVWXY0123456789";
        int index = cipherName.indexOf(47);
        String baseAlgorithm = index > 0 ? cipherName.substring(0, index) : cipherName;
        try {
            byte[] enc2;
            KeyGenerator kGen = KeyGenerator.getInstance(baseAlgorithm, "BC");
            Cipher cipher = Cipher.getInstance(cipherName, "BC");
            SecretKey key = kGen.generateKey();
            cipher.init(1, key);
            byte[] encrypted = cipher.doFinal(lCode.getBytes());
            byte[] encrypted2 = cipher.doFinal(lCode.getBytes());
            if (encrypted.length != encrypted2.length) {
                return new SimpleTestResult(false, this.getName() + ": Failed " + cipherName + " - expected length " + encrypted.length + " got " + encrypted2.length);
            }
            if (!this.equalArray(encrypted, 0, encrypted2, encrypted.length)) {
                return new SimpleTestResult(false, this.getName() + ": Failed " + cipherName + " - first two arrays not equal");
            }
            byte[] enc1 = cipher.update(lCode.getBytes());
            if (enc1.length + (enc2 = cipher.doFinal()).length != encrypted.length) {
                return new SimpleTestResult(false, this.getName() + ": Failed " + cipherName + " - expected length " + encrypted.length + " got " + (enc1.length + enc2.length));
            }
            if (!this.equalArray(encrypted, 0, enc1, enc1.length)) {
                return new SimpleTestResult(false, this.getName() + ": Failed " + cipherName + " - enc1 array not equal");
            }
            if (!this.equalArray(encrypted, enc1.length, enc2, enc2.length)) {
                return new SimpleTestResult(false, this.getName() + ": Failed " + cipherName + " - enc1 array not equal");
            }
            enc1 = cipher.update(lCode.getBytes());
            if (!this.equalArray(encrypted, 0, enc1, enc1.length)) {
                return new SimpleTestResult(false, this.getName() + ": Failed " + cipherName + " - 2nd enc1 array not equal");
            }
            int len = cipher.doFinal(enc1, 0);
            if (enc1.length + len != encrypted.length) {
                return new SimpleTestResult(false, this.getName() + ": Failed " + cipherName + " - expected length " + encrypted.length + " got " + (enc1.length + len));
            }
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": Failed " + cipherName + " - exception " + e.toString());
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult perform() {
        TestResult result = this.checkCipher("RC4");
        if (!result.isSuccessful()) {
            return result;
        }
        result = this.checkCipher("DES/CBC/PKCS5Padding");
        if (!result.isSuccessful()) {
            return result;
        }
        return this.checkCipher("Rijndael");
    }

    public String getName() {
        return "DoFinalTest";
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        DoFinalTest test = new DoFinalTest();
        TestResult result = test.perform();
        System.out.println(((Object)result).toString());
    }
}

